/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.hive.utils;

import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseSourceConfigOptions;

public final class HiveMetaStoreProxyUtils {
    public static boolean enableKerberos(ReadonlyConfig config) {
        boolean kerberosPrincipalEmpty = config.getOptional(BaseSourceConfigOptions.KERBEROS_PRINCIPAL).isPresent();
        boolean kerberosKeytabPathEmpty = config.getOptional(BaseSourceConfigOptions.KERBEROS_KEYTAB_PATH).isPresent();
        if (kerberosKeytabPathEmpty && kerberosPrincipalEmpty) {
            return true;
        }
        if (!kerberosPrincipalEmpty && !kerberosKeytabPathEmpty) {
            return false;
        }
        if (kerberosPrincipalEmpty) {
            throw new IllegalArgumentException("Please set kerberosPrincipal");
        }
        throw new IllegalArgumentException("Please set kerberosKeytabPath");
    }

    public static boolean enableRemoteUser(ReadonlyConfig config) {
        return config.getOptional(BaseSourceConfigOptions.REMOTE_USER).isPresent();
    }

    private HiveMetaStoreProxyUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

