/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.hive.utils;

import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.exception.SeaTunnelRuntimeException;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.hive.exception.HiveConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.hive.exception.HiveConnectorException;
import org.apache.seatunnel.connectors.seatunnel.hive.source.config.HiveSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.hive.utils.HiveMetaStoreProxy;

public class HiveTableUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Table getTableInfo(ReadonlyConfig readonlyConfig) {
        String table = (String)readonlyConfig.get(HiveSourceOptions.TABLE_NAME);
        TablePath tablePath = TablePath.of((String)table);
        if (tablePath.getDatabaseName() == null || tablePath.getTableName() == null) {
            throw new SeaTunnelRuntimeException((SeaTunnelErrorCode)HiveConnectorErrorCode.HIVE_TABLE_NAME_ERROR, "Current table name is " + table);
        }
        try (HiveMetaStoreProxy hiveMetaStoreProxy = HiveMetaStoreProxy.getInstance(readonlyConfig);){
            Table table2 = hiveMetaStoreProxy.getTable(tablePath.getDatabaseName(), tablePath.getTableName());
            return table2;
        }
    }

    public static FileFormat parseFileFormat(Table table) {
        String inputFormat = table.getSd().getInputFormat();
        if ("org.apache.hadoop.mapred.TextInputFormat".equals(inputFormat)) {
            return FileFormat.TEXT;
        }
        if ("org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat".equals(inputFormat)) {
            return FileFormat.PARQUET;
        }
        if ("org.apache.hadoop.hive.ql.io.orc.OrcInputFormat".equals(inputFormat)) {
            return FileFormat.ORC;
        }
        throw new HiveConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "Hive connector only support [text parquet orc] table now");
    }
}

