/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.file.org.apache.orc.storage.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.seatunnel.shade.connector.file.org.apache.orc.storage.ql.exec.vector.BytesColumnVector;

public class StringExpr {
    public static int compare(byte[] arg1, int start1, int len1, byte[] arg2, int start2, int len2) {
        for (int i = 0; i < len1 && i < len2; ++i) {
            int b1 = arg1[i + start1] & 0xFF;
            int b2 = arg2[i + start2] & 0xFF;
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return len1 - len2;
    }

    public static boolean equal(byte[] arg1, int start1, int len1, byte[] arg2, int start2, int len2) {
        if (len1 != len2) {
            return false;
        }
        if (len1 == 0) {
            return true;
        }
        if (arg1[start1] != arg2[start2] || arg1[start1 + len1 - 1] != arg2[start2 + len2 - 1]) {
            return false;
        }
        if (len1 == len2) {
            int wlen;
            int i;
            int step = 8;
            int remainder = len1 % 8;
            for (i = wlen = len1 - remainder; i < len1; ++i) {
                if (arg1[start1 + i] == arg2[start2 + i]) continue;
                return false;
            }
            for (i = 0; i < wlen; i += 8) {
                int s1 = start1 + i;
                int s2 = start2 + i;
                boolean neq = false;
                for (int j = 0; j < 8; ++j) {
                    neq = arg1[s1 + j] != arg2[s2 + j] || neq;
                }
                if (!neq) continue;
                return false;
            }
        }
        return true;
    }

    public static int characterCount(byte[] bytes) {
        int end = bytes.length;
        int charCount = 0;
        for (int j = 0; j < end; ++j) {
            if ((bytes[j] & 0xC0) == 128) continue;
            ++charCount;
        }
        return charCount;
    }

    public static int characterCount(byte[] bytes, int start, int length) {
        int end = start + length;
        int charCount = 0;
        for (int j = start; j < end; ++j) {
            if ((bytes[j] & 0xC0) == 128) continue;
            ++charCount;
        }
        return charCount;
    }

    public static void assign(BytesColumnVector outV, int i, byte[] bytes, int start, int length) {
        outV.setVal(i, bytes, start, length);
    }

    public static int rightTrim(byte[] bytes, int start, int length) {
        int j;
        for (j = start + length - 1; j >= start && bytes[j] == 32; --j) {
        }
        return j - start + 1;
    }

    public static void rightTrim(BytesColumnVector outV, int i, byte[] bytes, int start, int length) {
        int j;
        for (j = start + length - 1; j >= start && bytes[j] == 32; --j) {
        }
        outV.setVal(i, bytes, start, j - start + 1);
    }

    public static int truncate(byte[] bytes, int start, int length, int maxLength) {
        int j;
        int end = start + length;
        int charCount = 0;
        for (j = start; j < end; ++j) {
            if ((bytes[j] & 0xC0) == 128) continue;
            if (charCount == maxLength) break;
            ++charCount;
        }
        return j - start;
    }

    public static void truncate(BytesColumnVector outV, int i, byte[] bytes, int start, int length, int maxLength) {
        int j;
        int end = start + length;
        int charCount = 0;
        for (j = start; j < end; ++j) {
            if ((bytes[j] & 0xC0) == 128) continue;
            if (charCount == maxLength) break;
            ++charCount;
        }
        outV.setVal(i, bytes, start, j - start);
    }

    public static byte[] truncateScalar(byte[] bytes, int maxLength) {
        int j;
        int end = bytes.length;
        int charCount = 0;
        for (j = 0; j < end; ++j) {
            if ((bytes[j] & 0xC0) == 128) continue;
            if (charCount == maxLength) break;
            ++charCount;
        }
        if (j == end) {
            return bytes;
        }
        return Arrays.copyOf(bytes, j);
    }

    public static int rightTrimAndTruncate(byte[] bytes, int start, int length, int maxLength) {
        int j;
        int end = start + length;
        int charCount = 0;
        int padRunStart = -1;
        for (j = start; j < end; ++j) {
            if ((bytes[j] & 0xC0) != 128) {
                if (charCount == maxLength) break;
                if (bytes[j] == 32) {
                    if (padRunStart == -1) {
                        padRunStart = j;
                    }
                } else {
                    padRunStart = -1;
                }
                ++charCount;
                continue;
            }
            padRunStart = -1;
        }
        if (padRunStart != -1) {
            return padRunStart - start;
        }
        return j - start;
    }

    public static void rightTrimAndTruncate(BytesColumnVector outV, int i, byte[] bytes, int start, int length, int maxLength) {
        int j;
        int end = start + length;
        int charCount = 0;
        int padRunStart = -1;
        for (j = start; j < end; ++j) {
            if ((bytes[j] & 0xC0) != 128) {
                if (charCount == maxLength) break;
                if (bytes[j] == 32) {
                    if (padRunStart == -1) {
                        padRunStart = j;
                    }
                } else {
                    padRunStart = -1;
                }
                ++charCount;
                continue;
            }
            padRunStart = -1;
        }
        if (padRunStart != -1) {
            outV.setVal(i, bytes, start, padRunStart - start);
        } else {
            outV.setVal(i, bytes, start, j - start);
        }
    }

    public static byte[] rightTrimAndTruncateScalar(byte[] bytes, int maxLength) {
        int j;
        int end = bytes.length;
        int charCount = 0;
        int padRunStart = -1;
        for (j = 0; j < end; ++j) {
            if ((bytes[j] & 0xC0) != 128) {
                if (charCount == maxLength) break;
                if (bytes[j] == 32) {
                    if (padRunStart == -1) {
                        padRunStart = j;
                    }
                } else {
                    padRunStart = -1;
                }
                ++charCount;
                continue;
            }
            padRunStart = -1;
        }
        if (padRunStart != -1) {
            return Arrays.copyOf(bytes, padRunStart);
        }
        if (j == end) {
            return bytes;
        }
        return Arrays.copyOf(bytes, j);
    }

    public static Finder compile(byte[] pattern) {
        return new BoyerMooreHorspool(pattern);
    }

    private static class BoyerMooreHorspool
    implements Finder {
        private static final int MAX_BYTE = 255;
        private final long[] shift = new long[255];
        private final byte[] pattern;
        private final int plen;

        public BoyerMooreHorspool(byte[] pattern) {
            this.pattern = pattern;
            this.plen = pattern.length;
            Arrays.fill(this.shift, (long)this.plen);
            for (int i = 0; i < this.plen - 1; ++i) {
                this.shift[pattern[i] & 0xFF] = this.plen - i - 1;
            }
        }

        @Override
        public int find(byte[] input, int start, int len) {
            if (this.pattern.length == 0) {
                return 0;
            }
            int end = start + len;
            int next = start + this.plen - 1;
            int plen = this.plen;
            byte[] pattern = this.pattern;
            while (next < end) {
                int s_tmp = next;
                int p_tmp = plen - 1;
                while (input[s_tmp] == pattern[p_tmp]) {
                    if (--p_tmp < 0) {
                        return s_tmp;
                    }
                    --s_tmp;
                }
                next = (int)((long)next + this.shift[input[next] & 0xFF]);
            }
            return -1;
        }
    }

    public static interface Finder {
        public int find(byte[] var1, int var2, int var3);
    }
}

