/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.hive.org.apache.orc.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.CompressionCodec;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.CompressionKind;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.OrcFile;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.OrcProto;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.StripeInformation;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.StripeStatistics;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.impl.OrcCodecPool;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.impl.ReaderImpl;

public final class OrcTail {
    private final OrcProto.FileTail fileTail;
    private final ByteBuffer serializedTail;
    private final long fileModificationTime;
    private OrcProto.Metadata metadata;

    public OrcTail(OrcProto.FileTail fileTail, ByteBuffer serializedTail) {
        this(fileTail, serializedTail, -1L);
    }

    public OrcTail(OrcProto.FileTail fileTail, ByteBuffer serializedTail, long fileModificationTime) {
        this.fileTail = fileTail;
        this.serializedTail = serializedTail;
        this.fileModificationTime = fileModificationTime;
        this.metadata = null;
    }

    public ByteBuffer getSerializedTail() {
        return this.serializedTail;
    }

    public long getFileModificationTime() {
        return this.fileModificationTime;
    }

    public OrcProto.Footer getFooter() {
        return this.fileTail.getFooter();
    }

    public OrcProto.PostScript getPostScript() {
        return this.fileTail.getPostscript();
    }

    public OrcFile.WriterVersion getWriterVersion() {
        OrcProto.PostScript ps = this.fileTail.getPostscript();
        OrcProto.Footer footer = this.fileTail.getFooter();
        OrcFile.WriterImplementation writer = OrcFile.WriterImplementation.from(footer.getWriter());
        return OrcFile.WriterVersion.from(writer, ps.getWriterVersion());
    }

    public List<StripeInformation> getStripes() {
        ArrayList<StripeInformation> result = new ArrayList<StripeInformation>(this.fileTail.getFooter().getStripesCount());
        for (OrcProto.StripeInformation stripeProto : this.fileTail.getFooter().getStripesList()) {
            result.add(new ReaderImpl.StripeInformationImpl(stripeProto));
        }
        return result;
    }

    public CompressionKind getCompressionKind() {
        return CompressionKind.valueOf(this.fileTail.getPostscript().getCompression().name());
    }

    public int getCompressionBufferSize() {
        return (int)this.fileTail.getPostscript().getCompressionBlockSize();
    }

    public List<StripeStatistics> getStripeStatistics() throws IOException {
        ArrayList<StripeStatistics> result = new ArrayList<StripeStatistics>();
        List<OrcProto.StripeStatistics> ssProto = this.getStripeStatisticsProto();
        if (ssProto != null) {
            for (OrcProto.StripeStatistics ss : ssProto) {
                result.add(new StripeStatistics(ss.getColStatsList()));
            }
        }
        return result;
    }

    public List<OrcProto.StripeStatistics> getStripeStatisticsProto() throws IOException {
        if (this.serializedTail == null) {
            return null;
        }
        if (this.metadata == null) {
            CompressionCodec codec = OrcCodecPool.getCodec(this.getCompressionKind());
            try {
                this.metadata = ReaderImpl.extractMetadata(this.serializedTail, 0, (int)this.fileTail.getPostscript().getMetadataLength(), codec, this.getCompressionBufferSize());
            }
            finally {
                OrcCodecPool.returnCodec(this.getCompressionKind(), codec);
            }
            this.serializedTail.clear();
        }
        return this.metadata.getStripeStatsList();
    }

    public int getMetadataSize() {
        return (int)this.getPostScript().getMetadataLength();
    }

    public List<OrcProto.Type> getTypes() {
        return this.getFooter().getTypesList();
    }

    public OrcProto.FileTail getFileTail() {
        return this.fileTail;
    }

    public OrcProto.FileTail getMinimalFileTail() {
        OrcProto.FileTail.Builder fileTailBuilder = OrcProto.FileTail.newBuilder(this.fileTail);
        OrcProto.Footer.Builder footerBuilder = OrcProto.Footer.newBuilder(this.fileTail.getFooter());
        footerBuilder.clearStatistics();
        fileTailBuilder.setFooter(footerBuilder.build());
        OrcProto.FileTail result = fileTailBuilder.build();
        return result;
    }
}

