/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.hive.org.apache.parquet.column.statistics;

import java.util.Arrays;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.column.UnknownColumnTypeException;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.column.statistics.BooleanStatistics;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.column.statistics.DoubleStatistics;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.column.statistics.FloatStatistics;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.column.statistics.IntStatistics;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.column.statistics.LongStatistics;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.column.statistics.StatisticsClassException;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.io.api.Binary;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.schema.PrimitiveComparator;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.schema.PrimitiveStringifier;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.schema.PrimitiveType;
import org.apache.seatunnel.shade.connector.hive.org.apache.parquet.schema.Type;

public abstract class Statistics<T extends Comparable<T>> {
    private final PrimitiveType type;
    private final PrimitiveComparator<T> comparator;
    private boolean hasNonNullValue;
    private long num_nulls;
    final PrimitiveStringifier stringifier;

    Statistics(PrimitiveType type) {
        this.type = type;
        this.comparator = type.comparator();
        this.stringifier = type.stringifier();
        this.hasNonNullValue = false;
        this.num_nulls = 0L;
    }

    @Deprecated
    public static Statistics getStatsBasedOnType(PrimitiveType.PrimitiveTypeName type) {
        switch (type) {
            case INT32: {
                return new IntStatistics();
            }
            case INT64: {
                return new LongStatistics();
            }
            case FLOAT: {
                return new FloatStatistics();
            }
            case DOUBLE: {
                return new DoubleStatistics();
            }
            case BOOLEAN: {
                return new BooleanStatistics();
            }
            case BINARY: {
                return new BinaryStatistics();
            }
            case INT96: {
                return new BinaryStatistics();
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return new BinaryStatistics();
            }
        }
        throw new UnknownColumnTypeException(type);
    }

    public static Statistics<?> createStats(Type type) {
        PrimitiveType primitive = type.asPrimitiveType();
        switch (primitive.getPrimitiveTypeName()) {
            case INT32: {
                return new IntStatistics(primitive);
            }
            case INT64: {
                return new LongStatistics(primitive);
            }
            case FLOAT: {
                return new FloatStatistics(primitive);
            }
            case DOUBLE: {
                return new DoubleStatistics(primitive);
            }
            case BOOLEAN: {
                return new BooleanStatistics(primitive);
            }
            case BINARY: 
            case INT96: 
            case FIXED_LEN_BYTE_ARRAY: {
                return new BinaryStatistics(primitive);
            }
        }
        throw new UnknownColumnTypeException(primitive.getPrimitiveTypeName());
    }

    public static Builder getBuilderForReading(PrimitiveType type) {
        switch (type.getPrimitiveTypeName()) {
            case FLOAT: {
                return new FloatBuilder(type);
            }
            case DOUBLE: {
                return new DoubleBuilder(type);
            }
        }
        return new Builder(type);
    }

    public void updateStats(int value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(long value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(float value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(double value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(boolean value) {
        throw new UnsupportedOperationException();
    }

    public void updateStats(Binary value) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Statistics)) {
            return false;
        }
        Statistics stats = (Statistics)other;
        return this.type.equals((Object)stats.type) && Arrays.equals(stats.getMaxBytes(), this.getMaxBytes()) && Arrays.equals(stats.getMinBytes(), this.getMinBytes()) && stats.getNumNulls() == this.getNumNulls();
    }

    public int hashCode() {
        return 31 * this.type.hashCode() + 31 * Arrays.hashCode(this.getMaxBytes()) + 17 * Arrays.hashCode(this.getMinBytes()) + Long.valueOf(this.getNumNulls()).hashCode();
    }

    public void mergeStatistics(Statistics stats) {
        if (stats.isEmpty()) {
            return;
        }
        if (this.type.equals((Object)stats.type)) {
            this.incrementNumNulls(stats.getNumNulls());
            if (stats.hasNonNullValue()) {
                this.mergeStatisticsMinMax(stats);
                this.markAsNotEmpty();
            }
        } else {
            throw StatisticsClassException.create(this, stats);
        }
    }

    protected abstract void mergeStatisticsMinMax(Statistics var1);

    @Deprecated
    public abstract void setMinMaxFromBytes(byte[] var1, byte[] var2);

    public abstract T genericGetMin();

    public abstract T genericGetMax();

    public final PrimitiveComparator<T> comparator() {
        return this.comparator;
    }

    public final int compareMinToValue(T value) {
        return this.comparator.compare(this.genericGetMin(), value);
    }

    public final int compareMaxToValue(T value) {
        return this.comparator.compare(this.genericGetMax(), value);
    }

    public abstract byte[] getMaxBytes();

    public abstract byte[] getMinBytes();

    public String minAsString() {
        return this.stringify(this.genericGetMin());
    }

    public String maxAsString() {
        return this.stringify(this.genericGetMax());
    }

    abstract String stringify(T var1);

    public abstract boolean isSmallerThan(long var1);

    public String toString() {
        if (this.hasNonNullValue()) {
            if (this.isNumNullsSet()) {
                return String.format("min: %s, max: %s, num_nulls: %d", this.minAsString(), this.maxAsString(), this.getNumNulls());
            }
            return String.format("min: %s, max: %s, num_nulls not defined", this.minAsString(), this.maxAsString());
        }
        if (!this.isEmpty()) {
            return String.format("num_nulls: %d, min/max not defined", this.getNumNulls());
        }
        return "no stats for this column";
    }

    public void incrementNumNulls() {
        ++this.num_nulls;
    }

    public void incrementNumNulls(long increment) {
        this.num_nulls += increment;
    }

    public long getNumNulls() {
        return this.num_nulls;
    }

    @Deprecated
    public void setNumNulls(long nulls) {
        this.num_nulls = nulls;
    }

    public boolean isEmpty() {
        return !this.hasNonNullValue && !this.isNumNullsSet();
    }

    public boolean hasNonNullValue() {
        return this.hasNonNullValue;
    }

    public boolean isNumNullsSet() {
        return this.num_nulls >= 0L;
    }

    protected void markAsNotEmpty() {
        this.hasNonNullValue = true;
    }

    public abstract Statistics<T> copy();

    public PrimitiveType type() {
        return this.type;
    }

    private static class DoubleBuilder
    extends Builder {
        public DoubleBuilder(PrimitiveType type) {
            super(type);
            assert (type.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.DOUBLE);
        }

        @Override
        public Statistics<?> build() {
            DoubleStatistics stats = (DoubleStatistics)super.build();
            if (stats.hasNonNullValue()) {
                Double min2 = stats.genericGetMin();
                Double max = stats.genericGetMax();
                if (min2.isNaN() || max.isNaN()) {
                    stats.setMinMax(0.0, 0.0);
                    ((Statistics)stats).hasNonNullValue = false;
                } else {
                    if (Double.compare(min2, 0.0) == 0) {
                        min2 = -0.0;
                        stats.setMinMax(min2, max);
                    }
                    if (Double.compare(max, -0.0) == 0) {
                        max = 0.0;
                        stats.setMinMax(min2, max);
                    }
                }
            }
            return stats;
        }
    }

    private static class FloatBuilder
    extends Builder {
        public FloatBuilder(PrimitiveType type) {
            super(type);
            assert (type.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.FLOAT);
        }

        @Override
        public Statistics<?> build() {
            FloatStatistics stats = (FloatStatistics)super.build();
            if (stats.hasNonNullValue()) {
                Float min2 = stats.genericGetMin();
                Float max = stats.genericGetMax();
                if (min2.isNaN() || max.isNaN()) {
                    stats.setMinMax(0.0f, 0.0f);
                    ((Statistics)stats).hasNonNullValue = false;
                } else {
                    if (Float.compare(min2.floatValue(), 0.0f) == 0) {
                        min2 = Float.valueOf(-0.0f);
                        stats.setMinMax(min2.floatValue(), max.floatValue());
                    }
                    if (Float.compare(max.floatValue(), -0.0f) == 0) {
                        max = Float.valueOf(0.0f);
                        stats.setMinMax(min2.floatValue(), max.floatValue());
                    }
                }
            }
            return stats;
        }
    }

    public static class Builder {
        private final PrimitiveType type;
        private byte[] min;
        private byte[] max;
        private long numNulls = -1L;

        private Builder(PrimitiveType type) {
            this.type = type;
        }

        public Builder withMin(byte[] min2) {
            this.min = min2;
            return this;
        }

        public Builder withMax(byte[] max) {
            this.max = max;
            return this;
        }

        public Builder withNumNulls(long numNulls) {
            this.numNulls = numNulls;
            return this;
        }

        public Statistics<?> build() {
            Statistics<?> stats = Statistics.createStats(this.type);
            if (this.min != null && this.max != null) {
                stats.setMinMaxFromBytes(this.min, this.max);
            }
            ((Statistics)stats).num_nulls = this.numNulls;
            return stats;
        }
    }
}

