/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.hive.org.apache.parquet.crypto.keytools;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class TwoLevelCacheWithExpiration<V> {
    private final ConcurrentMap<String, ExpiringCacheEntry<ConcurrentMap<String, V>>> cache = new ConcurrentHashMap<String, ExpiringCacheEntry<ConcurrentMap<String, V>>>();
    private volatile long lastCacheCleanupTimestamp = System.currentTimeMillis();

    TwoLevelCacheWithExpiration() {
    }

    ConcurrentMap<String, V> getOrCreateInternalCache(String accessToken, long cacheEntryLifetime) {
        ExpiringCacheEntry externalCacheEntry = this.cache.compute(accessToken, (token, cacheEntry) -> {
            if (null == cacheEntry || ((ExpiringCacheEntry)cacheEntry).isExpired()) {
                return new ExpiringCacheEntry(new ConcurrentHashMap(), cacheEntryLifetime);
            }
            return cacheEntry;
        });
        return (ConcurrentMap)externalCacheEntry.getCachedItem();
    }

    void removeCacheEntriesForToken(String accessToken) {
        this.cache.remove(accessToken);
    }

    void removeCacheEntriesForAllTokens() {
        this.cache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkCacheForExpiredTokens(long cacheCleanupPeriod) {
        long now = System.currentTimeMillis();
        if (now > this.lastCacheCleanupTimestamp + cacheCleanupPeriod) {
            ConcurrentMap<String, ExpiringCacheEntry<ConcurrentMap<String, V>>> concurrentMap = this.cache;
            synchronized (concurrentMap) {
                if (now > this.lastCacheCleanupTimestamp + cacheCleanupPeriod) {
                    this.removeExpiredEntriesFromCache();
                    this.lastCacheCleanupTimestamp = now + cacheCleanupPeriod;
                }
            }
        }
    }

    public void removeExpiredEntriesFromCache() {
        this.cache.values().removeIf(cacheEntry -> ((ExpiringCacheEntry)cacheEntry).isExpired());
    }

    public void remove(String accessToken) {
        this.cache.remove(accessToken);
    }

    public void clear() {
        this.cache.clear();
    }

    static class ExpiringCacheEntry<E> {
        private final long expirationTimestamp;
        private final E cachedItem;

        private ExpiringCacheEntry(E cachedItem, long expirationIntervalMillis) {
            this.expirationTimestamp = System.currentTimeMillis() + expirationIntervalMillis;
            this.cachedItem = cachedItem;
        }

        private boolean isExpired() {
            long now = System.currentTimeMillis();
            return now > this.expirationTimestamp;
        }

        private E getCachedItem() {
            return this.cachedItem;
        }
    }
}

