/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.cos.source;

import com.google.auto.service.AutoService;
import java.io.IOException;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.catalog.schema.TableSchemaOptions;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileSystemType;
import org.apache.seatunnel.connectors.seatunnel.file.cos.config.CosConf;
import org.apache.seatunnel.connectors.seatunnel.file.cos.config.CosConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.source.BaseFileSource;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.ReadStrategyFactory;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={SeaTunnelSource.class})
public class CosFileSource
extends BaseFileSource {
    public String getPluginName() {
        return FileSystemType.COS.getFileSystemPluginName();
    }

    public void prepare(Config pluginConfig) throws PrepareFailException {
        block11: {
            block10: {
                CheckResult result = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{CosConfigOptions.FILE_PATH.key(), CosConfigOptions.FILE_FORMAT_TYPE.key(), CosConfigOptions.SECRET_ID.key(), CosConfigOptions.SECRET_KEY.key(), CosConfigOptions.REGION.key(), CosConfigOptions.BUCKET.key()});
                if (!result.isSuccess()) {
                    throw new FileConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, String.format("PluginName: %s, PluginType: %s, Message: %s", this.getPluginName(), PluginType.SOURCE, result.getMsg()));
                }
                String path = pluginConfig.getString(CosConfigOptions.FILE_PATH.key());
                this.hadoopConf = CosConf.buildWithConfig(pluginConfig);
                this.readStrategy = ReadStrategyFactory.of(pluginConfig.getString(CosConfigOptions.FILE_FORMAT_TYPE.key()));
                this.readStrategy.setPluginConfig(pluginConfig);
                this.readStrategy.init(this.hadoopConf);
                try {
                    this.filePaths = this.readStrategy.getFileNamesByPath(path);
                }
                catch (IOException e) {
                    String errorMsg = String.format("Get file list from this path [%s] failed", path);
                    throw new FileConnectorException(FileConnectorErrorCode.FILE_LIST_GET_FAILED, errorMsg, e);
                }
                FileFormat fileFormat = FileFormat.valueOf(pluginConfig.getString(CosConfigOptions.FILE_FORMAT_TYPE.key()).toUpperCase());
                if (!pluginConfig.hasPath(TableSchemaOptions.SCHEMA.key())) break block10;
                switch (fileFormat) {
                    case CSV: 
                    case TEXT: 
                    case JSON: 
                    case EXCEL: 
                    case XML: {
                        SeaTunnelRowType userDefinedSchema = CatalogTableUtil.buildWithConfig((Config)pluginConfig).getSeaTunnelRowType();
                        this.readStrategy.setSeaTunnelRowTypeInfo(userDefinedSchema);
                        this.rowType = this.readStrategy.getActualSeaTunnelRowTypeInfo();
                        break block11;
                    }
                    case ORC: 
                    case PARQUET: 
                    case BINARY: {
                        throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, "SeaTunnel does not support user-defined schema for [parquet, orc, binary] files");
                    }
                    default: {
                        throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "SeaTunnel does not supported this file format");
                    }
                }
            }
            if (this.filePaths.isEmpty()) {
                this.rowType = CatalogTableUtil.buildSimpleTextSchema();
                return;
            }
            try {
                this.rowType = this.readStrategy.getSeaTunnelRowTypeInfo((String)this.filePaths.get(0));
            }
            catch (FileConnectorException e) {
                String errorMsg = String.format("Get table schema from file [%s] failed", this.filePaths.get(0));
                throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.TABLE_SCHEMA_GET_FAILED, errorMsg, (Throwable)((Object)e));
            }
        }
    }
}

