/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.source;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.source.SupportColumnProjection;
import org.apache.seatunnel.api.source.SupportParallelism;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseFileSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseMultipleTableFileSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.MultipleTableFileSourceReader;
import org.apache.seatunnel.connectors.seatunnel.file.source.split.FileSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.file.source.split.MultipleTableFileSourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.file.source.state.FileSourceState;

public abstract class BaseMultipleTableFileSource
implements SeaTunnelSource<SeaTunnelRow, FileSourceSplit, FileSourceState>,
SupportParallelism,
SupportColumnProjection {
    private final BaseMultipleTableFileSourceConfig baseMultipleTableFileSourceConfig;

    public BaseMultipleTableFileSource(BaseMultipleTableFileSourceConfig baseMultipleTableFileSourceConfig) {
        this.baseMultipleTableFileSourceConfig = baseMultipleTableFileSourceConfig;
    }

    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public abstract String getPluginName();

    public List<CatalogTable> getProducedCatalogTables() {
        return this.baseMultipleTableFileSourceConfig.getFileSourceConfigs().stream().map(BaseFileSourceConfig::getCatalogTable).collect(Collectors.toList());
    }

    public SourceReader<SeaTunnelRow, FileSourceSplit> createReader(SourceReader.Context readerContext) {
        return new MultipleTableFileSourceReader(readerContext, this.baseMultipleTableFileSourceConfig);
    }

    public SourceSplitEnumerator<FileSourceSplit, FileSourceState> createEnumerator(SourceSplitEnumerator.Context<FileSourceSplit> enumeratorContext) {
        return new MultipleTableFileSourceSplitEnumerator(enumeratorContext, this.baseMultipleTableFileSourceConfig);
    }

    public SourceSplitEnumerator<FileSourceSplit, FileSourceState> restoreEnumerator(SourceSplitEnumerator.Context<FileSourceSplit> enumeratorContext, FileSourceState checkpointState) {
        return new MultipleTableFileSourceSplitEnumerator(enumeratorContext, this.baseMultipleTableFileSourceConfig, checkpointState);
    }
}

