/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.file.source.reader;

import io.airlift.compress.lzo.LzopCodec;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.DateTimeUtils;
import org.apache.seatunnel.common.utils.DateUtils;
import org.apache.seatunnel.common.utils.TimeUtils;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseSourceConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.file.config.CompressFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.AbstractReadStrategy;
import org.apache.seatunnel.format.text.TextDeserializationSchema;
import org.apache.seatunnel.format.text.splitor.CsvLineSplitor;
import org.apache.seatunnel.format.text.splitor.DefaultTextLineSplitor;
import org.apache.seatunnel.format.text.splitor.TextLineSplitor;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextReadStrategy
extends AbstractReadStrategy {
    private static final Logger log = LoggerFactory.getLogger(TextReadStrategy.class);
    private DeserializationSchema<SeaTunnelRow> deserializationSchema;
    private String fieldDelimiter = (String)BaseSourceConfigOptions.FIELD_DELIMITER.defaultValue();
    private DateUtils.Formatter dateFormat = (DateUtils.Formatter)BaseSourceConfigOptions.DATE_FORMAT.defaultValue();
    private DateTimeUtils.Formatter datetimeFormat = (DateTimeUtils.Formatter)BaseSourceConfigOptions.DATETIME_FORMAT.defaultValue();
    private TimeUtils.Formatter timeFormat = (TimeUtils.Formatter)BaseSourceConfigOptions.TIME_FORMAT.defaultValue();
    private CompressFormat compressFormat = (CompressFormat)BaseSourceConfigOptions.COMPRESS_CODEC.defaultValue();
    private TextLineSplitor textLineSplitor;
    private int[] indexes;
    private String encoding = (String)BaseSourceConfigOptions.ENCODING.defaultValue();

    @Override
    public void read(String path, String tableId, Collector<SeaTunnelRow> output) throws FileConnectorException, IOException {
        Map<String, String> partitionsMap = this.parsePartitionsByPath(path);
        this.resolveArchiveCompressedInputStream(path, tableId, output, partitionsMap, FileFormat.TEXT);
    }

    @Override
    public void readProcess(String path, String tableId, Collector<SeaTunnelRow> output, InputStream inputStream, Map<String, String> partitionsMap, String currentFileName) throws IOException {
        InputStream actualInputStream;
        switch (this.compressFormat) {
            case LZO: {
                LzopCodec lzo = new LzopCodec();
                actualInputStream = lzo.createInputStream(inputStream);
                break;
            }
            case NONE: {
                actualInputStream = inputStream;
                break;
            }
            default: {
                log.warn("Text file does not support this compress type: {}", (Object)this.compressFormat.getCompressCodec());
                actualInputStream = inputStream;
            }
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(actualInputStream, this.encoding));){
            reader.lines().skip(this.skipHeaderNumber).forEach(line -> {
                try {
                    SeaTunnelRow seaTunnelRow = (SeaTunnelRow)this.deserializationSchema.deserialize(line.getBytes(StandardCharsets.UTF_8));
                    if (!this.readColumns.isEmpty()) {
                        Object[] fields = this.isMergePartition ? new Object[this.readColumns.size() + partitionsMap.size()] : new Object[this.readColumns.size()];
                        for (int i = 0; i < this.indexes.length; ++i) {
                            fields[i] = seaTunnelRow.getField(this.indexes[i]);
                        }
                        seaTunnelRow = new SeaTunnelRow(fields);
                    }
                    if (this.isMergePartition) {
                        int index = this.seaTunnelRowType.getTotalFields();
                        for (String value : partitionsMap.values()) {
                            seaTunnelRow.setField(index++, (Object)value);
                        }
                    }
                    seaTunnelRow.setTableId(tableId);
                    output.collect((Object)seaTunnelRow);
                }
                catch (IOException e) {
                    String errorMsg = String.format("Deserialize this data [%s] failed, please check the origin data", line);
                    throw new FileConnectorException(FileConnectorErrorCode.DATA_DESERIALIZE_FAILED, errorMsg, e);
                }
            });
        }
    }

    @Override
    public SeaTunnelRowType getSeaTunnelRowTypeInfo(String path) {
        this.seaTunnelRowType = CatalogTableUtil.buildSimpleTextSchema();
        this.seaTunnelRowTypeWithPartition = this.mergePartitionTypes((String)this.fileNames.get(0), this.seaTunnelRowType);
        this.initFormatter();
        if (this.pluginConfig.hasPath(BaseSourceConfigOptions.READ_COLUMNS.key())) {
            throw new FileConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, "When reading json/text/csv files, if user has not specified schema information, SeaTunnel will not support column projection");
        }
        TextDeserializationSchema.Builder builder = TextDeserializationSchema.builder().delimiter("\b").textLineSplitor(this.textLineSplitor);
        this.deserializationSchema = this.isMergePartition ? builder.seaTunnelRowType(this.seaTunnelRowTypeWithPartition).build() : builder.seaTunnelRowType(this.seaTunnelRowType).build();
        return this.getActualSeaTunnelRowTypeInfo();
    }

    @Override
    public void setSeaTunnelRowTypeInfo(SeaTunnelRowType seaTunnelRowType) {
        SeaTunnelRowType userDefinedRowTypeWithPartition = this.mergePartitionTypes((String)this.fileNames.get(0), seaTunnelRowType);
        Optional fieldDelimiterOptional = ReadonlyConfig.fromConfig((Config)this.pluginConfig).getOptional(BaseSourceConfigOptions.FIELD_DELIMITER);
        this.encoding = ReadonlyConfig.fromConfig((Config)this.pluginConfig).getOptional(BaseSourceConfigOptions.ENCODING).orElse(StandardCharsets.UTF_8.name());
        if (fieldDelimiterOptional.isPresent()) {
            this.fieldDelimiter = (String)fieldDelimiterOptional.get();
        } else {
            FileFormat fileFormat = FileFormat.valueOf(this.pluginConfig.getString(BaseSourceConfigOptions.FILE_FORMAT_TYPE.key()).toUpperCase());
            if (fileFormat == FileFormat.CSV) {
                this.fieldDelimiter = ",";
            }
        }
        this.initFormatter();
        TextDeserializationSchema.Builder builder = TextDeserializationSchema.builder().delimiter(this.fieldDelimiter).textLineSplitor(this.textLineSplitor);
        this.deserializationSchema = this.isMergePartition ? builder.seaTunnelRowType(userDefinedRowTypeWithPartition).build() : builder.seaTunnelRowType(seaTunnelRowType).build();
        if (this.pluginConfig.hasPath(BaseSourceConfigOptions.READ_COLUMNS.key())) {
            this.indexes = new int[this.readColumns.size()];
            String[] fields = new String[this.readColumns.size()];
            SeaTunnelDataType[] types = new SeaTunnelDataType[this.readColumns.size()];
            for (int i = 0; i < this.indexes.length; ++i) {
                this.indexes[i] = seaTunnelRowType.indexOf((String)this.readColumns.get(i));
                fields[i] = seaTunnelRowType.getFieldName(this.indexes[i]);
                types[i] = seaTunnelRowType.getFieldType(this.indexes[i]);
            }
            this.seaTunnelRowType = new SeaTunnelRowType(fields, types);
            this.seaTunnelRowTypeWithPartition = this.mergePartitionTypes((String)this.fileNames.get(0), this.seaTunnelRowType);
        } else {
            this.seaTunnelRowType = seaTunnelRowType;
            this.seaTunnelRowTypeWithPartition = userDefinedRowTypeWithPartition;
        }
    }

    private void initFormatter() {
        if (this.pluginConfig.hasPath(BaseSourceConfigOptions.DATE_FORMAT.key())) {
            this.dateFormat = DateUtils.Formatter.parse((String)this.pluginConfig.getString(BaseSourceConfigOptions.DATE_FORMAT.key()));
        }
        if (this.pluginConfig.hasPath(BaseSourceConfigOptions.DATETIME_FORMAT.key())) {
            this.datetimeFormat = DateTimeUtils.Formatter.parse((String)this.pluginConfig.getString(BaseSourceConfigOptions.DATETIME_FORMAT.key()));
        }
        if (this.pluginConfig.hasPath(BaseSourceConfigOptions.TIME_FORMAT.key())) {
            this.timeFormat = TimeUtils.Formatter.parse((String)this.pluginConfig.getString(BaseSourceConfigOptions.TIME_FORMAT.key()));
        }
        if (this.pluginConfig.hasPath(BaseSourceConfigOptions.COMPRESS_CODEC.key())) {
            String compressCodec = this.pluginConfig.getString(BaseSourceConfigOptions.COMPRESS_CODEC.key());
            this.compressFormat = CompressFormat.valueOf(compressCodec.toUpperCase());
        }
        this.textLineSplitor = FileFormat.CSV.equals(FileFormat.valueOf(this.pluginConfig.getString(BaseSourceConfigOptions.FILE_FORMAT_TYPE.key()).toUpperCase())) ? new CsvLineSplitor() : new DefaultTextLineSplitor();
    }
}

