/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.hive.config;

import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.s3.config.S3ConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.file.s3.config.S3HadoopConf;

public class HiveOnS3Conf
extends S3HadoopConf {
    protected static final String S3_SCHEMA = "s3";
    protected static final String HDFS_S3_IMPL = "com.amazon.ws.emr.hadoop.fs.EmrFileSystem";

    protected HiveOnS3Conf(String hdfsNameKey, String schema) {
        super(hdfsNameKey);
        this.setSchema(schema);
    }

    @Override
    public String getFsHdfsImpl() {
        return this.switchHdfsImpl();
    }

    @Override
    protected String switchHdfsImpl() {
        return this.getSchema().equals(S3_SCHEMA) ? HDFS_S3_IMPL : super.switchHdfsImpl();
    }

    public static HadoopConf buildWithReadOnlyConfig(ReadonlyConfig readonlyConfig) {
        S3HadoopConf s3Conf = (S3HadoopConf)S3HadoopConf.buildWithReadOnlyConfig(readonlyConfig);
        String bucketName = (String)readonlyConfig.get(S3ConfigOptions.S3_BUCKET);
        if (bucketName.startsWith("s3n")) {
            s3Conf.setSchema("s3n");
        } else if (bucketName.startsWith("s3a")) {
            s3Conf.setSchema("s3a");
        } else {
            s3Conf.setSchema(S3_SCHEMA);
        }
        return new HiveOnS3Conf(s3Conf.getHdfsNameKey(), s3Conf.getSchema());
    }
}

