/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.hive.sink;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.serialization.DefaultSerializer;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.api.sink.SeaTunnelSink;
import org.apache.seatunnel.api.sink.SinkAggregatedCommitter;
import org.apache.seatunnel.api.sink.SinkWriter;
import org.apache.seatunnel.api.sink.SupportMultiTableSink;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.sink.commit.FileAggregatedCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.file.sink.commit.FileCommitInfo;
import org.apache.seatunnel.connectors.seatunnel.file.sink.config.FileSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.file.sink.state.FileSinkState;
import org.apache.seatunnel.connectors.seatunnel.file.sink.writer.WriteStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.sink.writer.WriteStrategyFactory;
import org.apache.seatunnel.connectors.seatunnel.hive.commit.HiveSinkAggregatedCommitter;
import org.apache.seatunnel.connectors.seatunnel.hive.exception.HiveConnectorException;
import org.apache.seatunnel.connectors.seatunnel.hive.sink.writter.HiveSinkWriter;
import org.apache.seatunnel.connectors.seatunnel.hive.source.config.HiveSourceOptions;
import org.apache.seatunnel.connectors.seatunnel.hive.storage.StorageFactory;
import org.apache.seatunnel.connectors.seatunnel.hive.utils.HiveTableUtils;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValueFactory;

public class HiveSink
implements SeaTunnelSink<SeaTunnelRow, FileSinkState, FileCommitInfo, FileAggregatedCommitInfo>,
SupportMultiTableSink {
    private transient Table tableInformation;
    private final CatalogTable catalogTable;
    private final ReadonlyConfig readonlyConfig;
    private final HadoopConf hadoopConf;
    private final FileSinkConfig fileSinkConfig;
    private transient WriteStrategy writeStrategy;
    private String jobId;

    public HiveSink(ReadonlyConfig readonlyConfig, CatalogTable catalogTable) {
        this.readonlyConfig = readonlyConfig;
        this.catalogTable = catalogTable;
        this.tableInformation = this.getTableInformation();
        this.hadoopConf = this.createHadoopConf(readonlyConfig);
        this.fileSinkConfig = this.generateFileSinkConfig(readonlyConfig, catalogTable);
        this.writeStrategy = this.getWriteStrategy();
    }

    private FileSinkConfig generateFileSinkConfig(ReadonlyConfig readonlyConfig, CatalogTable catalogTable) {
        Table tableInformation = this.getTableInformation();
        Config pluginConfig = readonlyConfig.toConfig();
        List sinkFields = tableInformation.getSd().getCols().stream().map(FieldSchema::getName).collect(Collectors.toList());
        List partitionKeys = tableInformation.getPartitionKeys().stream().map(FieldSchema::getName).collect(Collectors.toList());
        sinkFields.addAll(partitionKeys);
        FileFormat fileFormat = HiveTableUtils.parseFileFormat(tableInformation);
        switch (fileFormat) {
            case TEXT: {
                Map parameters = tableInformation.getSd().getSerdeInfo().getParameters();
                pluginConfig = pluginConfig.withValue(BaseSinkConfig.FILE_FORMAT_TYPE.key(), ConfigValueFactory.fromAnyRef((Object)FileFormat.TEXT.toString())).withValue(BaseSinkConfig.FIELD_DELIMITER.key(), ConfigValueFactory.fromAnyRef(parameters.get("field.delim"))).withValue(BaseSinkConfig.ROW_DELIMITER.key(), ConfigValueFactory.fromAnyRef(parameters.get("line.delim")));
                break;
            }
            case PARQUET: {
                pluginConfig = pluginConfig.withValue(BaseSinkConfig.FILE_FORMAT_TYPE.key(), ConfigValueFactory.fromAnyRef((Object)FileFormat.PARQUET.toString()));
                break;
            }
            case ORC: {
                pluginConfig = pluginConfig.withValue(BaseSinkConfig.FILE_FORMAT_TYPE.key(), ConfigValueFactory.fromAnyRef((Object)FileFormat.ORC.toString()));
                break;
            }
            default: {
                throw new HiveConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "Hive connector only support [text parquet orc] table now");
            }
        }
        pluginConfig = pluginConfig.withValue(BaseSinkConfig.IS_PARTITION_FIELD_WRITE_IN_FILE.key(), ConfigValueFactory.fromAnyRef((Object)false)).withValue(BaseSinkConfig.FILE_NAME_EXPRESSION.key(), ConfigValueFactory.fromAnyRef((Object)"${transactionId}")).withValue(BaseSinkConfig.FILE_PATH.key(), ConfigValueFactory.fromAnyRef((Object)tableInformation.getSd().getLocation())).withValue(BaseSinkConfig.SINK_COLUMNS.key(), ConfigValueFactory.fromAnyRef(sinkFields)).withValue(BaseSinkConfig.PARTITION_BY.key(), ConfigValueFactory.fromAnyRef(partitionKeys));
        return new FileSinkConfig(pluginConfig, catalogTable.getSeaTunnelRowType());
    }

    public String getPluginName() {
        return "Hive";
    }

    public Optional<SinkAggregatedCommitter<FileCommitInfo, FileAggregatedCommitInfo>> createAggregatedCommitter() {
        return Optional.of(new HiveSinkAggregatedCommitter(this.readonlyConfig, this.getTableInformation().getDbName(), this.getTableInformation().getTableName(), this.hadoopConf));
    }

    public void setJobContext(JobContext jobContext) {
        this.jobId = jobContext.getJobId();
    }

    public HiveSinkWriter restoreWriter(SinkWriter.Context context, List<FileSinkState> states) {
        return new HiveSinkWriter(this.getWriteStrategy(), this.hadoopConf, context, this.jobId, states);
    }

    public HiveSinkWriter createWriter(SinkWriter.Context context) {
        return new HiveSinkWriter(this.getWriteStrategy(), this.hadoopConf, context, this.jobId);
    }

    public Optional<Serializer<FileCommitInfo>> getCommitInfoSerializer() {
        return Optional.of(new DefaultSerializer());
    }

    public Optional<Serializer<FileAggregatedCommitInfo>> getAggregatedCommitInfoSerializer() {
        return Optional.of(new DefaultSerializer());
    }

    public Optional<Serializer<FileSinkState>> getWriterStateSerializer() {
        return Optional.of(new DefaultSerializer());
    }

    private HadoopConf createHadoopConf(ReadonlyConfig readonlyConfig) {
        String hdfsLocation = this.getTableInformation().getSd().getLocation();
        HadoopConf hadoopConf = StorageFactory.getStorageType(hdfsLocation).buildHadoopConfWithReadOnlyConfig(readonlyConfig);
        readonlyConfig.getOptional(HiveSourceOptions.HDFS_SITE_PATH).ifPresent(hadoopConf::setHdfsSitePath);
        readonlyConfig.getOptional(HiveSourceOptions.REMOTE_USER).ifPresent(hadoopConf::setRemoteUser);
        readonlyConfig.getOptional(HiveSourceOptions.KERBEROS_PRINCIPAL).ifPresent(hadoopConf::setKerberosPrincipal);
        readonlyConfig.getOptional(HiveSourceOptions.KERBEROS_KEYTAB_PATH).ifPresent(hadoopConf::setKerberosKeytabPath);
        return hadoopConf;
    }

    private Table getTableInformation() {
        if (this.tableInformation == null) {
            this.tableInformation = HiveTableUtils.getTableInfo(this.readonlyConfig);
        }
        return this.tableInformation;
    }

    private WriteStrategy getWriteStrategy() {
        if (this.writeStrategy == null) {
            this.writeStrategy = WriteStrategyFactory.of(this.fileSinkConfig.getFileFormat(), this.fileSinkConfig);
            this.writeStrategy.setSeaTunnelRowTypeInfo(this.catalogTable.getSeaTunnelRowType());
        }
        return this.writeStrategy;
    }
}

