/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.hive.source;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.file.hdfs.source.BaseHdfsFileSource;
import org.apache.seatunnel.connectors.seatunnel.file.source.split.FileSourceSplit;
import org.apache.seatunnel.connectors.seatunnel.file.source.state.FileSourceState;
import org.apache.seatunnel.connectors.seatunnel.hive.source.config.HiveSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.hive.source.config.MultipleTableHiveSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.hive.source.reader.MultipleTableHiveSourceReader;
import org.apache.seatunnel.connectors.seatunnel.hive.source.split.MultipleTableHiveSourceSplitEnumerator;

public class HiveSource
extends BaseHdfsFileSource {
    private final MultipleTableHiveSourceConfig multipleTableHiveSourceConfig;

    public HiveSource(ReadonlyConfig readonlyConfig) {
        this.multipleTableHiveSourceConfig = new MultipleTableHiveSourceConfig(readonlyConfig);
    }

    public String getPluginName() {
        return "Hive";
    }

    @Override
    public Boundedness getBoundedness() {
        return Boundedness.BOUNDED;
    }

    public List<CatalogTable> getProducedCatalogTables() {
        return this.multipleTableHiveSourceConfig.getHiveSourceConfigs().stream().map(HiveSourceConfig::getCatalogTable).collect(Collectors.toList());
    }

    @Override
    public SourceReader<SeaTunnelRow, FileSourceSplit> createReader(SourceReader.Context readerContext) {
        return new MultipleTableHiveSourceReader(readerContext, this.multipleTableHiveSourceConfig);
    }

    @Override
    public SourceSplitEnumerator<FileSourceSplit, FileSourceState> createEnumerator(SourceSplitEnumerator.Context<FileSourceSplit> enumeratorContext) {
        return new MultipleTableHiveSourceSplitEnumerator(enumeratorContext, this.multipleTableHiveSourceConfig);
    }

    @Override
    public SourceSplitEnumerator<FileSourceSplit, FileSourceState> restoreEnumerator(SourceSplitEnumerator.Context<FileSourceSplit> enumeratorContext, FileSourceState checkpointState) {
        return new MultipleTableHiveSourceSplitEnumerator(enumeratorContext, this.multipleTableHiveSourceConfig, checkpointState);
    }
}

