/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.hive.source.config;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.seatunnel.api.common.SeaTunnelAPIErrorCode;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.CatalogTableUtil;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TablePath;
import org.apache.seatunnel.api.table.catalog.TableSchema;
import org.apache.seatunnel.api.table.catalog.schema.TableSchemaOptions;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.config.BaseSinkConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.FileFormat;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.file.exception.FileConnectorException;
import org.apache.seatunnel.connectors.seatunnel.file.hdfs.source.config.HdfsSourceConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.ReadStrategy;
import org.apache.seatunnel.connectors.seatunnel.file.source.reader.ReadStrategyFactory;
import org.apache.seatunnel.connectors.seatunnel.hive.exception.HiveConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.hive.exception.HiveConnectorException;
import org.apache.seatunnel.connectors.seatunnel.hive.storage.StorageFactory;
import org.apache.seatunnel.connectors.seatunnel.hive.utils.HiveTableUtils;
import org.apache.seatunnel.connectors.seatunnel.hive.utils.HiveTypeConvertor;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValueFactory;

public class HiveSourceConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final CatalogTable catalogTable;
    private final FileFormat fileFormat;
    private final ReadStrategy readStrategy;
    private final List<String> filePaths;
    private final HadoopConf hadoopConf;

    public HiveSourceConfig(ReadonlyConfig readonlyConfig) {
        readonlyConfig.getOptional(HdfsSourceConfigOptions.READ_PARTITIONS).ifPresent(this::validatePartitions);
        Table table = HiveTableUtils.getTableInfo(readonlyConfig);
        this.hadoopConf = this.parseHiveHadoopConfig(readonlyConfig, table);
        this.fileFormat = HiveTableUtils.parseFileFormat(table);
        this.readStrategy = this.parseReadStrategy(table, readonlyConfig, this.fileFormat, this.hadoopConf);
        this.filePaths = this.parseFilePaths(table, this.readStrategy);
        this.catalogTable = this.parseCatalogTable(readonlyConfig, this.readStrategy, this.fileFormat, this.hadoopConf, this.filePaths, table);
    }

    private void validatePartitions(List<String> partitionsList) {
        if (CollectionUtils.isEmpty(partitionsList)) {
            throw new HiveConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, "Partitions list is empty, please check");
        }
        int depth = partitionsList.get(0).replaceAll("\\\\", "/").split("/").length;
        long count = partitionsList.stream().map(partition -> partition.replaceAll("\\\\", "/").split("/").length).filter(length -> length != depth).count();
        if (count > 0L) {
            throw new HiveConnectorException((SeaTunnelErrorCode)SeaTunnelAPIErrorCode.CONFIG_VALIDATION_FAILED, "Every partition that in partition list should has the same directory depth");
        }
    }

    private ReadStrategy parseReadStrategy(Table table, ReadonlyConfig readonlyConfig, FileFormat fileFormat, HadoopConf hadoopConf) {
        ReadStrategy readStrategy = ReadStrategyFactory.of(fileFormat.name());
        Config config = readonlyConfig.toConfig();
        switch (fileFormat) {
            case TEXT: {
                Map parameters = table.getSd().getSerdeInfo().getParameters();
                config = config.withValue(BaseSinkConfig.FIELD_DELIMITER.key(), ConfigValueFactory.fromAnyRef(parameters.get("field.delim"))).withValue(BaseSinkConfig.ROW_DELIMITER.key(), ConfigValueFactory.fromAnyRef(parameters.get("line.delim"))).withValue(BaseSinkConfig.FILE_FORMAT_TYPE.key(), ConfigValueFactory.fromAnyRef((Object)FileFormat.TEXT.name()));
                break;
            }
            case ORC: {
                config = config.withValue(BaseSinkConfig.FILE_FORMAT_TYPE.key(), ConfigValueFactory.fromAnyRef((Object)FileFormat.ORC.name()));
                break;
            }
            case PARQUET: {
                config = config.withValue(BaseSinkConfig.FILE_FORMAT_TYPE.key(), ConfigValueFactory.fromAnyRef((Object)FileFormat.PARQUET.name()));
                break;
            }
        }
        readStrategy.setPluginConfig(config);
        readStrategy.init(hadoopConf);
        return readStrategy;
    }

    private HadoopConf parseHiveHadoopConfig(ReadonlyConfig readonlyConfig, Table table) {
        String hiveSdLocation = table.getSd().getLocation();
        HadoopConf hadoopConf = StorageFactory.getStorageType(hiveSdLocation).buildHadoopConfWithReadOnlyConfig(readonlyConfig);
        readonlyConfig.getOptional(HdfsSourceConfigOptions.HDFS_SITE_PATH).ifPresent(hadoopConf::setHdfsSitePath);
        readonlyConfig.getOptional(HdfsSourceConfigOptions.KERBEROS_PRINCIPAL).ifPresent(hadoopConf::setKerberosPrincipal);
        readonlyConfig.getOptional(HdfsSourceConfigOptions.KERBEROS_KEYTAB_PATH).ifPresent(hadoopConf::setKerberosKeytabPath);
        readonlyConfig.getOptional(HdfsSourceConfigOptions.REMOTE_USER).ifPresent(hadoopConf::setRemoteUser);
        return hadoopConf;
    }

    private List<String> parseFilePaths(Table table, ReadStrategy readStrategy) {
        String hdfsPath = this.parseHdfsPath(table);
        try {
            return readStrategy.getFileNamesByPath(hdfsPath);
        }
        catch (Exception e) {
            String errorMsg = String.format("Get file list from this path [%s] failed", hdfsPath);
            throw new FileConnectorException(FileConnectorErrorCode.FILE_LIST_GET_FAILED, errorMsg, e);
        }
    }

    private String parseFsDefaultName(Table table) {
        String hdfsLocation = table.getSd().getLocation();
        try {
            URI uri = new URI(hdfsLocation);
            String path = uri.getPath();
            return hdfsLocation.replace(path, "");
        }
        catch (URISyntaxException e) {
            String errorMsg = String.format("Get hdfs namenode host from table location [%s] failed,please check it", hdfsLocation);
            throw new HiveConnectorException(HiveConnectorErrorCode.GET_HDFS_NAMENODE_HOST_FAILED, errorMsg, e);
        }
    }

    private String parseHdfsPath(Table table) {
        String hdfsLocation = table.getSd().getLocation();
        try {
            URI uri = new URI(hdfsLocation);
            return uri.getPath();
        }
        catch (URISyntaxException e) {
            String errorMsg = String.format("Get hdfs namenode host from table location [%s] failed,please check it", hdfsLocation);
            throw new HiveConnectorException(HiveConnectorErrorCode.GET_HDFS_NAMENODE_HOST_FAILED, errorMsg, e);
        }
    }

    private CatalogTable parseCatalogTable(ReadonlyConfig readonlyConfig, ReadStrategy readStrategy, FileFormat fileFormat, HadoopConf hadoopConf, List<String> filePaths, Table table) {
        switch (fileFormat) {
            case ORC: 
            case PARQUET: {
                return this.parseCatalogTableFromRemotePath(readonlyConfig, hadoopConf, filePaths, table);
            }
            case TEXT: {
                return this.parseCatalogTableFromTable(readonlyConfig, readStrategy, table);
            }
        }
        throw new HiveConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.ILLEGAL_ARGUMENT, "Hive connector only support [text parquet orc] table now");
    }

    private CatalogTable parseCatalogTableFromRemotePath(ReadonlyConfig readonlyConfig, HadoopConf hadoopConf, List<String> filePaths, Table table) {
        if (CollectionUtils.isEmpty(filePaths)) {
            return this.buildEmptyCatalogTable(readonlyConfig, table);
        }
        CatalogTable catalogTable = this.buildEmptyCatalogTable(readonlyConfig, table);
        try {
            SeaTunnelRowType seaTunnelRowTypeInfo = this.readStrategy.getSeaTunnelRowTypeInfo(filePaths.get(0));
            return CatalogTableUtil.newCatalogTable((CatalogTable)catalogTable, (SeaTunnelRowType)seaTunnelRowTypeInfo);
        }
        catch (FileConnectorException e) {
            String errorMsg = String.format("Get table schema from file [%s] failed", filePaths.get(0));
            throw new FileConnectorException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.TABLE_SCHEMA_GET_FAILED, errorMsg, (Throwable)((Object)e));
        }
    }

    private CatalogTable parseCatalogTableFromTable(ReadonlyConfig readonlyConfig, ReadStrategy readStrategy, Table table) {
        List cols = table.getSd().getCols();
        String[] fieldNames = new String[cols.size()];
        SeaTunnelDataType[] fieldTypes = new SeaTunnelDataType[cols.size()];
        for (int i = 0; i < cols.size(); ++i) {
            FieldSchema col = (FieldSchema)cols.get(i);
            fieldNames[i] = col.getName();
            fieldTypes[i] = HiveTypeConvertor.covertHiveTypeToSeaTunnelType(col.getName(), col.getType());
        }
        SeaTunnelRowType seaTunnelRowType = new SeaTunnelRowType(fieldNames, fieldTypes);
        readStrategy.setSeaTunnelRowTypeInfo(seaTunnelRowType);
        SeaTunnelRowType finalSeatunnelRowType = readStrategy.getActualSeaTunnelRowTypeInfo();
        CatalogTable catalogTable = this.buildEmptyCatalogTable(readonlyConfig, table);
        return CatalogTableUtil.newCatalogTable((CatalogTable)catalogTable, (SeaTunnelRowType)finalSeatunnelRowType);
    }

    private CatalogTable buildEmptyCatalogTable(ReadonlyConfig readonlyConfig, Table table) {
        TablePath tablePath = TablePath.of((String)table.getDbName(), (String)table.getTableName());
        return CatalogTable.of((TableIdentifier)TableIdentifier.of((String)"Hive", (TablePath)tablePath), (TableSchema)TableSchema.builder().build(), new HashMap(), new ArrayList(), (String)((String)readonlyConfig.get(TableSchemaOptions.TableIdentifierOptions.COMMENT)));
    }

    public CatalogTable getCatalogTable() {
        return this.catalogTable;
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public ReadStrategy getReadStrategy() {
        return this.readStrategy;
    }

    public List<String> getFilePaths() {
        return this.filePaths;
    }

    public HadoopConf getHadoopConf() {
        return this.hadoopConf;
    }
}

