/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.hive.source.config;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.hive.source.config.HiveSourceConfig;
import org.apache.seatunnel.connectors.seatunnel.hive.source.config.HiveSourceOptions;

public class MultipleTableHiveSourceConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<HiveSourceConfig> hiveSourceConfigs;

    public MultipleTableHiveSourceConfig(ReadonlyConfig readonlyConfig) {
        if (readonlyConfig.getOptional(HiveSourceOptions.TABLE_CONFIGS).isPresent()) {
            this.parseFromLocalFileSourceConfigs(readonlyConfig);
        } else {
            this.parseFromLocalFileSourceConfig(readonlyConfig);
        }
    }

    private void parseFromLocalFileSourceConfigs(ReadonlyConfig readonlyConfig) {
        this.hiveSourceConfigs = ((List)readonlyConfig.get(HiveSourceOptions.TABLE_CONFIGS)).stream().map(ReadonlyConfig::fromMap).map(HiveSourceConfig::new).collect(Collectors.toList());
    }

    private void parseFromLocalFileSourceConfig(ReadonlyConfig localFileSourceRootConfig) {
        HiveSourceConfig hiveSourceConfig = new HiveSourceConfig(localFileSourceRootConfig);
        this.hiveSourceConfigs = Lists.newArrayList(hiveSourceConfig);
    }

    public List<HiveSourceConfig> getHiveSourceConfigs() {
        return this.hiveSourceConfigs;
    }
}

