/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.hive.storage;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.connectors.seatunnel.file.hdfs.source.config.HdfsSourceConfigOptions;
import org.apache.seatunnel.connectors.seatunnel.hive.config.HiveConfig;
import org.apache.seatunnel.connectors.seatunnel.hive.exception.HiveConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.hive.exception.HiveConnectorException;
import org.apache.seatunnel.connectors.seatunnel.hive.storage.Storage;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStorage
implements Storage {
    private static final Logger log = LoggerFactory.getLogger(AbstractStorage.class);
    private static final Option BUCKET_OPTION = Options.key((String)"bucket").stringType().noDefaultValue();
    private static final List<String> HADOOP_CONF_FILES = ImmutableList.of("core-site.xml", "hdfs-site.xml", "hive-site.xml");

    protected Config fillBucket(ReadonlyConfig readonlyConfig, Configuration configuration) {
        Config config = readonlyConfig.toConfig();
        String bucketValue = configuration.get(BUCKET_OPTION.key());
        if (StringUtils.isBlank(bucketValue)) {
            throw new RuntimeException("There is no bucket property in conf which load from [hadoop_conf_path,hadoop_conf].");
        }
        config = config.withValue(BUCKET_OPTION.key(), ConfigValueFactory.fromAnyRef((Object)bucketValue));
        return config;
    }

    protected Configuration loadHiveBaseHadoopConfig(ReadonlyConfig readonlyConfig) {
        try {
            Optional hadoopConf;
            Configuration configuration = new Configuration();
            Optional hadoopConfPath = readonlyConfig.getOptional(HiveConfig.HADOOP_CONF_PATH);
            if (hadoopConfPath.isPresent()) {
                HADOOP_CONF_FILES.forEach(confFile -> {
                    Path path = Paths.get((String)hadoopConfPath.get(), confFile);
                    if (Files.exists(path, new LinkOption[0])) {
                        try {
                            configuration.addResource(path.toUri().toURL());
                        }
                        catch (IOException e) {
                            log.warn("Error adding Hadoop resource {}, resource was not added", (Object)path, (Object)e);
                        }
                    }
                });
            }
            String hiveSitePath = (String)readonlyConfig.get(HiveConfig.HIVE_SITE_PATH);
            String hdfsSitePath = (String)readonlyConfig.get(HdfsSourceConfigOptions.HDFS_SITE_PATH);
            if (StringUtils.isNotBlank(hdfsSitePath)) {
                configuration.addResource(new File(hdfsSitePath).toURI().toURL());
            }
            if (StringUtils.isNotBlank(hiveSitePath)) {
                configuration.addResource(new File(hiveSitePath).toURI().toURL());
            }
            if ((hadoopConf = readonlyConfig.getOptional(HiveConfig.HADOOP_CONF)).isPresent()) {
                ((Map)hadoopConf.get()).forEach((k, v) -> configuration.set(k, v));
            }
            return configuration;
        }
        catch (Exception e) {
            String errorMsg = String.format("Failed to load hadoop configuration, please check it", new Object[0]);
            log.error(errorMsg + ":" + ExceptionUtils.getMessage((Throwable)e));
            throw new HiveConnectorException((SeaTunnelErrorCode)HiveConnectorErrorCode.LOAD_HIVE_BASE_HADOOP_CONFIG_FAILED, e);
        }
    }
}

