/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.hive.storage;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.connectors.seatunnel.file.config.HadoopConf;
import org.apache.seatunnel.connectors.seatunnel.hive.exception.HiveConnectorErrorCode;
import org.apache.seatunnel.connectors.seatunnel.hive.exception.HiveConnectorException;
import org.apache.seatunnel.connectors.seatunnel.hive.storage.AbstractStorage;

public class HDFSStorage
extends AbstractStorage {
    private String hiveSdLocation;

    public HDFSStorage(String hiveSdLocation) {
        this.hiveSdLocation = hiveSdLocation;
    }

    @Override
    public HadoopConf buildHadoopConfWithReadOnlyConfig(ReadonlyConfig readonlyConfig) {
        try {
            String path = new URI(this.hiveSdLocation).getPath();
            HadoopConf hadoopConf = new HadoopConf(this.hiveSdLocation.replace(path, ""));
            Configuration configuration = this.loadHiveBaseHadoopConfig(readonlyConfig);
            Map propsInConfiguration = configuration.getPropsWithPrefix("");
            hadoopConf.setExtraOptions(propsInConfiguration);
            return hadoopConf;
        }
        catch (URISyntaxException e) {
            String errorMsg = String.format("Get hdfs namenode host from table location [%s] failed,please check it", this.hiveSdLocation);
            throw new HiveConnectorException(HiveConnectorErrorCode.GET_HDFS_NAMENODE_HOST_FAILED, errorMsg, e);
        }
    }
}

