/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.file.shaded.parquet.net.openhft.hashing;

import java.nio.ByteOrder;
import org.apache.seatunnel.shade.connector.file.shaded.parquet.net.openhft.hashing.Access;
import org.apache.seatunnel.shade.connector.file.shaded.parquet.net.openhft.hashing.LongHashFunction;
import org.apache.seatunnel.shade.connector.file.shaded.parquet.net.openhft.hashing.Primitives;

class CityAndFarmHash_1_1 {
    private static final CityAndFarmHash_1_1 INSTANCE = new CityAndFarmHash_1_1();
    private static final CityAndFarmHash_1_1 NATIVE_CITY = LongHashFunction.NATIVE_LITTLE_ENDIAN ? INSTANCE : BigEndian.access$000();
    static final long K0 = -4348849565147123417L;
    private static final long K1 = -5435081209227447693L;
    private static final long K2 = -7286425919675154353L;
    private static final long K_MUL = -7070675565921424023L;

    CityAndFarmHash_1_1() {
    }

    private static long shiftMix(long val) {
        return val ^ val >>> 47;
    }

    private static long hashLen16(long u, long v) {
        return CityAndFarmHash_1_1.hashLen16(u, v, -7070675565921424023L);
    }

    private static long hashLen16(long u, long v, long mul) {
        long a = CityAndFarmHash_1_1.shiftMix((u ^ v) * mul);
        return CityAndFarmHash_1_1.shiftMix((v ^ a) * mul) * mul;
    }

    private static long mul(long len) {
        return -7286425919675154353L + (len << 1);
    }

    private static long hash1To3Bytes(int len, int firstByte, int midOrLastByte, int lastByte) {
        int y = firstByte + (midOrLastByte << 8);
        int z = len + (lastByte << 2);
        return CityAndFarmHash_1_1.shiftMix((long)y * -7286425919675154353L ^ (long)z * -4348849565147123417L) * -7286425919675154353L;
    }

    private static long hash4To7Bytes(long len, long first4Bytes, long last4Bytes) {
        long mul = CityAndFarmHash_1_1.mul(len);
        return CityAndFarmHash_1_1.hashLen16(len + (first4Bytes << 3), last4Bytes, mul);
    }

    private static long hash8To16Bytes(long len, long first8Bytes, long last8Bytes) {
        long mul = CityAndFarmHash_1_1.mul(len);
        long a = first8Bytes + -7286425919675154353L;
        long c = Long.rotateRight(last8Bytes, 37) * mul + a;
        long d = (Long.rotateRight(a, 25) + last8Bytes) * mul;
        return CityAndFarmHash_1_1.hashLen16(c, d, mul);
    }

    <T> long fetch64(Access<T> access, T in, long off) {
        return access.getLong(in, off);
    }

    <T> int fetch32(Access<T> access, T in, long off) {
        return access.getInt(in, off);
    }

    long toLittleEndian(long v) {
        return v;
    }

    int toLittleEndian(int v) {
        return v;
    }

    private <T> long hashLen0To16(Access<T> access, T in, long off, long len) {
        if (len >= 8L) {
            long a = this.fetch64(access, in, off);
            long b = this.fetch64(access, in, off + len - 8L);
            return CityAndFarmHash_1_1.hash8To16Bytes(len, a, b);
        }
        if (len >= 4L) {
            long a = Primitives.unsignedInt(this.fetch32(access, in, off));
            long b = Primitives.unsignedInt(this.fetch32(access, in, off + len - 4L));
            return CityAndFarmHash_1_1.hash4To7Bytes(len, a, b);
        }
        if (len > 0L) {
            int a = access.getUnsignedByte(in, off);
            int b = access.getUnsignedByte(in, off + (len >> 1));
            int c = access.getUnsignedByte(in, off + len - 1L);
            return CityAndFarmHash_1_1.hash1To3Bytes((int)len, a, b, c);
        }
        return -7286425919675154353L;
    }

    private <T> long hashLen17To32(Access<T> access, T in, long off, long len) {
        long mul = CityAndFarmHash_1_1.mul(len);
        long a = this.fetch64(access, in, off) * -5435081209227447693L;
        long b = this.fetch64(access, in, off + 8L);
        long c = this.fetch64(access, in, off + len - 8L) * mul;
        long d = this.fetch64(access, in, off + len - 16L) * -7286425919675154353L;
        return CityAndFarmHash_1_1.hashLen16(Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
    }

    private <T> long cityHashLen33To64(Access<T> access, T in, long off, long len) {
        long mul = CityAndFarmHash_1_1.mul(len);
        long a = this.fetch64(access, in, off) * -7286425919675154353L;
        long b = this.fetch64(access, in, off + 8L);
        long c = this.fetch64(access, in, off + len - 24L);
        long d = this.fetch64(access, in, off + len - 32L);
        long e = this.fetch64(access, in, off + 16L) * -7286425919675154353L;
        long f = this.fetch64(access, in, off + 24L) * 9L;
        long g2 = this.fetch64(access, in, off + len - 8L);
        long h2 = this.fetch64(access, in, off + len - 16L) * mul;
        long u = Long.rotateRight(a + g2, 43) + (Long.rotateRight(b, 30) + c) * 9L;
        long v = (a + g2 ^ d) + f + 1L;
        long w = Long.reverseBytes((u + v) * mul) + h2;
        long x = Long.rotateRight(e + f, 42) + c;
        long y = (Long.reverseBytes((v + w) * mul) + g2) * mul;
        long z = e + f + c;
        a = Long.reverseBytes((x + z) * mul + y) + b;
        b = CityAndFarmHash_1_1.shiftMix((z + a) * mul + d + h2) * mul;
        return b + x;
    }

    <T> long cityHash64(Access<T> access, T in, long off, long len) {
        if (len <= 32L) {
            if (len <= 16L) {
                return this.hashLen0To16(access, in, off, len);
            }
            return this.hashLen17To32(access, in, off, len);
        }
        if (len <= 64L) {
            return this.cityHashLen33To64(access, in, off, len);
        }
        long x = this.fetch64(access, in, off + len - 40L);
        long y = this.fetch64(access, in, off + len - 16L) + this.fetch64(access, in, off + len - 56L);
        long z = CityAndFarmHash_1_1.hashLen16(this.fetch64(access, in, off + len - 48L) + len, this.fetch64(access, in, off + len - 24L));
        long a3 = len;
        long b3 = z;
        long w4 = this.fetch64(access, in, off + len - 64L);
        long x4 = this.fetch64(access, in, off + len - 64L + 8L);
        long y4 = this.fetch64(access, in, off + len - 64L + 16L);
        long z4 = this.fetch64(access, in, off + len - 64L + 24L);
        b3 = Long.rotateRight(b3 + (a3 += w4) + z4, 21);
        long c3 = a3;
        long vFirst = a3 + z4;
        long vSecond = (b3 += Long.rotateRight(a3 += x4 + y4, 44)) + c3;
        long a2 = y + -5435081209227447693L;
        long b2 = x;
        long w3 = this.fetch64(access, in, off + len - 32L);
        long x3 = this.fetch64(access, in, off + len - 32L + 8L);
        long y3 = this.fetch64(access, in, off + len - 32L + 16L);
        long z3 = this.fetch64(access, in, off + len - 32L + 24L);
        b2 = Long.rotateRight(b2 + (a2 += w3) + z3, 21);
        long c2 = a2;
        long wFirst = a2 + z3;
        long wSecond = (b2 += Long.rotateRight(a2 += x3 + y3, 44)) + c2;
        x = x * -5435081209227447693L + this.fetch64(access, in, off);
        len = len - 1L & 0xFFFFFFFFFFFFFFC0L;
        do {
            x = Long.rotateRight(x + y + vFirst + this.fetch64(access, in, off + 8L), 37) * -5435081209227447693L;
            y = Long.rotateRight(y + vSecond + this.fetch64(access, in, off + 48L), 42) * -5435081209227447693L;
            y += vFirst + this.fetch64(access, in, off + 40L);
            z = Long.rotateRight(z + wFirst, 33) * -5435081209227447693L;
            long a1 = vSecond * -5435081209227447693L;
            long b1 = (x ^= wSecond) + wFirst;
            long w2 = this.fetch64(access, in, off);
            long x2 = this.fetch64(access, in, off + 8L);
            long y2 = this.fetch64(access, in, off + 16L);
            long z2 = this.fetch64(access, in, off + 24L);
            b1 = Long.rotateRight(b1 + (a1 += w2) + z2, 21);
            long c1 = a1;
            vFirst = a1 + z2;
            vSecond = (b1 += Long.rotateRight(a1 += x2 + y2, 44)) + c1;
            long a = z + wSecond;
            long b = y + this.fetch64(access, in, off + 16L);
            long w1 = this.fetch64(access, in, off + 32L);
            long x1 = this.fetch64(access, in, off + 32L + 8L);
            long y1 = this.fetch64(access, in, off + 32L + 16L);
            long z1 = this.fetch64(access, in, off + 32L + 24L);
            b = Long.rotateRight(b + (a += w1) + z1, 21);
            long c = a;
            wFirst = a + z1;
            wSecond = (b += Long.rotateRight(a += x1 + y1, 44)) + c;
            long tmp = x;
            x = z;
            z = tmp;
            off += 64L;
        } while ((len -= 64L) != 0L);
        return CityAndFarmHash_1_1.hashLen16(CityAndFarmHash_1_1.hashLen16(vFirst, wFirst) + CityAndFarmHash_1_1.shiftMix(y) * -5435081209227447693L + z, CityAndFarmHash_1_1.hashLen16(vSecond, wSecond) + x);
    }

    static LongHashFunction asLongHashFunctionWithoutSeed() {
        return AsLongHashFunction.SEEDLESS_INSTANCE;
    }

    static LongHashFunction asLongHashFunctionWithSeed(long seed) {
        return new AsLongHashFunctionSeeded(-7286425919675154353L, seed);
    }

    static LongHashFunction asLongHashFunctionWithTwoSeeds(long seed0, long seed1) {
        return new AsLongHashFunctionSeeded(seed0, seed1);
    }

    private <T> long naHashLen33To64(Access<T> access, T in, long off, long len) {
        long mul = CityAndFarmHash_1_1.mul(len);
        long a = this.fetch64(access, in, off) * -7286425919675154353L;
        long b = this.fetch64(access, in, off + 8L);
        long c = this.fetch64(access, in, off + len - 8L) * mul;
        long d = this.fetch64(access, in, off + len - 16L) * -7286425919675154353L;
        long y = Long.rotateRight(a + b, 43) + Long.rotateRight(c, 30) + d;
        long z = CityAndFarmHash_1_1.hashLen16(y, a + Long.rotateRight(b + -7286425919675154353L, 18) + c, mul);
        long e = this.fetch64(access, in, off + 16L) * mul;
        long f = this.fetch64(access, in, off + 24L);
        long g2 = (y + this.fetch64(access, in, off + len - 32L)) * mul;
        long h2 = (z + this.fetch64(access, in, off + len - 24L)) * mul;
        return CityAndFarmHash_1_1.hashLen16(Long.rotateRight(e + f, 43) + Long.rotateRight(g2, 30) + h2, e + Long.rotateRight(f + a, 18) + g2, mul);
    }

    <T> long naHash64(Access<T> access, T in, long off, long len) {
        long seed = 81L;
        if (len <= 32L) {
            if (len <= 16L) {
                return this.hashLen0To16(access, in, off, len);
            }
            return this.hashLen17To32(access, in, off, len);
        }
        if (len <= 64L) {
            return this.naHashLen33To64(access, in, off, len);
        }
        long x = 81L;
        long y = 2480279821605975764L;
        long z = CityAndFarmHash_1_1.shiftMix(y * -7286425919675154353L + 113L) * -7286425919675154353L;
        long v1 = 0L;
        long v2 = 0L;
        long w1 = 0L;
        long w2 = 0L;
        x = x * -7286425919675154353L + this.fetch64(access, in, off);
        long end = off + (len - 1L >> 6) * 64L;
        long last64 = end + (len - 1L & 0x3FL) - 63L;
        do {
            x = Long.rotateRight(x + y + v1 + this.fetch64(access, in, off + 8L), 37) * -5435081209227447693L;
            y = Long.rotateRight(y + v2 + this.fetch64(access, in, off + 48L), 42) * -5435081209227447693L;
            y += v1 + this.fetch64(access, in, off + 40L);
            z = Long.rotateRight(z + w1, 33) * -5435081209227447693L;
            long a = v2 * -5435081209227447693L;
            long b = (x ^= w2) + w1;
            long z1 = this.fetch64(access, in, off + 24L);
            b = Long.rotateRight(b + (a += this.fetch64(access, in, off)) + z1, 21);
            long c = a;
            a += this.fetch64(access, in, off + 8L);
            v1 = a + z1;
            v2 = (b += Long.rotateRight(a += this.fetch64(access, in, off + 16L), 44)) + c;
            long a1 = z + w2;
            long b1 = y + this.fetch64(access, in, off + 16L);
            long z2 = this.fetch64(access, in, off + 32L + 24L);
            b1 = Long.rotateRight(b1 + (a1 += this.fetch64(access, in, off + 32L)) + z2, 21);
            long c1 = a1;
            a1 += this.fetch64(access, in, off + 32L + 8L);
            w1 = a1 + z2;
            w2 = (b1 += Long.rotateRight(a1 += this.fetch64(access, in, off + 32L + 16L), 44)) + c1;
            long t = z;
            z = x;
            x = t;
        } while ((off += 64L) != end);
        off = last64;
        long mul = -5435081209227447693L + ((z & 0xFFL) << 1);
        x = Long.rotateRight(x + y + (v1 += (w1 += len - 1L & 0x3FL)) + this.fetch64(access, in, off + 8L), 37) * mul;
        y = Long.rotateRight(y + v2 + this.fetch64(access, in, off + 48L), 42) * mul;
        y += v1 * 9L + this.fetch64(access, in, off + 40L);
        z = Long.rotateRight(z + (w1 += v1), 33) * mul;
        long a = v2 * mul;
        long b = (x ^= w2 * 9L) + w1;
        long z1 = this.fetch64(access, in, off + 24L);
        b = Long.rotateRight(b + (a += this.fetch64(access, in, off)) + z1, 21);
        long c = a;
        a += this.fetch64(access, in, off + 8L);
        v1 = a + z1;
        v2 = (b += Long.rotateRight(a += this.fetch64(access, in, off + 16L), 44)) + c;
        long a1 = z + w2;
        long b1 = y + this.fetch64(access, in, off + 16L);
        long z2 = this.fetch64(access, in, off + 32L + 24L);
        b1 = Long.rotateRight(b1 + (a1 += this.fetch64(access, in, off + 32L)) + z2, 21);
        long c1 = a1;
        a1 += this.fetch64(access, in, off + 32L + 8L);
        w1 = a1 + z2;
        w2 = (b1 += Long.rotateRight(a1 += this.fetch64(access, in, off + 32L + 16L), 44)) + c1;
        long t = z;
        z = x;
        x = t;
        return CityAndFarmHash_1_1.hashLen16(CityAndFarmHash_1_1.hashLen16(v1, w1, mul) + CityAndFarmHash_1_1.shiftMix(y) * -4348849565147123417L + z, CityAndFarmHash_1_1.hashLen16(v2, w2, mul) + x, mul);
    }

    private <T> long naHash64WithSeeds(Access<T> access, T in, long off, long len, long seed0, long seed1) {
        return CityAndFarmHash_1_1.hashLen16(this.naHash64(access, in, off, len) - seed0, seed1);
    }

    private long uoH(long x, long y, long mul, int r) {
        long a = (x ^ y) * mul;
        a = CityAndFarmHash_1_1.shiftMix(a);
        long b = (y ^ a) * mul;
        return Long.rotateRight(b, r) * mul;
    }

    <T> long uoHash64WithSeeds(Access<T> access, T in, long off, long len, long seed0, long seed1) {
        if (len <= 64L) {
            return this.naHash64WithSeeds(access, in, off, len, seed0, seed1);
        }
        long x = seed0;
        long y = seed1 * -7286425919675154353L + 113L;
        long z = CityAndFarmHash_1_1.shiftMix(y * -7286425919675154353L) * -7286425919675154353L;
        long v0 = seed0;
        long v1 = seed1;
        long w0 = 0L;
        long w1 = 0L;
        long u = x - z;
        x *= -7286425919675154353L;
        long mul = -7286425919675154353L + (u & 0x82L);
        long end = off + (len - 1L >> 6) * 64L;
        long last64 = end + (len - 1L & 0x3FL) - 63L;
        do {
            long a0 = this.fetch64(access, in, off);
            long a1 = this.fetch64(access, in, off + 8L);
            long a2 = this.fetch64(access, in, off + 16L);
            long a3 = this.fetch64(access, in, off + 24L);
            long a4 = this.fetch64(access, in, off + 32L);
            long a5 = this.fetch64(access, in, off + 40L);
            long a6 = this.fetch64(access, in, off + 48L);
            long a7 = this.fetch64(access, in, off + 56L);
            x += a0 + a1;
            y += a2;
            z += a3;
            v0 += a4;
            v1 += a5 + a1;
            w0 += a6;
            w1 += a7;
            x = Long.rotateRight(x, 26);
            y = Long.rotateRight(y, 29);
            z *= mul;
            v0 = Long.rotateRight(v0, 33);
            v1 = Long.rotateRight(v1, 30);
            w0 ^= (x *= 9L);
            w0 *= 9L;
            z = Long.rotateRight(z, 32);
            z += w1;
            w1 += z;
            z *= 9L;
            long t = u;
            u = y;
            y = t;
            z += a0 + a6;
            v1 += a3;
            w1 += a5 + a6;
            y += a7;
            y += (v0 += a2);
            v0 += (x += a1) - y;
            v1 += (w0 += a4);
            w0 += v1;
            w1 += x - y;
            x += w1;
            w1 = Long.rotateRight(w1, 34);
            t = u;
            u = z;
            z = t;
        } while ((off += 64L) != end);
        off = last64;
        u *= 9L;
        v1 = Long.rotateRight(v1, 28);
        v0 = Long.rotateRight(v0, 20);
        u += y;
        x = Long.rotateRight((y += u) - x + v0 + this.fetch64(access, in, off + 8L), 37) * mul;
        y = Long.rotateRight(y ^ v1 ^ this.fetch64(access, in, off + 48L), 42) * mul;
        y += v0 + this.fetch64(access, in, off + 40L);
        z = Long.rotateRight(z + (w0 += len - 1L & 0x3FL), 33) * mul;
        long a = v1 * mul;
        long b = (x ^= w1 * 9L) + w0;
        long z1 = this.fetch64(access, in, off + 24L);
        b = Long.rotateRight(b + (a += this.fetch64(access, in, off)) + z1, 21);
        long c = a;
        a += this.fetch64(access, in, off + 8L);
        v0 = a + z1;
        v1 = (b += Long.rotateRight(a += this.fetch64(access, in, off + 16L), 44)) + c;
        long a1 = z + w1;
        long b1 = y + this.fetch64(access, in, off + 16L);
        long z2 = this.fetch64(access, in, off + 32L + 24L);
        b1 = Long.rotateRight(b1 + (a1 += this.fetch64(access, in, off + 32L)) + z2, 21);
        long c1 = a1;
        a1 += this.fetch64(access, in, off + 32L + 8L);
        w0 = a1 + z2;
        w1 = (b1 += Long.rotateRight(a1 += this.fetch64(access, in, off + 32L + 16L), 44)) + c1;
        return this.uoH(CityAndFarmHash_1_1.hashLen16(v0 + x, w0 ^ y, mul) + z - u, this.uoH(v1 + y, w1 + z, -7286425919675154353L, 30) ^ x, -7286425919675154353L, 31);
    }

    static LongHashFunction naWithoutSeeds() {
        return Na.SEEDLESS_NA;
    }

    static LongHashFunction naWithSeed(long seed) {
        return new NaSeeded(-7286425919675154353L, seed);
    }

    static LongHashFunction naWithSeeds(long seed0, long seed1) {
        return new NaSeeded(seed0, seed1);
    }

    static LongHashFunction uoWithoutSeeds() {
        return Uo.SEEDLESS_UO;
    }

    static LongHashFunction uoWithSeed(long seed) {
        return new UoWithOneSeed(seed);
    }

    static LongHashFunction uoWithSeeds(long seed0, long seed1) {
        return new UoSeeded(seed0, seed1);
    }

    private static class UoSeeded
    extends AsLongHashFunctionSeeded {
        private static final long serialVersionUID = 0L;

        private UoSeeded(long seed0, long seed1) {
            super(seed0, seed1);
        }

        @Override
        public <T> long hash(T input, Access<T> access, long off, long len) {
            if (access.byteOrder(input) == ByteOrder.LITTLE_ENDIAN) {
                return INSTANCE.uoHash64WithSeeds(access, input, off, len, this.seed0, this.seed1);
            }
            return BigEndian.INSTANCE.uoHash64WithSeeds(access, input, off, len, this.seed0, this.seed1);
        }
    }

    private static final class UoWithOneSeed
    extends AsLongHashFunctionSeeded {
        private static final long serialVersionUID = 0L;

        private UoWithOneSeed(long seed) {
            super(-7286425919675154353L, seed);
        }

        @Override
        public <T> long hash(T input, Access<T> access, long off, long len) {
            CityAndFarmHash_1_1 instance;
            CityAndFarmHash_1_1 cityAndFarmHash_1_1 = instance = access.byteOrder(input) == ByteOrder.LITTLE_ENDIAN ? INSTANCE : BigEndian.INSTANCE;
            if (len <= 64L) {
                return this.finalize(instance.naHash64(access, input, off, len));
            }
            return instance.uoHash64WithSeeds(access, input, off, len, 0L, this.seed1);
        }
    }

    private static final class Uo
    extends AsLongHashFunction {
        private static final long serialVersionUID = 0L;
        private static final Uo SEEDLESS_UO = new Uo();

        private Uo() {
        }

        private Object readResolve() {
            return SEEDLESS_UO;
        }

        @Override
        public <T> long hash(T input, Access<T> access, long off, long len) {
            CityAndFarmHash_1_1 instance;
            CityAndFarmHash_1_1 cityAndFarmHash_1_1 = instance = access.byteOrder(input) == ByteOrder.LITTLE_ENDIAN ? INSTANCE : BigEndian.INSTANCE;
            if (len <= 64L) {
                return instance.naHash64(access, input, off, len);
            }
            return instance.uoHash64WithSeeds(access, input, off, len, 81L, 0L);
        }
    }

    private static class NaSeeded
    extends Na {
        private static final long serialVersionUID = 0L;
        private final long seed0;
        private final long seed1;
        private final transient long voidHash;

        private NaSeeded(long seed0, long seed1) {
            this.seed0 = seed0;
            this.seed1 = seed1;
            this.voidHash = this.finalize(-7286425919675154353L);
        }

        @Override
        public long hashVoid() {
            return this.voidHash;
        }

        @Override
        protected long finalize(long hash) {
            return CityAndFarmHash_1_1.hashLen16(hash - this.seed0, this.seed1);
        }
    }

    private static class Na
    extends AsLongHashFunction {
        private static final long serialVersionUID = 0L;
        private static final Na SEEDLESS_NA = new Na();

        private Na() {
        }

        private Object readResolve() {
            return SEEDLESS_NA;
        }

        @Override
        public <T> long hash(T input, Access<T> access, long off, long len) {
            long hash = access.byteOrder(input) == ByteOrder.LITTLE_ENDIAN ? INSTANCE.naHash64(access, input, off, len) : BigEndian.INSTANCE.naHash64(access, input, off, len);
            return this.finalize(hash);
        }
    }

    private static class AsLongHashFunctionSeeded
    extends AsLongHashFunction {
        private static final long serialVersionUID = 0L;
        final long seed0;
        final long seed1;
        private final transient long voidHash;

        private AsLongHashFunctionSeeded(long seed0, long seed1) {
            this.seed0 = seed0;
            this.seed1 = seed1;
            this.voidHash = this.finalize(-7286425919675154353L);
        }

        @Override
        public long hashVoid() {
            return this.voidHash;
        }

        @Override
        protected long finalize(long hash) {
            return CityAndFarmHash_1_1.hashLen16(hash - this.seed0, this.seed1);
        }
    }

    private static class AsLongHashFunction
    extends LongHashFunction {
        private static final long serialVersionUID = 0L;
        private static final AsLongHashFunction SEEDLESS_INSTANCE = new AsLongHashFunction();
        private static final int FIRST_SHORT_BYTE_SHIFT = NATIVE_LITTLE_ENDIAN ? 0 : 8;
        private static final int FIRST_SHORT_BYTE_MASK = NATIVE_LITTLE_ENDIAN ? 255 : -1;
        private static final int SECOND_SHORT_BYTE_SHIFT = 8 - FIRST_SHORT_BYTE_SHIFT;
        private static final int SECOND_SHORT_BYTE_MASK = NATIVE_LITTLE_ENDIAN ? -1 : 255;

        private AsLongHashFunction() {
        }

        private Object readResolve() {
            return SEEDLESS_INSTANCE;
        }

        @Override
        public long hashLong(long input) {
            input = NATIVE_CITY.toLittleEndian(input);
            long hash = CityAndFarmHash_1_1.hash8To16Bytes(8L, input, input);
            return this.finalize(hash);
        }

        @Override
        public long hashInt(int input) {
            input = NATIVE_CITY.toLittleEndian(input);
            long unsignedInt = Primitives.unsignedInt(input);
            long hash = CityAndFarmHash_1_1.hash4To7Bytes(4L, unsignedInt, unsignedInt);
            return this.finalize(hash);
        }

        @Override
        public long hashShort(short input) {
            return this.hashChar((char)input);
        }

        @Override
        public long hashChar(char input) {
            char unsignedInput = input;
            int firstByte = unsignedInput >> FIRST_SHORT_BYTE_SHIFT & FIRST_SHORT_BYTE_MASK;
            int secondByte = unsignedInput >> SECOND_SHORT_BYTE_SHIFT & SECOND_SHORT_BYTE_MASK;
            long hash = CityAndFarmHash_1_1.hash1To3Bytes(2, firstByte, secondByte, secondByte);
            return this.finalize(hash);
        }

        @Override
        public long hashByte(byte input) {
            int unsignedByte = Primitives.unsignedByte(input);
            long hash = CityAndFarmHash_1_1.hash1To3Bytes(1, unsignedByte, unsignedByte, unsignedByte);
            return this.finalize(hash);
        }

        @Override
        public long hashVoid() {
            return -7286425919675154353L;
        }

        @Override
        public <T> long hash(T input, Access<T> access, long off, long len) {
            long hash = access.byteOrder(input) == ByteOrder.LITTLE_ENDIAN ? INSTANCE.cityHash64(access, input, off, len) : BigEndian.INSTANCE.cityHash64(access, input, off, len);
            return this.finalize(hash);
        }

        long finalize(long hash) {
            return hash;
        }
    }

    private static class BigEndian
    extends CityAndFarmHash_1_1 {
        private static final BigEndian INSTANCE = new BigEndian();

        private BigEndian() {
        }

        @Override
        <T> long fetch64(Access<T> access, T in, long off) {
            return Long.reverseBytes(super.fetch64(access, in, off));
        }

        @Override
        <T> int fetch32(Access<T> access, T in, long off) {
            return Integer.reverseBytes(super.fetch32(access, in, off));
        }

        @Override
        long toLittleEndian(long v) {
            return Long.reverseBytes(v);
        }

        @Override
        int toLittleEndian(int v) {
            return Integer.reverseBytes(v);
        }
    }
}

