/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.hive.org.apache.orc;

import java.util.ServiceLoader;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.TypeDescription;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.storage.ql.exec.vector.ColumnVector;

public interface DataMask {
    public void maskData(ColumnVector var1, ColumnVector var2, int var3, int var4);

    public static class Factory {
        private static final ServiceLoader<Provider> LOADER = ServiceLoader.load(Provider.class);

        public static DataMask build(String name, TypeDescription schema, String ... params) {
            for (Provider provider : LOADER) {
                DataMask result = provider.build(name, schema, params);
                if (result == null) continue;
                return result;
            }
            StringBuilder msg = new StringBuilder();
            msg.append("Can't find data mask - ");
            msg.append(name);
            for (int i = 0; i < params.length; ++i) {
                msg.append(", ");
                msg.append(params[i]);
            }
            throw new IllegalArgumentException(msg.toString());
        }
    }

    public static interface Provider {
        public DataMask build(String var1, TypeDescription var2, String ... var3);
    }

    public static enum Standard {
        NULLIFY("nullify"),
        REDACT("redact"),
        SHA256("sha256");

        private final String name;

        private Standard(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public DataMask build(TypeDescription schema, String ... params) {
            return Factory.build(this.name, schema, params);
        }
    }
}

