/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.hive.org.apache.orc.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.CompressionCodec;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.PhysicalWriter;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.impl.PositionRecorder;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.impl.PositionedOutputStream;

public class OutStream
extends PositionedOutputStream {
    public static final int HEADER_SIZE = 3;
    private final String name;
    private final PhysicalWriter.OutputReceiver receiver;
    private ByteBuffer current = null;
    private ByteBuffer compressed = null;
    private ByteBuffer overflow = null;
    private final int bufferSize;
    private final CompressionCodec codec;
    private long compressedBytes = 0L;
    private long uncompressedBytes = 0L;

    public OutStream(String name, int bufferSize, CompressionCodec codec, PhysicalWriter.OutputReceiver receiver) throws IOException {
        this.name = name;
        this.bufferSize = bufferSize;
        this.codec = codec;
        this.receiver = receiver;
    }

    public void clear() throws IOException {
        this.flush();
    }

    private static void writeHeader(ByteBuffer buffer, int position, int val, boolean original) {
        buffer.put(position, (byte)((val << 1) + (original ? 1 : 0)));
        buffer.put(position + 1, (byte)(val >> 7));
        buffer.put(position + 2, (byte)(val >> 15));
    }

    private void getNewInputBuffer() throws IOException {
        if (this.codec == null) {
            this.current = ByteBuffer.allocate(this.bufferSize);
        } else {
            this.current = ByteBuffer.allocate(this.bufferSize + 3);
            OutStream.writeHeader(this.current, 0, this.bufferSize, true);
            this.current.position(3);
        }
    }

    public static void assertBufferSizeValid(int bufferSize) throws IllegalArgumentException {
        if (bufferSize >= 0x800000) {
            throw new IllegalArgumentException("Illegal value of ORC compression buffer size: " + bufferSize);
        }
    }

    private ByteBuffer getNewOutputBuffer() throws IOException {
        return ByteBuffer.allocate(this.bufferSize + 3);
    }

    private void flip() throws IOException {
        this.current.limit(this.current.position());
        this.current.position(this.codec == null ? 0 : 3);
    }

    @Override
    public void write(int i) throws IOException {
        if (this.current == null) {
            this.getNewInputBuffer();
        }
        if (this.current.remaining() < 1) {
            this.spill();
        }
        ++this.uncompressedBytes;
        this.current.put((byte)i);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        if (this.current == null) {
            this.getNewInputBuffer();
        }
        int remaining = Math.min(this.current.remaining(), length);
        this.current.put(bytes, offset, remaining);
        this.uncompressedBytes += (long)remaining;
        length -= remaining;
        while (length != 0) {
            this.spill();
            remaining = Math.min(this.current.remaining(), length);
            this.current.put(bytes, offset += remaining, remaining);
            this.uncompressedBytes += (long)remaining;
            length -= remaining;
        }
    }

    private void spill() throws IOException {
        if (this.current == null || this.current.position() == (this.codec == null ? 0 : 3)) {
            return;
        }
        this.flip();
        if (this.codec == null) {
            this.receiver.output(this.current);
            this.getNewInputBuffer();
        } else {
            if (this.compressed == null) {
                this.compressed = this.getNewOutputBuffer();
            } else if (this.overflow == null) {
                this.overflow = this.getNewOutputBuffer();
            }
            int sizePosn = this.compressed.position();
            this.compressed.position(this.compressed.position() + 3);
            if (this.codec.compress(this.current, this.compressed, this.overflow)) {
                this.uncompressedBytes = 0L;
                this.current.position(3);
                this.current.limit(this.current.capacity());
                int totalBytes = this.compressed.position() - sizePosn - 3;
                if (this.overflow != null) {
                    totalBytes += this.overflow.position();
                }
                this.compressedBytes += (long)(totalBytes + 3);
                OutStream.writeHeader(this.compressed, sizePosn, totalBytes, false);
                if (this.compressed.remaining() < 3) {
                    this.compressed.flip();
                    this.receiver.output(this.compressed);
                    this.compressed = this.overflow;
                    this.overflow = null;
                }
            } else {
                this.compressedBytes += this.uncompressedBytes + 3L;
                this.uncompressedBytes = 0L;
                if (sizePosn != 0) {
                    this.compressed.position(sizePosn);
                    this.compressed.flip();
                    this.receiver.output(this.compressed);
                    this.compressed = null;
                    if (this.overflow != null) {
                        this.overflow.clear();
                        this.compressed = this.overflow;
                        this.overflow = null;
                    }
                } else {
                    this.compressed.clear();
                    if (this.overflow != null) {
                        this.overflow.clear();
                    }
                }
                this.current.position(0);
                OutStream.writeHeader(this.current, 0, this.current.limit() - 3, true);
                this.receiver.output(this.current);
                this.getNewInputBuffer();
            }
        }
    }

    @Override
    public void getPosition(PositionRecorder recorder) throws IOException {
        if (this.codec == null) {
            recorder.addPosition(this.uncompressedBytes);
        } else {
            recorder.addPosition(this.compressedBytes);
            recorder.addPosition(this.uncompressedBytes);
        }
    }

    @Override
    public void flush() throws IOException {
        this.spill();
        if (this.compressed != null && this.compressed.position() != 0) {
            this.compressed.flip();
            this.receiver.output(this.compressed);
        }
        this.compressed = null;
        this.uncompressedBytes = 0L;
        this.compressedBytes = 0L;
        this.overflow = null;
        this.current = null;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public long getBufferSize() {
        if (this.codec == null) {
            return this.uncompressedBytes + (long)(this.current == null ? 0 : this.current.remaining());
        }
        long result = 0L;
        if (this.current != null) {
            result += (long)this.current.capacity();
        }
        if (this.compressed != null) {
            result += (long)this.compressed.capacity();
        }
        if (this.overflow != null) {
            result += (long)this.overflow.capacity();
        }
        return result + this.compressedBytes;
    }

    public void suppress() {
        this.receiver.suppress();
    }
}

