/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.hive.org.apache.orc.impl.writer;

import java.io.IOException;
import java.util.List;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.OrcFile;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.OrcProto;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.TypeDescription;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.impl.BitFieldWriter;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.impl.ColumnStatisticsImpl;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.impl.IntegerWriter;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.impl.OutStream;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.impl.PositionRecorder;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.impl.PositionedOutputStream;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.impl.RunLengthIntegerWriter;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.impl.RunLengthIntegerWriterV2;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.impl.StreamName;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.impl.writer.TreeWriter;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.impl.writer.WriterContext;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.util.BloomFilter;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.util.BloomFilterIO;
import org.apache.seatunnel.shade.connector.hive.org.apache.orc.util.BloomFilterUtf8;

public abstract class TreeWriterBase
implements TreeWriter {
    protected final int id;
    protected final BitFieldWriter isPresent;
    private final boolean isCompressed;
    protected final ColumnStatisticsImpl indexStatistics;
    protected final ColumnStatisticsImpl stripeColStatistics;
    protected final ColumnStatisticsImpl fileStatistics;
    protected final RowIndexPositionRecorder rowIndexPosition;
    private final OrcProto.RowIndex.Builder rowIndex;
    private final OrcProto.RowIndexEntry.Builder rowIndexEntry;
    protected final BloomFilter bloomFilter;
    protected final BloomFilterUtf8 bloomFilterUtf8;
    protected final boolean createBloomFilter;
    private final OrcProto.BloomFilterIndex.Builder bloomFilterIndex;
    private final OrcProto.BloomFilterIndex.Builder bloomFilterIndexUtf8;
    protected final OrcProto.BloomFilter.Builder bloomFilterEntry;
    private boolean foundNulls;
    private OutStream isPresentOutStream;
    private final WriterContext streamFactory;
    private final TypeDescription schema;

    TreeWriterBase(int columnId, TypeDescription schema, WriterContext streamFactory, boolean nullable) throws IOException {
        this.schema = schema;
        this.streamFactory = streamFactory;
        this.isCompressed = streamFactory.isCompressed();
        this.id = columnId;
        if (nullable) {
            this.isPresentOutStream = streamFactory.createStream(this.id, OrcProto.Stream.Kind.PRESENT);
            this.isPresent = new BitFieldWriter(this.isPresentOutStream, 1);
        } else {
            this.isPresent = null;
        }
        this.foundNulls = false;
        this.createBloomFilter = streamFactory.getBloomFilterColumns()[columnId];
        this.indexStatistics = ColumnStatisticsImpl.create(schema);
        this.stripeColStatistics = ColumnStatisticsImpl.create(schema);
        this.fileStatistics = ColumnStatisticsImpl.create(schema);
        if (streamFactory.buildIndex()) {
            this.rowIndex = OrcProto.RowIndex.newBuilder();
            this.rowIndexEntry = OrcProto.RowIndexEntry.newBuilder();
            this.rowIndexPosition = new RowIndexPositionRecorder(this.rowIndexEntry);
        } else {
            this.rowIndex = null;
            this.rowIndexEntry = null;
            this.rowIndexPosition = null;
        }
        if (this.createBloomFilter) {
            this.bloomFilterEntry = OrcProto.BloomFilter.newBuilder();
            if (streamFactory.getBloomFilterVersion() == OrcFile.BloomFilterVersion.ORIGINAL) {
                this.bloomFilter = new BloomFilter(streamFactory.getRowIndexStride(), streamFactory.getBloomFilterFPP());
                this.bloomFilterIndex = OrcProto.BloomFilterIndex.newBuilder();
            } else {
                this.bloomFilter = null;
                this.bloomFilterIndex = null;
            }
            this.bloomFilterUtf8 = new BloomFilterUtf8(streamFactory.getRowIndexStride(), streamFactory.getBloomFilterFPP());
            this.bloomFilterIndexUtf8 = OrcProto.BloomFilterIndex.newBuilder();
        } else {
            this.bloomFilterEntry = null;
            this.bloomFilterIndex = null;
            this.bloomFilterIndexUtf8 = null;
            this.bloomFilter = null;
            this.bloomFilterUtf8 = null;
        }
    }

    protected OrcProto.RowIndex.Builder getRowIndex() {
        return this.rowIndex;
    }

    protected ColumnStatisticsImpl getStripeStatistics() {
        return this.stripeColStatistics;
    }

    protected OrcProto.RowIndexEntry.Builder getRowIndexEntry() {
        return this.rowIndexEntry;
    }

    IntegerWriter createIntegerWriter(PositionedOutputStream output, boolean signed, boolean isDirectV2, WriterContext writer) {
        if (isDirectV2) {
            boolean alignedBitpacking = false;
            if (writer.getEncodingStrategy().equals((Object)OrcFile.EncodingStrategy.SPEED)) {
                alignedBitpacking = true;
            }
            return new RunLengthIntegerWriterV2(output, signed, alignedBitpacking);
        }
        return new RunLengthIntegerWriter(output, signed);
    }

    boolean isNewWriteFormat(WriterContext writer) {
        return writer.getVersion() != OrcFile.Version.V_0_11;
    }

    @Override
    public void writeRootBatch(VectorizedRowBatch batch, int offset, int length) throws IOException {
        this.writeBatch(batch.cols[0], offset, length);
    }

    @Override
    public void writeBatch(ColumnVector vector, int offset, int length) throws IOException {
        if (vector.noNulls) {
            this.indexStatistics.increment(length);
            if (this.isPresent != null) {
                for (int i = 0; i < length; ++i) {
                    this.isPresent.write(1);
                }
            }
        } else if (vector.isRepeating) {
            boolean isNull = vector.isNull[0];
            if (this.isPresent != null) {
                for (int i = 0; i < length; ++i) {
                    this.isPresent.write(isNull ? 0 : 1);
                }
            }
            if (isNull) {
                this.foundNulls = true;
                this.indexStatistics.setNull();
            } else {
                this.indexStatistics.increment(length);
            }
        } else {
            int nonNullCount = 0;
            for (int i = 0; i < length; ++i) {
                boolean isNull = vector.isNull[i + offset];
                if (!isNull) {
                    ++nonNullCount;
                }
                if (this.isPresent == null) continue;
                this.isPresent.write(isNull ? 0 : 1);
            }
            this.indexStatistics.increment(nonNullCount);
            if (nonNullCount != length) {
                this.foundNulls = true;
                this.indexStatistics.setNull();
            }
        }
    }

    private void removeIsPresentPositions() {
        for (int i = 0; i < this.rowIndex.getEntryCount(); ++i) {
            OrcProto.RowIndexEntry.Builder entry = this.rowIndex.getEntryBuilder(i);
            List<Long> positions = entry.getPositionsList();
            positions = positions.subList(this.isCompressed ? 4 : 3, positions.size());
            entry.clearPositions();
            entry.addAllPositions(positions);
        }
    }

    @Override
    public void flushStreams() throws IOException {
        if (this.isPresent != null) {
            this.isPresent.flush();
        }
    }

    @Override
    public void writeStripe(OrcProto.StripeFooter.Builder builder, OrcProto.StripeStatistics.Builder stats, int requiredIndexEntries) throws IOException {
        if (this.isPresent != null && !this.foundNulls) {
            this.isPresentOutStream.suppress();
            if (this.rowIndex != null) {
                this.removeIsPresentPositions();
            }
        }
        long byteCount = this.streamFactory.getPhysicalWriter().getFileBytes(this.id);
        this.stripeColStatistics.updateByteCount(byteCount);
        this.fileStatistics.merge(this.stripeColStatistics);
        stats.addColStats(this.stripeColStatistics.serialize());
        this.stripeColStatistics.reset();
        this.foundNulls = false;
        builder.addColumns(this.getEncoding());
        if (this.rowIndex != null) {
            if (this.rowIndex.getEntryCount() != requiredIndexEntries) {
                throw new IllegalArgumentException("Column has wrong number of index entries found: " + this.rowIndex.getEntryCount() + " expected: " + requiredIndexEntries);
            }
            this.streamFactory.writeIndex(new StreamName(this.id, OrcProto.Stream.Kind.ROW_INDEX), this.rowIndex);
            this.rowIndex.clear();
            this.rowIndexEntry.clear();
        }
        if (this.bloomFilterIndex != null) {
            this.streamFactory.writeBloomFilter(new StreamName(this.id, OrcProto.Stream.Kind.BLOOM_FILTER), this.bloomFilterIndex);
            this.bloomFilterIndex.clear();
        }
        if (this.bloomFilterIndexUtf8 != null) {
            this.streamFactory.writeBloomFilter(new StreamName(this.id, OrcProto.Stream.Kind.BLOOM_FILTER_UTF8), this.bloomFilterIndexUtf8);
            this.bloomFilterIndexUtf8.clear();
        }
    }

    OrcProto.ColumnEncoding.Builder getEncoding() {
        OrcProto.ColumnEncoding.Builder builder = OrcProto.ColumnEncoding.newBuilder().setKind(OrcProto.ColumnEncoding.Kind.DIRECT);
        if (this.createBloomFilter) {
            builder.setBloomEncoding(BloomFilterIO.Encoding.CURRENT.getId());
        }
        return builder;
    }

    @Override
    public void createRowIndexEntry() throws IOException {
        this.stripeColStatistics.merge(this.indexStatistics);
        this.rowIndexEntry.setStatistics(this.indexStatistics.serialize());
        this.indexStatistics.reset();
        this.rowIndex.addEntry(this.rowIndexEntry);
        this.rowIndexEntry.clear();
        this.addBloomFilterEntry();
        this.recordPosition(this.rowIndexPosition);
    }

    void addBloomFilterEntry() {
        if (this.createBloomFilter) {
            if (this.bloomFilter != null) {
                BloomFilterIO.serialize(this.bloomFilterEntry, this.bloomFilter);
                this.bloomFilterIndex.addBloomFilter(this.bloomFilterEntry.build());
                this.bloomFilter.reset();
            }
            if (this.bloomFilterUtf8 != null) {
                BloomFilterIO.serialize(this.bloomFilterEntry, this.bloomFilterUtf8);
                this.bloomFilterIndexUtf8.addBloomFilter(this.bloomFilterEntry.build());
                this.bloomFilterUtf8.reset();
            }
        }
    }

    @Override
    public void updateFileStatistics(OrcProto.StripeStatistics stats) {
        this.fileStatistics.merge(ColumnStatisticsImpl.deserialize(this.schema, stats.getColStats(this.id)));
    }

    void recordPosition(PositionRecorder recorder) throws IOException {
        if (this.isPresent != null) {
            this.isPresent.getPosition(recorder);
        }
    }

    @Override
    public long estimateMemory() {
        long result = 0L;
        if (this.isPresent != null) {
            result = this.isPresentOutStream.getBufferSize();
        }
        return result;
    }

    @Override
    public void writeFileStatistics(OrcProto.Footer.Builder footer) {
        footer.addStatistics(this.fileStatistics.serialize());
    }

    static class RowIndexPositionRecorder
    implements PositionRecorder {
        private final OrcProto.RowIndexEntry.Builder builder;

        RowIndexPositionRecorder(OrcProto.RowIndexEntry.Builder builder) {
            this.builder = builder;
        }

        @Override
        public void addPosition(long position) {
            this.builder.addPositions(position);
        }
    }
}

