/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.shade.connector.hive.org.apache.orc.storage.ql.exec.vector;

import org.apache.seatunnel.shade.connector.hive.org.apache.orc.storage.ql.exec.vector.ColumnVector;

public class UnionColumnVector
extends ColumnVector {
    public int[] tags;
    public ColumnVector[] fields;

    public UnionColumnVector() {
        this(1024, new ColumnVector[0]);
    }

    public UnionColumnVector(int len, ColumnVector ... fields) {
        super(ColumnVector.Type.UNION, len);
        this.tags = new int[len];
        this.fields = fields;
    }

    @Override
    public void flatten(boolean selectedInUse, int[] sel, int size) {
        this.flattenPush();
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].flatten(selectedInUse, sel, size);
        }
        this.flattenNoNulls(selectedInUse, sel, size);
    }

    @Override
    public void setElement(int outputElementNum, int inputElementNum, ColumnVector inputColVector) {
        if (this.isRepeating && outputElementNum != 0) {
            throw new RuntimeException("Output column number expected to be 0 when isRepeating");
        }
        if (inputColVector.isRepeating) {
            inputElementNum = 0;
        }
        if (!this.noNulls && this.isNull[outputElementNum]) {
            return;
        }
        if (inputColVector.noNulls || !inputColVector.isNull[inputElementNum]) {
            int tag;
            UnionColumnVector input = (UnionColumnVector)inputColVector;
            this.tags[outputElementNum] = tag = input.tags[inputElementNum];
            ColumnVector inputField = input.fields[tag];
            ColumnVector outputField = this.fields[tag];
            outputField.isNull[outputElementNum] = false;
            outputField.setElement(outputElementNum, inputElementNum, inputField);
        } else {
            this.isNull[outputElementNum] = true;
            this.noNulls = false;
        }
    }

    @Override
    public void stringifyValue(StringBuilder buffer, int row) {
        if (this.isRepeating) {
            row = 0;
        }
        if (this.noNulls || !this.isNull[row]) {
            buffer.append("{\"tag\": ");
            buffer.append(this.tags[row]);
            buffer.append(", \"value\": ");
            this.fields[this.tags[row]].stringifyValue(buffer, row);
            buffer.append('}');
        } else {
            buffer.append("null");
        }
    }

    @Override
    public void ensureSize(int size, boolean preserveData) {
        super.ensureSize(size, preserveData);
        if (this.tags.length < size) {
            if (preserveData) {
                int[] oldTags = this.tags;
                this.tags = new int[size];
                System.arraycopy(oldTags, 0, this.tags, 0, oldTags.length);
            } else {
                this.tags = new int[size];
            }
            for (int i = 0; i < this.fields.length; ++i) {
                this.fields[i].ensureSize(size, preserveData);
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].reset();
        }
    }

    @Override
    public void init() {
        super.init();
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].init();
        }
    }

    @Override
    public void unFlatten() {
        super.unFlatten();
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].unFlatten();
        }
    }

    @Override
    public void setRepeating(boolean isRepeating) {
        super.setRepeating(isRepeating);
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].setRepeating(isRepeating);
        }
    }

    @Override
    public void shallowCopyTo(ColumnVector otherCv) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void copySelected(boolean selectedInUse, int[] sel, int size, ColumnVector outputColVector) {
        throw new RuntimeException("Not supported");
    }
}

