/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.iceberg.BaseAllMetadataTableScan;
import org.apache.iceberg.BaseFileScanTask;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DataTask;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.GenericManifestFile;
import org.apache.iceberg.GenericPartitionFieldSummary;
import org.apache.iceberg.ManifestContent;
import org.apache.iceberg.ManifestFile;
import org.apache.iceberg.ManifestsTable;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.StaticDataTask;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.TableScanContext;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Binder;
import org.apache.iceberg.expressions.BoundReference;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.ExpressionVisitors;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructProjection;

public class AllManifestsTable
extends BaseMetadataTable {
    private static final int REF_SNAPSHOT_ID = 18;
    private static final Schema MANIFEST_FILE_SCHEMA = new Schema(Types.NestedField.required(14, "content", Types.IntegerType.get()), Types.NestedField.required(1, "path", Types.StringType.get()), Types.NestedField.required(2, "length", Types.LongType.get()), Types.NestedField.optional(3, "partition_spec_id", Types.IntegerType.get()), Types.NestedField.optional(4, "added_snapshot_id", Types.LongType.get()), Types.NestedField.optional(5, "added_data_files_count", Types.IntegerType.get()), Types.NestedField.optional(6, "existing_data_files_count", Types.IntegerType.get()), Types.NestedField.optional(7, "deleted_data_files_count", Types.IntegerType.get()), Types.NestedField.required(15, "added_delete_files_count", Types.IntegerType.get()), Types.NestedField.required(16, "existing_delete_files_count", Types.IntegerType.get()), Types.NestedField.required(17, "deleted_delete_files_count", Types.IntegerType.get()), Types.NestedField.optional(8, "partition_summaries", Types.ListType.ofRequired(9, Types.StructType.of(Types.NestedField.required(10, "contains_null", Types.BooleanType.get()), Types.NestedField.required(11, "contains_nan", Types.BooleanType.get()), Types.NestedField.optional(12, "lower_bound", Types.StringType.get()), Types.NestedField.optional(13, "upper_bound", Types.StringType.get())))), Types.NestedField.required(18, "reference_snapshot_id", Types.LongType.get()));

    AllManifestsTable(TableOperations ops, Table table) {
        this(ops, table, table.name() + ".all_manifests");
    }

    AllManifestsTable(TableOperations ops, Table table, String name) {
        super(ops, table, name);
    }

    @Override
    public TableScan newScan() {
        return new AllManifestsTableScan(this.operations(), this.table(), MANIFEST_FILE_SCHEMA);
    }

    @Override
    public Schema schema() {
        return MANIFEST_FILE_SCHEMA;
    }

    @Override
    MetadataTableType metadataTableType() {
        return MetadataTableType.ALL_MANIFESTS;
    }

    static StaticDataTask.Row manifestFileToRow(PartitionSpec spec, ManifestFile manifest, long referenceSnapshotId) {
        return StaticDataTask.Row.of(manifest.content().id(), manifest.path(), manifest.length(), manifest.partitionSpecId(), manifest.snapshotId(), manifest.content() == ManifestContent.DATA ? manifest.addedFilesCount() : 0, manifest.content() == ManifestContent.DATA ? manifest.existingFilesCount() : 0, manifest.content() == ManifestContent.DATA ? manifest.deletedFilesCount() : 0, manifest.content() == ManifestContent.DELETES ? manifest.addedFilesCount() : 0, manifest.content() == ManifestContent.DELETES ? manifest.existingFilesCount() : 0, manifest.content() == ManifestContent.DELETES ? manifest.deletedFilesCount() : 0, ManifestsTable.partitionSummariesToRows(spec, manifest.partitions()), referenceSnapshotId);
    }

    private static class SnapshotEvaluator {
        private final Expression boundExpr;

        private SnapshotEvaluator(Expression expr, Types.StructType structType, boolean caseSensitive) {
            this.boundExpr = Binder.bind(structType, expr, caseSensitive);
        }

        private boolean eval(Snapshot snapshot) {
            return new SnapshotEvalVisitor().eval(snapshot);
        }

        private class SnapshotEvalVisitor
        extends ExpressionVisitors.BoundExpressionVisitor<Boolean> {
            private long snapshotId;
            private static final boolean ROWS_MIGHT_MATCH = true;
            private static final boolean ROWS_CANNOT_MATCH = false;

            private SnapshotEvalVisitor() {
            }

            private boolean eval(Snapshot snapshot) {
                this.snapshotId = snapshot.snapshotId();
                return ExpressionVisitors.visitEvaluator(SnapshotEvaluator.this.boundExpr, this);
            }

            @Override
            public Boolean alwaysTrue() {
                return true;
            }

            @Override
            public Boolean alwaysFalse() {
                return false;
            }

            @Override
            public Boolean not(Boolean result) {
                return result == false;
            }

            @Override
            public Boolean and(Boolean leftResult, Boolean rightResult) {
                return leftResult != false && rightResult != false;
            }

            @Override
            public Boolean or(Boolean leftResult, Boolean rightResult) {
                return leftResult != false || rightResult != false;
            }

            @Override
            public <T> Boolean isNull(BoundReference<T> ref) {
                if (this.isSnapshotRef(ref)) {
                    return false;
                }
                return true;
            }

            @Override
            public <T> Boolean notNull(BoundReference<T> ref) {
                return true;
            }

            @Override
            public <T> Boolean isNaN(BoundReference<T> ref) {
                if (this.isSnapshotRef(ref)) {
                    return false;
                }
                return true;
            }

            @Override
            public <T> Boolean notNaN(BoundReference<T> ref) {
                return true;
            }

            @Override
            public <T> Boolean lt(BoundReference<T> ref, Literal<T> lit) {
                return this.compareSnapshotRef(ref, lit, compareResult -> compareResult < 0);
            }

            @Override
            public <T> Boolean ltEq(BoundReference<T> ref, Literal<T> lit) {
                return this.compareSnapshotRef(ref, lit, compareResult -> compareResult <= 0);
            }

            @Override
            public <T> Boolean gt(BoundReference<T> ref, Literal<T> lit) {
                return this.compareSnapshotRef(ref, lit, compareResult -> compareResult > 0);
            }

            @Override
            public <T> Boolean gtEq(BoundReference<T> ref, Literal<T> lit) {
                return this.compareSnapshotRef(ref, lit, compareResult -> compareResult >= 0);
            }

            @Override
            public <T> Boolean eq(BoundReference<T> ref, Literal<T> lit) {
                return this.compareSnapshotRef(ref, lit, compareResult -> compareResult == 0);
            }

            @Override
            public <T> Boolean notEq(BoundReference<T> ref, Literal<T> lit) {
                return this.compareSnapshotRef(ref, lit, compareResult -> compareResult != 0);
            }

            @Override
            public <T> Boolean in(BoundReference<T> ref, Set<T> literalSet) {
                if (this.isSnapshotRef(ref) && !literalSet.contains(this.snapshotId)) {
                    return false;
                }
                return true;
            }

            @Override
            public <T> Boolean notIn(BoundReference<T> ref, Set<T> literalSet) {
                if (this.isSnapshotRef(ref) && literalSet.contains(this.snapshotId)) {
                    return false;
                }
                return true;
            }

            @Override
            public <T> Boolean startsWith(BoundReference<T> ref, Literal<T> lit) {
                return true;
            }

            @Override
            public <T> Boolean notStartsWith(BoundReference<T> ref, Literal<T> lit) {
                return true;
            }

            private <T> Boolean compareSnapshotRef(BoundReference<T> ref, Literal<T> lit, Function<Integer, Boolean> desiredResult) {
                Literal longLit;
                int cmp;
                if (this.isSnapshotRef(ref) && !desiredResult.apply(cmp = (longLit = lit.to(Types.LongType.get())).comparator().compare(this.snapshotId, (Long)longLit.value())).booleanValue()) {
                    return false;
                }
                return true;
            }

            private <T> boolean isSnapshotRef(BoundReference<T> ref) {
                return ref.fieldId() == 18;
            }
        }
    }

    static class ManifestListReadTask
    implements DataTask {
        private final FileIO io;
        private final Schema schema;
        private final Map<Integer, PartitionSpec> specs;
        private final FileScanTask manifestListTask;
        private final long referenceSnapshotId;

        ManifestListReadTask(FileIO io, Schema schema, Map<Integer, PartitionSpec> specs, FileScanTask manifestListTask, long referenceSnapshotId) {
            this.io = io;
            this.schema = schema;
            this.specs = specs;
            this.manifestListTask = manifestListTask;
            this.referenceSnapshotId = referenceSnapshotId;
        }

        @Override
        public List<DeleteFile> deletes() {
            return this.manifestListTask.deletes();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public CloseableIterable<StructLike> rows() {
            try (AvroIterable manifests = Avro.read(this.io.newInputFile(((DataFile)this.manifestListTask.file()).path().toString())).rename("manifest_file", GenericManifestFile.class.getName()).rename("partitions", GenericPartitionFieldSummary.class.getName()).rename("r508", GenericPartitionFieldSummary.class.getName()).project(ManifestFile.schema()).classLoader(GenericManifestFile.class.getClassLoader()).reuseContainers(false).build();){
                CloseableIterable<StructLike> rowIterable = CloseableIterable.transform(manifests, manifest -> AllManifestsTable.manifestFileToRow(this.specs.get(manifest.partitionSpecId()), manifest, this.referenceSnapshotId));
                StructProjection projection = StructProjection.create(MANIFEST_FILE_SCHEMA, this.schema);
                CloseableIterable<StructLike> closeableIterable = CloseableIterable.transform(rowIterable, projection::wrap);
                return closeableIterable;
            }
            catch (IOException e) {
                throw new RuntimeIOException(e, "Cannot read manifest list file: %s", ((DataFile)this.manifestListTask.file()).path());
            }
        }

        @Override
        public DataFile file() {
            return (DataFile)this.manifestListTask.file();
        }

        @Override
        public PartitionSpec spec() {
            return this.manifestListTask.spec();
        }

        @Override
        public long start() {
            return 0L;
        }

        @Override
        public long length() {
            return this.manifestListTask.length();
        }

        @Override
        public Expression residual() {
            return this.manifestListTask.residual();
        }

        @Override
        public Iterable<FileScanTask> split(long splitSize) {
            return ImmutableList.of(this);
        }
    }

    public static class AllManifestsTableScan
    extends BaseAllMetadataTableScan {
        AllManifestsTableScan(TableOperations ops, Table table, Schema fileSchema) {
            super(ops, table, fileSchema, MetadataTableType.ALL_MANIFESTS);
        }

        private AllManifestsTableScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            super(ops, table, schema, MetadataTableType.ALL_MANIFESTS, context);
        }

        @Override
        protected TableScan newRefinedScan(TableOperations ops, Table table, Schema schema, TableScanContext context) {
            return new AllManifestsTableScan(ops, table, schema, context);
        }

        @Override
        protected CloseableIterable<FileScanTask> doPlanFiles() {
            FileIO io = this.table().io();
            String schemaString = SchemaParser.toJson(this.schema());
            String specString = PartitionSpecParser.toJson(PartitionSpec.unpartitioned());
            HashMap<Integer, PartitionSpec> specs = Maps.newHashMap(this.table().specs());
            Expression filter = this.shouldIgnoreResiduals() ? Expressions.alwaysTrue() : this.filter();
            ResidualEvaluator residuals = ResidualEvaluator.unpartitioned(filter);
            SnapshotEvaluator snapshotEvaluator = new SnapshotEvaluator(filter, MANIFEST_FILE_SCHEMA.asStruct(), this.isCaseSensitive());
            Iterable<Snapshot> filteredSnapshots = Iterables.filter(this.table().snapshots(), x$0 -> snapshotEvaluator.eval(x$0));
            return CloseableIterable.withNoopClose(Iterables.transform(filteredSnapshots, snap -> {
                if (snap.manifestListLocation() != null) {
                    DataFile manifestListAsDataFile = DataFiles.builder(PartitionSpec.unpartitioned()).withInputFile(io.newInputFile(snap.manifestListLocation())).withRecordCount(1L).withFormat(FileFormat.AVRO).build();
                    return new ManifestListReadTask(io, this.schema(), specs, new BaseFileScanTask(manifestListAsDataFile, null, schemaString, specString, residuals), snap.snapshotId());
                }
                return StaticDataTask.of(io.newInputFile(this.tableOps().current().metadataFileLocation()), MANIFEST_FILE_SCHEMA, this.schema(), snap.allManifests(io), manifest -> AllManifestsTable.manifestFileToRow((PartitionSpec)specs.get(manifest.partitionSpecId()), manifest, snap.snapshotId()));
            }));
        }
    }
}

