/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.specific.SpecificData;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.ManifestEntry;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.V1Metadata;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.types.Types;

class GenericManifestEntry<F extends ContentFile<F>>
implements ManifestEntry<F>,
IndexedRecord,
SpecificData.SchemaConstructable,
StructLike {
    private final Schema schema;
    private ManifestEntry.Status status = ManifestEntry.Status.EXISTING;
    private Long snapshotId = null;
    private Long sequenceNumber = null;
    private F file = null;

    GenericManifestEntry(Schema schema) {
        this.schema = schema;
    }

    GenericManifestEntry(Types.StructType partitionType) {
        this.schema = AvroSchemaUtil.convert(V1Metadata.entrySchema(partitionType), "manifest_entry");
    }

    private GenericManifestEntry(GenericManifestEntry<F> toCopy, boolean fullCopy) {
        this.schema = toCopy.schema;
        this.status = toCopy.status;
        this.snapshotId = toCopy.snapshotId;
        this.sequenceNumber = toCopy.sequenceNumber;
        this.file = (ContentFile)toCopy.file().copy(fullCopy);
    }

    ManifestEntry<F> wrapExisting(Long newSnapshotId, Long newSequenceNumber, F newFile) {
        this.status = ManifestEntry.Status.EXISTING;
        this.snapshotId = newSnapshotId;
        this.sequenceNumber = newSequenceNumber;
        this.file = newFile;
        return this;
    }

    ManifestEntry<F> wrapAppend(Long newSnapshotId, F newFile) {
        return this.wrapAppend(newSnapshotId, null, newFile);
    }

    ManifestEntry<F> wrapAppend(Long newSnapshotId, Long newSequenceNumber, F newFile) {
        this.status = ManifestEntry.Status.ADDED;
        this.snapshotId = newSnapshotId;
        this.sequenceNumber = newSequenceNumber;
        this.file = newFile;
        return this;
    }

    ManifestEntry<F> wrapDelete(Long newSnapshotId, F newFile) {
        this.status = ManifestEntry.Status.DELETED;
        this.snapshotId = newSnapshotId;
        this.sequenceNumber = null;
        this.file = newFile;
        return this;
    }

    @Override
    public ManifestEntry.Status status() {
        return this.status;
    }

    @Override
    public Long snapshotId() {
        return this.snapshotId;
    }

    @Override
    public Long sequenceNumber() {
        return this.sequenceNumber;
    }

    @Override
    public F file() {
        return this.file;
    }

    @Override
    public ManifestEntry<F> copy() {
        return new GenericManifestEntry<F>(this, true);
    }

    @Override
    public ManifestEntry<F> copyWithoutStats() {
        return new GenericManifestEntry<F>(this, false);
    }

    @Override
    public void setSnapshotId(long newSnapshotId) {
        this.snapshotId = newSnapshotId;
    }

    @Override
    public void setSequenceNumber(long newSequenceNumber) {
        this.sequenceNumber = newSequenceNumber;
    }

    @Override
    public void put(int i, Object v) {
        switch (i) {
            case 0: {
                this.status = ManifestEntry.Status.values()[(Integer)v];
                return;
            }
            case 1: {
                this.snapshotId = (Long)v;
                return;
            }
            case 2: {
                this.sequenceNumber = (Long)v;
                return;
            }
            case 3: {
                this.file = (ContentFile)v;
                return;
            }
        }
    }

    @Override
    public <T> void set(int pos, T value) {
        this.put(pos, value);
    }

    @Override
    public Object get(int i) {
        switch (i) {
            case 0: {
                return this.status.id();
            }
            case 1: {
                return this.snapshotId;
            }
            case 2: {
                return this.sequenceNumber;
            }
            case 3: {
                return this.file;
            }
        }
        throw new UnsupportedOperationException("Unknown field ordinal: " + i);
    }

    @Override
    public <T> T get(int pos, Class<T> javaClass) {
        return javaClass.cast(this.get(pos));
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public int size() {
        return 4;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("status", (Object)this.status).add("snapshot_id", this.snapshotId).add("sequence_number", this.sequenceNumber).add("file", this.file).toString();
    }
}

