/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.util.Locale;
import org.apache.iceberg.SnapshotRef;
import org.apache.iceberg.SnapshotRefType;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.util.JsonUtil;

public class SnapshotRefParser {
    private static final String SNAPSHOT_ID = "snapshot-id";
    private static final String TYPE = "type";
    private static final String MIN_SNAPSHOTS_TO_KEEP = "min-snapshots-to-keep";
    private static final String MAX_SNAPSHOT_AGE_MS = "max-snapshot-age-ms";
    private static final String MAX_REF_AGE_MS = "max-ref-age-ms";

    private SnapshotRefParser() {
    }

    public static String toJson(SnapshotRef ref) {
        return SnapshotRefParser.toJson(ref, false);
    }

    public static String toJson(SnapshotRef ref, boolean pretty) {
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator generator = JsonUtil.factory().createGenerator(writer);
            if (pretty) {
                generator.useDefaultPrettyPrinter();
            }
            SnapshotRefParser.toJson(ref, generator);
            generator.flush();
            return writer.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void toJson(SnapshotRef ref, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeNumberField(SNAPSHOT_ID, ref.snapshotId());
        generator.writeStringField(TYPE, ref.type().name().toLowerCase(Locale.ENGLISH));
        JsonUtil.writeIntegerFieldIf(ref.minSnapshotsToKeep() != null, MIN_SNAPSHOTS_TO_KEEP, ref.minSnapshotsToKeep(), generator);
        JsonUtil.writeLongFieldIf(ref.maxSnapshotAgeMs() != null, MAX_SNAPSHOT_AGE_MS, ref.maxSnapshotAgeMs(), generator);
        JsonUtil.writeLongFieldIf(ref.maxRefAgeMs() != null, MAX_REF_AGE_MS, ref.maxRefAgeMs(), generator);
        generator.writeEndObject();
    }

    public static SnapshotRef fromJson(String json) {
        Preconditions.checkArgument(json != null && !json.isEmpty(), "Cannot parse snapshot ref from invalid JSON: %s", (Object)json);
        try {
            return SnapshotRefParser.fromJson(JsonUtil.mapper().readValue(json, JsonNode.class));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to parse snapshot ref: " + json, e);
        }
    }

    public static SnapshotRef fromJson(JsonNode node) {
        Preconditions.checkArgument(node.isObject(), "Cannot parse snapshot reference from a non-object: %s", (Object)node);
        long snapshotId = JsonUtil.getLong(SNAPSHOT_ID, node);
        SnapshotRefType type = SnapshotRefType.valueOf(JsonUtil.getString(TYPE, node).toUpperCase(Locale.ENGLISH));
        Integer minSnapshotsToKeep = JsonUtil.getIntOrNull(MIN_SNAPSHOTS_TO_KEEP, node);
        Long maxSnapshotAgeMs = JsonUtil.getLongOrNull(MAX_SNAPSHOT_AGE_MS, node);
        Long maxRefAgeMs = JsonUtil.getLongOrNull(MAX_REF_AGE_MS, node);
        return SnapshotRef.builderFor(snapshotId, type).minSnapshotsToKeep(minSnapshotsToKeep).maxSnapshotAgeMs(maxSnapshotAgeMs).maxRefAgeMs(maxRefAgeMs).build();
    }
}

