/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.Closeable;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.GenericDeleteFilter;
import org.apache.iceberg.data.IdentityPartitionConverters;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableGroup;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.util.PartitionUtil;

class GenericReader
implements Serializable {
    private final FileIO io;
    private final Schema tableSchema;
    private final Schema projection;
    private final boolean caseSensitive;
    private final boolean reuseContainers;

    GenericReader(TableScan scan, boolean reuseContainers) {
        this.io = scan.table().io();
        this.tableSchema = scan.table().schema();
        this.projection = scan.schema();
        this.caseSensitive = scan.isCaseSensitive();
        this.reuseContainers = reuseContainers;
    }

    CloseableIterator<Record> open(CloseableIterable<CombinedScanTask> tasks) {
        Iterable fileTasks = Iterables.concat(Iterables.transform(tasks, CombinedScanTask::files));
        return CloseableIterable.concat(Iterables.transform(fileTasks, this::open)).iterator();
    }

    public CloseableIterable<Record> open(CombinedScanTask task) {
        return new CombinedTaskIterable(task);
    }

    public CloseableIterable<Record> open(FileScanTask task) {
        GenericDeleteFilter deletes = new GenericDeleteFilter(this.io, task, this.tableSchema, this.projection);
        Schema readSchema = deletes.requiredSchema();
        CloseableIterable<Record> records = this.openFile(task, readSchema);
        records = deletes.filter(records);
        records = this.applyResidual(records, readSchema, task.residual());
        return records;
    }

    private CloseableIterable<Record> applyResidual(CloseableIterable<Record> records, Schema recordSchema, Expression residual) {
        if (residual != null && residual != Expressions.alwaysTrue()) {
            InternalRecordWrapper wrapper = new InternalRecordWrapper(recordSchema.asStruct());
            Evaluator filter = new Evaluator(recordSchema.asStruct(), residual, this.caseSensitive);
            return CloseableIterable.filter(records, record -> filter.eval(wrapper.wrap((StructLike)record)));
        }
        return records;
    }

    private CloseableIterable<Record> openFile(FileScanTask task, Schema fileProjection) {
        InputFile input = this.io.newInputFile(((DataFile)task.file()).path().toString());
        Map<Integer, ?> partition = PartitionUtil.constantsMap(task, IdentityPartitionConverters::convertConstant);
        switch (((DataFile)task.file()).format()) {
            case AVRO: {
                Avro.ReadBuilder avro = Avro.read(input).project(fileProjection).createReaderFunc(avroSchema -> DataReader.create(fileProjection, avroSchema, partition)).split(task.start(), task.length());
                if (this.reuseContainers) {
                    avro.reuseContainers();
                }
                return avro.build();
            }
            case PARQUET: {
                Parquet.ReadBuilder parquet = Parquet.read(input).project(fileProjection).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader(fileProjection, fileSchema, partition)).split(task.start(), task.length()).filter(task.residual());
                if (this.reuseContainers) {
                    parquet.reuseContainers();
                }
                return parquet.build();
            }
            case ORC: {
                Schema projectionWithoutConstantAndMetadataFields = TypeUtil.selectNot(fileProjection, Sets.union(partition.keySet(), MetadataColumns.metadataFieldIds()));
                ORC.ReadBuilder orc = ORC.read(input).project(projectionWithoutConstantAndMetadataFields).createReaderFunc(fileSchema -> GenericOrcReader.buildReader(fileProjection, fileSchema, partition)).split(task.start(), task.length()).filter(task.residual());
                return orc.build();
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot read %s file: %s", ((DataFile)task.file()).format().name(), ((DataFile)task.file()).path()));
    }

    private class CombinedTaskIterable
    extends CloseableGroup
    implements CloseableIterable<Record> {
        private final CombinedScanTask task;

        private CombinedTaskIterable(CombinedScanTask task) {
            this.task = task;
        }

        @Override
        public CloseableIterator<Record> iterator() {
            Iterator iter = CloseableIterable.concat(Iterables.transform(this.task.files(), GenericReader.this::open)).iterator();
            this.addCloseable((Closeable)((Object)iter));
            return iter;
        }
    }
}

