/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.iceberg.CatalogProperties;
import org.apache.iceberg.ClientPool;
import org.apache.iceberg.hive.HiveClientPool;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.thrift.TException;

public class CachedClientPool
implements ClientPool<IMetaStoreClient, TException> {
    private static Cache<String, HiveClientPool> clientPoolCache;
    private final Configuration conf;
    private final String metastoreUri;
    private final int clientPoolSize;
    private final long evictionInterval;

    CachedClientPool(Configuration conf, Map<String, String> properties) {
        this.conf = conf;
        this.metastoreUri = conf.get(HiveConf.ConfVars.METASTOREURIS.varname, "");
        this.clientPoolSize = PropertyUtil.propertyAsInt(properties, "clients", 2);
        this.evictionInterval = PropertyUtil.propertyAsLong(properties, "client.pool.cache.eviction-interval-ms", CatalogProperties.CLIENT_POOL_CACHE_EVICTION_INTERVAL_MS_DEFAULT);
        this.init();
    }

    @VisibleForTesting
    HiveClientPool clientPool() {
        return clientPoolCache.get(this.metastoreUri, k -> new HiveClientPool(this.clientPoolSize, this.conf));
    }

    private synchronized void init() {
        if (clientPoolCache == null) {
            clientPoolCache = Caffeine.newBuilder().expireAfterAccess(this.evictionInterval, TimeUnit.MILLISECONDS).removalListener((key, value, cause) -> ((HiveClientPool)value).close()).build();
        }
    }

    @VisibleForTesting
    static Cache<String, HiveClientPool> clientPoolCache() {
        return clientPoolCache;
    }

    @Override
    public <R> R run(ClientPool.Action<R, IMetaStoreClient, TException> action) throws TException, InterruptedException {
        return this.clientPool().run(action);
    }

    @Override
    public <R> R run(ClientPool.Action<R, IMetaStoreClient, TException> action, boolean retry) throws TException, InterruptedException {
        return this.clientPool().run(action, retry);
    }
}

