/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import java.io.Serializable;
import java.util.Map;
import java.util.Optional;

public interface MetricsContext
extends Serializable {
    default public void initialize(Map<String, String> properties) {
    }

    default public <T extends Number> Counter<T> counter(String name, Class<T> type, Unit unit) {
        throw new UnsupportedOperationException("Counter is not supported.");
    }

    public static MetricsContext nullMetrics() {
        return new MetricsContext(){

            @Override
            public <T extends Number> Counter<T> counter(String name, Class<T> type, Unit unit) {
                return new Counter<T>(){

                    @Override
                    public void increment() {
                    }

                    @Override
                    public void increment(T amount) {
                    }
                };
            }
        };
    }

    public static interface Counter<T extends Number> {
        public void increment();

        public void increment(T var1);

        default public Optional<T> count() {
            return Optional.empty();
        }

        default public Unit unit() {
            return Unit.UNDEFINED;
        }
    }

    public static enum Unit {
        UNDEFINED("undefined"),
        BYTES("bytes"),
        COUNT("count");

        private final String displayName;

        private Unit(String displayName) {
            this.displayName = displayName;
        }

        public String displayName() {
            return this.displayName;
        }
    }
}

