/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.FieldMetrics;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.MetricsModes;
import org.apache.iceberg.MetricsUtil;
import org.apache.iceberg.Schema;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.orc.ORCSchemaUtil;
import org.apache.iceberg.orc.OrcSchemaVisitor;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.iceberg.util.UnicodeUtil;
import org.apache.orc.BooleanColumnStatistics;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.DateColumnStatistics;
import org.apache.orc.DecimalColumnStatistics;
import org.apache.orc.DoubleColumnStatistics;
import org.apache.orc.IntegerColumnStatistics;
import org.apache.orc.Reader;
import org.apache.orc.StringColumnStatistics;
import org.apache.orc.TimestampColumnStatistics;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;

public class OrcMetrics {
    private OrcMetrics() {
    }

    public static Metrics fromInputFile(InputFile file) {
        return OrcMetrics.fromInputFile(file, MetricsConfig.getDefault());
    }

    public static Metrics fromInputFile(InputFile file, MetricsConfig metricsConfig) {
        return OrcMetrics.fromInputFile(file, metricsConfig, null);
    }

    public static Metrics fromInputFile(InputFile file, MetricsConfig metricsConfig, NameMapping mapping) {
        Configuration config = file instanceof HadoopInputFile ? ((HadoopInputFile)file).getConf() : new Configuration();
        return OrcMetrics.fromInputFile(file, config, metricsConfig, mapping);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Metrics fromInputFile(InputFile file, Configuration config, MetricsConfig metricsConfig, NameMapping mapping) {
        try (Reader orcReader = ORC.newFileReader(file, config);){
            Metrics metrics = OrcMetrics.buildOrcMetrics(orcReader.getNumberOfRows(), orcReader.getSchema(), orcReader.getStatistics(), Stream.empty(), metricsConfig, mapping);
            return metrics;
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe, "Failed to open file: %s", file.location());
        }
    }

    static Metrics fromWriter(Writer writer, Stream<FieldMetrics<?>> fieldMetricsStream, MetricsConfig metricsConfig) {
        try {
            return OrcMetrics.buildOrcMetrics(writer.getNumberOfRows(), writer.getSchema(), writer.getStatistics(), fieldMetricsStream, metricsConfig, null);
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe, "Failed to get statistics from writer", new Object[0]);
        }
    }

    private static Metrics buildOrcMetrics(long numOfRows, TypeDescription orcSchema, ColumnStatistics[] colStats, Stream<FieldMetrics<?>> fieldMetricsStream, MetricsConfig metricsConfig, NameMapping mapping) {
        TypeDescription orcSchemaWithIds = !ORCSchemaUtil.hasIds(orcSchema) && mapping != null ? ORCSchemaUtil.applyNameMapping(orcSchema, mapping) : orcSchema;
        Set<Integer> statsColumns = OrcMetrics.statsColumns(orcSchemaWithIds);
        MetricsConfig effectiveMetricsConfig = Optional.ofNullable(metricsConfig).orElseGet(MetricsConfig::getDefault);
        HashMap<Integer, Long> columnSizes = Maps.newHashMapWithExpectedSize(colStats.length);
        HashMap<Integer, Long> valueCounts = Maps.newHashMapWithExpectedSize(colStats.length);
        HashMap<Integer, Long> nullCounts = Maps.newHashMapWithExpectedSize(colStats.length);
        if (!ORCSchemaUtil.hasIds(orcSchemaWithIds)) {
            return new Metrics(numOfRows, columnSizes, valueCounts, nullCounts, null, null, null);
        }
        Schema schema = ORCSchemaUtil.convert(orcSchemaWithIds);
        HashMap<Integer, ByteBuffer> lowerBounds = Maps.newHashMap();
        HashMap<Integer, ByteBuffer> upperBounds = Maps.newHashMap();
        Map fieldMetricsMap = Optional.ofNullable(fieldMetricsStream).map(stream -> stream.collect(Collectors.toMap(FieldMetrics::id, Function.identity()))).orElseGet(Maps::newHashMap);
        for (int i = 0; i < colStats.length; ++i) {
            ColumnStatistics colStat = colStats[i];
            TypeDescription orcCol = orcSchemaWithIds.findSubtype(i);
            Optional<Types.NestedField> icebergColOpt = ORCSchemaUtil.icebergID(orcCol).map(schema::findField);
            if (!icebergColOpt.isPresent()) continue;
            Types.NestedField icebergCol = icebergColOpt.get();
            int fieldId = icebergCol.fieldId();
            MetricsModes.MetricsMode metricsMode = MetricsUtil.metricsMode(schema, effectiveMetricsConfig, icebergCol.fieldId());
            columnSizes.put(fieldId, colStat.getBytesOnDisk());
            if (metricsMode == MetricsModes.None.get() || !statsColumns.contains(fieldId)) continue;
            if (colStat.hasNull()) {
                nullCounts.put(fieldId, numOfRows - colStat.getNumberOfValues());
            } else {
                nullCounts.put(fieldId, 0L);
            }
            valueCounts.put(fieldId, colStat.getNumberOfValues() + (Long)nullCounts.get(fieldId));
            if (metricsMode == MetricsModes.Counts.get()) continue;
            Optional<ByteBuffer> orcMin = colStat.getNumberOfValues() > 0L ? OrcMetrics.fromOrcMin(icebergCol.type(), colStat, metricsMode, (FieldMetrics)fieldMetricsMap.get(fieldId)) : Optional.empty();
            orcMin.ifPresent(byteBuffer -> lowerBounds.put(icebergCol.fieldId(), (ByteBuffer)byteBuffer));
            Optional<ByteBuffer> orcMax = colStat.getNumberOfValues() > 0L ? OrcMetrics.fromOrcMax(icebergCol.type(), colStat, metricsMode, (FieldMetrics)fieldMetricsMap.get(fieldId)) : Optional.empty();
            orcMax.ifPresent(byteBuffer -> upperBounds.put(icebergCol.fieldId(), (ByteBuffer)byteBuffer));
        }
        return new Metrics(numOfRows, columnSizes, valueCounts, nullCounts, MetricsUtil.createNanValueCounts(fieldMetricsMap.values().stream(), effectiveMetricsConfig, schema), lowerBounds, upperBounds);
    }

    private static Optional<ByteBuffer> fromOrcMin(Type type, ColumnStatistics columnStats, MetricsModes.MetricsMode metricsMode, FieldMetrics<?> fieldMetrics) {
        Object min2 = null;
        if (columnStats instanceof IntegerColumnStatistics) {
            min2 = ((IntegerColumnStatistics)columnStats).getMinimum();
            if (type.typeId() == Type.TypeID.INTEGER) {
                min2 = Math.toIntExact((Long)min2);
            }
        } else if (columnStats instanceof DoubleColumnStatistics) {
            if (fieldMetrics != null) {
                min2 = fieldMetrics.lowerBound();
            } else {
                min2 = OrcMetrics.replaceNaN(((DoubleColumnStatistics)columnStats).getMinimum(), Double.NEGATIVE_INFINITY);
                if (type.typeId() == Type.TypeID.FLOAT) {
                    min2 = Float.valueOf(((Double)min2).floatValue());
                }
            }
        } else if (columnStats instanceof StringColumnStatistics) {
            min2 = ((StringColumnStatistics)columnStats).getMinimum();
        } else if (columnStats instanceof DecimalColumnStatistics) {
            min2 = Optional.ofNullable(((DecimalColumnStatistics)columnStats).getMinimum()).map(minStats -> minStats.bigDecimalValue().setScale(((Types.DecimalType)type).scale())).orElse(null);
        } else if (columnStats instanceof DateColumnStatistics) {
            min2 = (int)((DateColumnStatistics)columnStats).getMinimumDayOfEpoch();
        } else if (columnStats instanceof TimestampColumnStatistics) {
            TimestampColumnStatistics tColStats = (TimestampColumnStatistics)columnStats;
            Timestamp minValue = tColStats.getMinimumUTC();
            min2 = Optional.ofNullable(minValue).map(v -> DateTimeUtil.microsFromInstant(v.toInstant())).orElse(null);
        } else if (columnStats instanceof BooleanColumnStatistics) {
            BooleanColumnStatistics booleanStats = (BooleanColumnStatistics)columnStats;
            min2 = booleanStats.getFalseCount() <= 0L;
        }
        return Optional.ofNullable(Conversions.toByteBuffer(type, OrcMetrics.truncateIfNeeded(Bound.LOWER, type, min2, metricsMode)));
    }

    private static Optional<ByteBuffer> fromOrcMax(Type type, ColumnStatistics columnStats, MetricsModes.MetricsMode metricsMode, FieldMetrics<?> fieldMetrics) {
        Object max = null;
        if (columnStats instanceof IntegerColumnStatistics) {
            max = ((IntegerColumnStatistics)columnStats).getMaximum();
            if (type.typeId() == Type.TypeID.INTEGER) {
                max = Math.toIntExact((Long)max);
            }
        } else if (columnStats instanceof DoubleColumnStatistics) {
            if (fieldMetrics != null) {
                max = fieldMetrics.upperBound();
            } else {
                max = OrcMetrics.replaceNaN(((DoubleColumnStatistics)columnStats).getMaximum(), Double.POSITIVE_INFINITY);
                if (type.typeId() == Type.TypeID.FLOAT) {
                    max = Float.valueOf(((Double)max).floatValue());
                }
            }
        } else if (columnStats instanceof StringColumnStatistics) {
            max = ((StringColumnStatistics)columnStats).getMaximum();
        } else if (columnStats instanceof DecimalColumnStatistics) {
            max = Optional.ofNullable(((DecimalColumnStatistics)columnStats).getMaximum()).map(maxStats -> maxStats.bigDecimalValue().setScale(((Types.DecimalType)type).scale())).orElse(null);
        } else if (columnStats instanceof DateColumnStatistics) {
            max = (int)((DateColumnStatistics)columnStats).getMaximumDayOfEpoch();
        } else if (columnStats instanceof TimestampColumnStatistics) {
            TimestampColumnStatistics tColStats = (TimestampColumnStatistics)columnStats;
            Timestamp maxValue = tColStats.getMaximumUTC();
            max = Optional.ofNullable(maxValue).map(v -> DateTimeUtil.microsFromInstant(v.toInstant())).orElse(null);
        } else if (columnStats instanceof BooleanColumnStatistics) {
            BooleanColumnStatistics booleanStats = (BooleanColumnStatistics)columnStats;
            max = booleanStats.getTrueCount() > 0L;
        }
        return Optional.ofNullable(Conversions.toByteBuffer(type, OrcMetrics.truncateIfNeeded(Bound.UPPER, type, max, metricsMode)));
    }

    private static Object replaceNaN(double value, double replacement) {
        return Double.isNaN(value) ? replacement : value;
    }

    private static Object truncateIfNeeded(Bound bound, Type type, Object value, MetricsModes.MetricsMode metricsMode) {
        if (!(metricsMode instanceof MetricsModes.Truncate) || type.typeId() != Type.TypeID.STRING || value == null) {
            return value;
        }
        CharSequence charSequence = (CharSequence)value;
        MetricsModes.Truncate truncateMode = (MetricsModes.Truncate)metricsMode;
        int truncateLength = truncateMode.length();
        switch (bound) {
            case UPPER: {
                return Optional.ofNullable(UnicodeUtil.truncateStringMax(Literal.of(charSequence), truncateLength)).map(Literal::value).orElse(charSequence);
            }
            case LOWER: {
                return UnicodeUtil.truncateStringMin(Literal.of(charSequence), truncateLength).value();
            }
        }
        throw new RuntimeException("No other bound is defined.");
    }

    private static Set<Integer> statsColumns(TypeDescription schema) {
        return OrcSchemaVisitor.visit(schema, new StatsColumnsVisitor());
    }

    private static class StatsColumnsVisitor
    extends OrcSchemaVisitor<Set<Integer>> {
        private StatsColumnsVisitor() {
        }

        @Override
        public Set<Integer> record(TypeDescription record, List<String> names, List<Set<Integer>> fields) {
            ImmutableSet.Builder result = ImmutableSet.builder();
            fields.stream().filter(Objects::nonNull).forEach(result::addAll);
            record.getChildren().stream().map(ORCSchemaUtil::icebergID).filter(Optional::isPresent).map(Optional::get).forEach(result::add);
            return result.build();
        }
    }

    private static enum Bound {
        LOWER,
        UPPER;

    }
}

