/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.orc.TypeDescription;

public abstract class OrcSchemaVisitor<T> {
    private final Deque<String> fieldNames = Lists.newLinkedList();

    public static <T> List<T> visitSchema(TypeDescription schema, OrcSchemaVisitor<T> visitor) {
        Preconditions.checkArgument(schema.getId() == 0, "TypeDescription must be root schema.");
        List<TypeDescription> fields = schema.getChildren();
        List<String> names = schema.getFieldNames();
        return OrcSchemaVisitor.visitFields(fields, names, visitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T visit(TypeDescription schema, OrcSchemaVisitor<T> visitor) {
        switch (schema.getCategory()) {
            case STRUCT: {
                return OrcSchemaVisitor.visitRecord(schema, visitor);
            }
            case UNION: {
                throw new UnsupportedOperationException("Cannot handle " + schema);
            }
            case LIST: {
                T elementResult;
                TypeDescription element = schema.getChildren().get(0);
                visitor.beforeElementField(element);
                try {
                    elementResult = OrcSchemaVisitor.visit(element, visitor);
                }
                finally {
                    visitor.afterElementField(element);
                }
                return visitor.list(schema, elementResult);
            }
            case MAP: {
                T valueResult;
                T keyResult;
                TypeDescription key = schema.getChildren().get(0);
                visitor.beforeKeyField(key);
                try {
                    keyResult = OrcSchemaVisitor.visit(key, visitor);
                }
                finally {
                    visitor.afterKeyField(key);
                }
                TypeDescription value = schema.getChildren().get(1);
                visitor.beforeValueField(value);
                try {
                    valueResult = OrcSchemaVisitor.visit(value, visitor);
                }
                finally {
                    visitor.afterValueField(value);
                }
                return visitor.map(schema, keyResult, valueResult);
            }
        }
        return visitor.primitive(schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> List<T> visitFields(List<TypeDescription> fields, List<String> names, OrcSchemaVisitor<T> visitor) {
        Preconditions.checkArgument(fields.size() == names.size(), "Not all fields have names in ORC struct");
        ArrayList<T> results = Lists.newArrayListWithExpectedSize(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            TypeDescription field = fields.get(i);
            String name = names.get(i);
            visitor.beforeField(name, field);
            try {
                results.add(OrcSchemaVisitor.visit(field, visitor));
                continue;
            }
            finally {
                visitor.afterField(name, field);
            }
        }
        return results;
    }

    private static <T> T visitRecord(TypeDescription record, OrcSchemaVisitor<T> visitor) {
        List<TypeDescription> fields = record.getChildren();
        List<String> names = record.getFieldNames();
        return visitor.record(record, names, OrcSchemaVisitor.visitFields(fields, names, visitor));
    }

    public String elementName() {
        return "_elem";
    }

    public String keyName() {
        return "_key";
    }

    public String valueName() {
        return "_value";
    }

    public String currentFieldName() {
        return this.fieldNames.peek();
    }

    public void beforeField(String name, TypeDescription type) {
        this.fieldNames.push(name);
    }

    public void afterField(String name, TypeDescription type) {
        this.fieldNames.pop();
    }

    public void beforeElementField(TypeDescription element) {
        this.beforeField(this.elementName(), element);
    }

    public void afterElementField(TypeDescription element) {
        this.afterField(this.elementName(), element);
    }

    public void beforeKeyField(TypeDescription key) {
        this.beforeField(this.keyName(), key);
    }

    public void afterKeyField(TypeDescription key) {
        this.afterField(this.keyName(), key);
    }

    public void beforeValueField(TypeDescription value) {
        this.beforeField(this.valueName(), value);
    }

    public void afterValueField(TypeDescription value) {
        this.afterField(this.valueName(), value);
    }

    public T record(TypeDescription record, List<String> names, List<T> fields) {
        return null;
    }

    public T list(TypeDescription array, T element) {
        return null;
    }

    public T map(TypeDescription map, T key, T value) {
        return null;
    }

    public T primitive(TypeDescription primitive) {
        return null;
    }

    protected String[] currentPath() {
        return Lists.newArrayList(this.fieldNames.descendingIterator()).toArray(new String[0]);
    }

    protected String[] path(String name) {
        ArrayList<String> list = Lists.newArrayList(this.fieldNames.descendingIterator());
        list.add(name);
        return list.toArray(new String[0]);
    }
}

