/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.Schema;
import org.apache.iceberg.common.DynConstructors;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.ParquetIO;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.parquet.ParquetUtil;
import org.apache.iceberg.parquet.ParquetValueWriter;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.column.ColumnWriteStore;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.page.PageWriteStore;
import org.apache.parquet.column.values.bloomfilter.BloomFilterWriteStore;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;

class ParquetWriter<T>
implements FileAppender<T>,
Closeable {
    private static final Metrics EMPTY_METRICS = new Metrics(0L, null, null, null, null);
    private static final DynConstructors.Ctor<PageWriteStore> pageStoreCtorParquet = DynConstructors.builder(PageWriteStore.class).hiddenImpl("org.apache.parquet.hadoop.ColumnChunkPageWriteStore", CodecFactory.BytesCompressor.class, MessageType.class, ByteBufferAllocator.class, Integer.TYPE).build();
    private static final DynMethods.UnboundMethod flushToWriter = DynMethods.builder("flushToFileWriter").hiddenImpl("org.apache.parquet.hadoop.ColumnChunkPageWriteStore", ParquetFileWriter.class).build();
    private final long targetRowGroupSize;
    private final Map<String, String> metadata;
    private final ParquetProperties props;
    private final CodecFactory.BytesCompressor compressor;
    private final MessageType parquetSchema;
    private final ParquetValueWriter<T> model;
    private final MetricsConfig metricsConfig;
    private final int columnIndexTruncateLength;
    private final ParquetFileWriter.Mode writeMode;
    private final OutputFile output;
    private final Configuration conf;
    private DynMethods.BoundMethod flushPageStoreToWriter;
    private ColumnWriteStore writeStore;
    private long recordCount = 0L;
    private long nextCheckRecordCount = 10L;
    private boolean closed;
    private ParquetFileWriter writer;
    private static final String COLUMN_INDEX_TRUNCATE_LENGTH = "parquet.columnindex.truncate.length";
    private static final int DEFAULT_COLUMN_INDEX_TRUNCATE_LENGTH = 64;

    ParquetWriter(Configuration conf, OutputFile output, Schema schema, long rowGroupSize, Map<String, String> metadata, Function<MessageType, ParquetValueWriter<?>> createWriterFunc, CompressionCodecName codec, ParquetProperties properties, MetricsConfig metricsConfig, ParquetFileWriter.Mode writeMode) {
        this.targetRowGroupSize = rowGroupSize;
        this.props = properties;
        this.metadata = ImmutableMap.copyOf(metadata);
        this.compressor = new CodecFactory(conf, this.props.getPageSizeThreshold()).getCompressor(codec);
        this.parquetSchema = ParquetSchemaUtil.convert(schema, "table");
        this.model = createWriterFunc.apply(this.parquetSchema);
        this.metricsConfig = metricsConfig;
        this.columnIndexTruncateLength = conf.getInt(COLUMN_INDEX_TRUNCATE_LENGTH, 64);
        this.writeMode = writeMode;
        this.output = output;
        this.conf = conf;
        this.startRowGroup();
    }

    private void ensureWriterInitialized() {
        if (this.writer == null) {
            try {
                this.writer = new ParquetFileWriter(ParquetIO.file(this.output, this.conf), this.parquetSchema, this.writeMode, this.targetRowGroupSize, 0);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to create Parquet file", e);
            }
            try {
                this.writer.start();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to start Parquet file writer", e);
            }
        }
    }

    @Override
    public void add(T value) {
        ++this.recordCount;
        this.model.write(0, value);
        this.writeStore.endRecord();
        this.checkSize();
    }

    @Override
    public Metrics metrics() {
        Preconditions.checkState(this.closed, "Cannot return metrics for unclosed writer");
        if (this.writer != null) {
            return ParquetUtil.footerMetrics(this.writer.getFooter(), this.model.metrics(), this.metricsConfig);
        }
        return EMPTY_METRICS;
    }

    @Override
    public long length() {
        try {
            long length = 0L;
            if (this.writer != null) {
                length += this.writer.getPos();
            }
            if (!this.closed && this.recordCount > 0L) {
                length += this.writeStore.getBufferedSize();
            }
            return length;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to get file length", e);
        }
    }

    @Override
    public List<Long> splitOffsets() {
        if (this.writer != null) {
            return ParquetUtil.getSplitOffsets(this.writer.getFooter());
        }
        return null;
    }

    private void checkSize() {
        if (this.recordCount >= this.nextCheckRecordCount) {
            double avgRecordSize;
            long bufferedSize = this.writeStore.getBufferedSize();
            if ((double)bufferedSize > (double)this.targetRowGroupSize - 2.0 * (avgRecordSize = (double)bufferedSize / (double)this.recordCount)) {
                this.flushRowGroup(false);
            } else {
                long remainingSpace = this.targetRowGroupSize - bufferedSize;
                long remainingRecords = (long)((double)remainingSpace / avgRecordSize);
                this.nextCheckRecordCount = this.recordCount + Math.min(Math.max(remainingRecords / 2L, (long)this.props.getMinRowCountForPageSizeCheck()), (long)this.props.getMaxRowCountForPageSizeCheck());
            }
        }
    }

    private void flushRowGroup(boolean finished) {
        try {
            if (this.recordCount > 0L) {
                this.ensureWriterInitialized();
                this.writer.startBlock(this.recordCount);
                this.writeStore.flush();
                this.flushPageStoreToWriter.invoke(this.writer);
                this.writer.endBlock();
                if (!finished) {
                    this.writeStore.close();
                    this.startRowGroup();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to flush row group", e);
        }
    }

    private void startRowGroup() {
        Preconditions.checkState(!this.closed, "Writer is closed");
        this.nextCheckRecordCount = Math.min(Math.max(this.recordCount / 2L, (long)this.props.getMinRowCountForPageSizeCheck()), (long)this.props.getMaxRowCountForPageSizeCheck());
        this.recordCount = 0L;
        PageWriteStore pageStore = pageStoreCtorParquet.newInstance(this.compressor, this.parquetSchema, this.props.getAllocator(), this.columnIndexTruncateLength);
        this.flushPageStoreToWriter = flushToWriter.bind(pageStore);
        this.writeStore = this.props.newColumnWriteStore(this.parquetSchema, pageStore, (BloomFilterWriteStore)((Object)pageStore));
        this.model.setColumnStore(this.writeStore);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.flushRowGroup(true);
            this.writeStore.close();
            if (this.writer != null) {
                this.writer.end(this.metadata);
            }
            if (this.compressor != null) {
                this.compressor.release();
            }
        }
    }
}

