/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.puffin;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.puffin.BlobMetadata;
import org.apache.iceberg.puffin.FileMetadata;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.util.JsonUtil;

public final class FileMetadataParser {
    private static final String BLOBS = "blobs";
    private static final String PROPERTIES = "properties";
    private static final String TYPE = "type";
    private static final String FIELDS = "fields";
    private static final String SNAPSHOT_ID = "snapshot-id";
    private static final String SEQUENCE_NUMBER = "sequence-number";
    private static final String OFFSET = "offset";
    private static final String LENGTH = "length";
    private static final String COMPRESSION_CODEC = "compression-codec";

    private FileMetadataParser() {
    }

    public static String toJson(FileMetadata fileMetadata, boolean pretty) {
        try {
            StringWriter writer = new StringWriter();
            JsonGenerator generator = JsonUtil.factory().createGenerator(writer);
            if (pretty) {
                generator.useDefaultPrettyPrinter();
            }
            FileMetadataParser.toJson(fileMetadata, generator);
            generator.flush();
            return writer.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to write json for: " + fileMetadata, e);
        }
    }

    public static FileMetadata fromJson(String json) {
        try {
            return FileMetadataParser.fromJson(JsonUtil.mapper().readValue(json, JsonNode.class));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static FileMetadata fromJson(JsonNode json) {
        return FileMetadataParser.fileMetadataFromJson(json);
    }

    static void toJson(FileMetadata fileMetadata, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeArrayFieldStart(BLOBS);
        for (BlobMetadata blobMetadata : fileMetadata.blobs()) {
            FileMetadataParser.toJson(blobMetadata, generator);
        }
        generator.writeEndArray();
        if (!fileMetadata.properties().isEmpty()) {
            generator.writeObjectFieldStart(PROPERTIES);
            for (Map.Entry entry : fileMetadata.properties().entrySet()) {
                generator.writeStringField((String)entry.getKey(), (String)entry.getValue());
            }
            generator.writeEndObject();
        }
        generator.writeEndObject();
    }

    static FileMetadata fileMetadataFromJson(JsonNode json) {
        ImmutableList.Builder blobs = ImmutableList.builder();
        JsonNode blobsJson = json.get(BLOBS);
        Preconditions.checkArgument(blobsJson != null && blobsJson.isArray(), "Cannot parse blobs from non-array: %s", (Object)blobsJson);
        for (JsonNode blobJson : blobsJson) {
            blobs.add(FileMetadataParser.blobMetadataFromJson(blobJson));
        }
        ImmutableMap<String, String> properties = ImmutableMap.of();
        JsonNode propertiesJson = json.get(PROPERTIES);
        if (propertiesJson != null) {
            properties = JsonUtil.getStringMap(PROPERTIES, json);
        }
        return new FileMetadata((List<BlobMetadata>)((Object)blobs.build()), properties);
    }

    static void toJson(BlobMetadata blobMetadata, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeStringField(TYPE, blobMetadata.type());
        generator.writeArrayFieldStart(FIELDS);
        Iterator<Object> iterator = blobMetadata.inputFields().iterator();
        while (iterator.hasNext()) {
            int n = iterator.next();
            generator.writeNumber(n);
        }
        generator.writeEndArray();
        generator.writeNumberField(SNAPSHOT_ID, blobMetadata.snapshotId());
        generator.writeNumberField(SEQUENCE_NUMBER, blobMetadata.sequenceNumber());
        generator.writeNumberField(OFFSET, blobMetadata.offset());
        generator.writeNumberField(LENGTH, blobMetadata.length());
        if (blobMetadata.compressionCodec() != null) {
            generator.writeStringField(COMPRESSION_CODEC, blobMetadata.compressionCodec());
        }
        if (!blobMetadata.properties().isEmpty()) {
            generator.writeObjectFieldStart(PROPERTIES);
            for (Map.Entry entry : blobMetadata.properties().entrySet()) {
                generator.writeStringField((String)entry.getKey(), (String)entry.getValue());
            }
            generator.writeEndObject();
        }
        generator.writeEndObject();
    }

    static BlobMetadata blobMetadataFromJson(JsonNode json) {
        String type = JsonUtil.getString(TYPE, json);
        List<Integer> fields = JsonUtil.getIntegerList(FIELDS, json);
        long snapshotId = JsonUtil.getLong(SNAPSHOT_ID, json);
        long sequenceNumber = JsonUtil.getLong(SEQUENCE_NUMBER, json);
        long offset = JsonUtil.getLong(OFFSET, json);
        long length = JsonUtil.getLong(LENGTH, json);
        String compressionCodec = JsonUtil.getStringOrNull(COMPRESSION_CODEC, json);
        ImmutableMap<String, String> properties = ImmutableMap.of();
        JsonNode propertiesJson = json.get(PROPERTIES);
        if (propertiesJson != null) {
            properties = JsonUtil.getStringMap(PROPERTIES, json);
        }
        return new BlobMetadata(type, fields, snapshotId, sequenceNumber, offset, length, compressionCodec, properties);
    }
}

