/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.apache.iceberg.MetadataUpdate;
import org.apache.iceberg.MetadataUpdateParser;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.SortOrderParser;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableMetadataParser;
import org.apache.iceberg.UnboundPartitionSpec;
import org.apache.iceberg.UnboundSortOrder;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.catalog.TableIdentifierParser;
import org.apache.iceberg.rest.auth.OAuth2Util;
import org.apache.iceberg.rest.requests.UpdateRequirementParser;
import org.apache.iceberg.rest.requests.UpdateTableRequest;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.rest.responses.ErrorResponseParser;
import org.apache.iceberg.rest.responses.OAuthTokenResponse;
import org.apache.iceberg.util.JsonUtil;

public class RESTSerializers {
    private RESTSerializers() {
    }

    public static void registerAll(ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.addSerializer(ErrorResponse.class, new ErrorResponseSerializer()).addDeserializer(ErrorResponse.class, new ErrorResponseDeserializer()).addSerializer(TableIdentifier.class, new TableIdentifierSerializer()).addDeserializer(TableIdentifier.class, new TableIdentifierDeserializer()).addSerializer(Namespace.class, new NamespaceSerializer()).addDeserializer(Namespace.class, new NamespaceDeserializer()).addSerializer(Schema.class, new SchemaSerializer()).addDeserializer(Schema.class, new SchemaDeserializer()).addSerializer(UnboundPartitionSpec.class, new UnboundPartitionSpecSerializer()).addDeserializer(UnboundPartitionSpec.class, new UnboundPartitionSpecDeserializer()).addSerializer(UnboundSortOrder.class, new UnboundSortOrderSerializer()).addDeserializer(UnboundSortOrder.class, new UnboundSortOrderDeserializer()).addSerializer(MetadataUpdate.class, new MetadataUpdateSerializer()).addDeserializer(MetadataUpdate.class, new MetadataUpdateDeserializer()).addSerializer(TableMetadata.class, new TableMetadataSerializer()).addDeserializer(TableMetadata.class, new TableMetadataDeserializer()).addSerializer(UpdateTableRequest.UpdateRequirement.class, new UpdateRequirementSerializer()).addDeserializer(UpdateTableRequest.UpdateRequirement.class, new UpdateRequirementDeserializer()).addSerializer(OAuthTokenResponse.class, new OAuthTokenResponseSerializer()).addDeserializer(OAuthTokenResponse.class, new OAuthTokenResponseDeserializer());
        mapper.registerModule(module);
    }

    public static class OAuthTokenResponseDeserializer
    extends JsonDeserializer<OAuthTokenResponse> {
        @Override
        public OAuthTokenResponse deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return OAuth2Util.tokenResponseFromJson(jsonNode);
        }
    }

    public static class OAuthTokenResponseSerializer
    extends JsonSerializer<OAuthTokenResponse> {
        @Override
        public void serialize(OAuthTokenResponse tokenResponse, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            OAuth2Util.tokenResponseToJson(tokenResponse, gen);
        }
    }

    public static class UnboundSortOrderDeserializer
    extends JsonDeserializer<UnboundSortOrder> {
        @Override
        public UnboundSortOrder deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return SortOrderParser.fromJson(jsonNode);
        }
    }

    public static class UnboundSortOrderSerializer
    extends JsonSerializer<UnboundSortOrder> {
        @Override
        public void serialize(UnboundSortOrder sortOrder, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            SortOrderParser.toJson(sortOrder, gen);
        }
    }

    public static class UnboundPartitionSpecDeserializer
    extends JsonDeserializer<UnboundPartitionSpec> {
        @Override
        public UnboundPartitionSpec deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return PartitionSpecParser.fromJson(jsonNode);
        }
    }

    public static class UnboundPartitionSpecSerializer
    extends JsonSerializer<UnboundPartitionSpec> {
        @Override
        public void serialize(UnboundPartitionSpec spec, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            PartitionSpecParser.toJson(spec, gen);
        }
    }

    public static class SchemaSerializer
    extends JsonSerializer<Schema> {
        @Override
        public void serialize(Schema schema, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            SchemaParser.toJson(schema, gen);
        }
    }

    public static class SchemaDeserializer
    extends JsonDeserializer<Schema> {
        @Override
        public Schema deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return SchemaParser.fromJson(jsonNode);
        }
    }

    public static class TableIdentifierSerializer
    extends JsonSerializer<TableIdentifier> {
        @Override
        public void serialize(TableIdentifier identifier, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            TableIdentifierParser.toJson(identifier, gen);
        }
    }

    public static class TableIdentifierDeserializer
    extends JsonDeserializer<TableIdentifier> {
        @Override
        public TableIdentifier deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
            return TableIdentifierParser.fromJson(jsonNode);
        }
    }

    public static class NamespaceSerializer
    extends JsonSerializer<Namespace> {
        @Override
        public void serialize(Namespace namespace, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            String[] parts = namespace.levels();
            gen.writeArray(parts, 0, parts.length);
        }
    }

    public static class NamespaceDeserializer
    extends JsonDeserializer<Namespace> {
        @Override
        public Namespace deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String[] levels = JsonUtil.getStringArray((JsonNode)p.getCodec().readTree(p));
            return Namespace.of(levels);
        }
    }

    public static class ErrorResponseSerializer
    extends JsonSerializer<ErrorResponse> {
        @Override
        public void serialize(ErrorResponse errorResponse, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            ErrorResponseParser.toJson(errorResponse, gen);
        }
    }

    public static class ErrorResponseDeserializer
    extends JsonDeserializer<ErrorResponse> {
        @Override
        public ErrorResponse deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return ErrorResponseParser.fromJson(node);
        }
    }

    public static class MetadataUpdateSerializer
    extends JsonSerializer<MetadataUpdate> {
        @Override
        public void serialize(MetadataUpdate value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            MetadataUpdateParser.toJson(value, gen);
        }
    }

    public static class MetadataUpdateDeserializer
    extends JsonDeserializer<MetadataUpdate> {
        @Override
        public MetadataUpdate deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return MetadataUpdateParser.fromJson(node);
        }
    }

    public static class TableMetadataSerializer
    extends JsonSerializer<TableMetadata> {
        @Override
        public void serialize(TableMetadata metadata, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            TableMetadataParser.toJson(metadata, gen);
        }
    }

    public static class TableMetadataDeserializer
    extends JsonDeserializer<TableMetadata> {
        @Override
        public TableMetadata deserialize(JsonParser p, DeserializationContext context) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return TableMetadataParser.fromJson(node);
        }
    }

    public static class UpdateRequirementSerializer
    extends JsonSerializer<UpdateTableRequest.UpdateRequirement> {
        @Override
        public void serialize(UpdateTableRequest.UpdateRequirement value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            UpdateRequirementParser.toJson(value, gen);
        }
    }

    public static class UpdateRequirementDeserializer
    extends JsonDeserializer<UpdateTableRequest.UpdateRequirement> {
        @Override
        public UpdateTableRequest.UpdateRequirement deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JsonNode node = (JsonNode)p.getCodec().readTree(p);
            return UpdateRequirementParser.fromJson(node);
        }
    }
}

