/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.transforms;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import org.apache.iceberg.expressions.BoundLiteralPredicate;
import org.apache.iceberg.expressions.BoundPredicate;
import org.apache.iceberg.expressions.BoundSetPredicate;
import org.apache.iceberg.expressions.BoundTransform;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Literal;
import org.apache.iceberg.expressions.UnboundPredicate;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.transforms.Transform;

class ProjectionUtil {
    private ProjectionUtil() {
    }

    static <T> UnboundPredicate<T> truncateInteger(String name, BoundLiteralPredicate<Integer> pred, Transform<Integer, T> transform) {
        int boundary = pred.literal().value();
        switch (pred.op()) {
            case LT: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name, transform.apply(boundary - 1));
            }
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name, transform.apply(boundary));
            }
            case GT: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name, transform.apply(boundary + 1));
            }
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name, transform.apply(boundary));
            }
            case EQ: {
                return Expressions.predicate(pred.op(), name, transform.apply(boundary));
            }
        }
        return null;
    }

    static <T> UnboundPredicate<T> truncateIntegerStrict(String name, BoundLiteralPredicate<Integer> pred, Transform<Integer, T> transform) {
        int boundary = pred.literal().value();
        switch (pred.op()) {
            case LT: {
                return Expressions.predicate(Expression.Operation.LT, name, transform.apply(boundary));
            }
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT, name, transform.apply(boundary + 1));
            }
            case GT: {
                return Expressions.predicate(Expression.Operation.GT, name, transform.apply(boundary));
            }
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT, name, transform.apply(boundary - 1));
            }
            case NOT_EQ: {
                return Expressions.predicate(Expression.Operation.NOT_EQ, name, transform.apply(boundary));
            }
            case EQ: {
                return null;
            }
        }
        return null;
    }

    static <T> UnboundPredicate<T> truncateLongStrict(String name, BoundLiteralPredicate<Long> pred, Transform<Long, T> transform) {
        long boundary = pred.literal().value();
        switch (pred.op()) {
            case LT: {
                return Expressions.predicate(Expression.Operation.LT, name, transform.apply(boundary));
            }
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT, name, transform.apply(boundary + 1L));
            }
            case GT: {
                return Expressions.predicate(Expression.Operation.GT, name, transform.apply(boundary));
            }
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT, name, transform.apply(boundary - 1L));
            }
            case NOT_EQ: {
                return Expressions.predicate(Expression.Operation.NOT_EQ, name, transform.apply(boundary));
            }
            case EQ: {
                return null;
            }
        }
        return null;
    }

    static <T> UnboundPredicate<T> truncateLong(String name, BoundLiteralPredicate<Long> pred, Transform<Long, T> transform) {
        long boundary = pred.literal().value();
        switch (pred.op()) {
            case LT: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name, transform.apply(boundary - 1L));
            }
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name, transform.apply(boundary));
            }
            case GT: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name, transform.apply(boundary + 1L));
            }
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name, transform.apply(boundary));
            }
            case EQ: {
                return Expressions.predicate(pred.op(), name, transform.apply(boundary));
            }
        }
        return null;
    }

    static <T> UnboundPredicate<T> truncateDecimal(String name, BoundLiteralPredicate<BigDecimal> pred, Transform<BigDecimal, T> transform) {
        BigDecimal boundary = pred.literal().value();
        switch (pred.op()) {
            case LT: {
                BigDecimal minusOne = new BigDecimal(boundary.unscaledValue().subtract(BigInteger.ONE), boundary.scale());
                return Expressions.predicate(Expression.Operation.LT_EQ, name, transform.apply(minusOne));
            }
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name, transform.apply(boundary));
            }
            case GT: {
                BigDecimal plusOne = new BigDecimal(boundary.unscaledValue().add(BigInteger.ONE), boundary.scale());
                return Expressions.predicate(Expression.Operation.GT_EQ, name, transform.apply(plusOne));
            }
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name, transform.apply(boundary));
            }
            case EQ: {
                return Expressions.predicate(pred.op(), name, transform.apply(boundary));
            }
        }
        return null;
    }

    static <T> UnboundPredicate<T> truncateDecimalStrict(String name, BoundLiteralPredicate<BigDecimal> pred, Transform<BigDecimal, T> transform) {
        BigDecimal boundary = pred.literal().value();
        BigDecimal minusOne = new BigDecimal(boundary.unscaledValue().subtract(BigInteger.ONE), boundary.scale());
        BigDecimal plusOne = new BigDecimal(boundary.unscaledValue().add(BigInteger.ONE), boundary.scale());
        switch (pred.op()) {
            case LT: {
                return Expressions.predicate(Expression.Operation.LT, name, transform.apply(boundary));
            }
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT, name, transform.apply(plusOne));
            }
            case GT: {
                return Expressions.predicate(Expression.Operation.GT, name, transform.apply(boundary));
            }
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT, name, transform.apply(minusOne));
            }
            case NOT_EQ: {
                return Expressions.predicate(Expression.Operation.NOT_EQ, name, transform.apply(boundary));
            }
            case EQ: {
                return null;
            }
        }
        return null;
    }

    static <S, T> UnboundPredicate<T> truncateArray(String name, BoundLiteralPredicate<S> pred, Transform<S, T> transform) {
        S boundary = pred.literal().value();
        switch (pred.op()) {
            case LT: 
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT_EQ, name, transform.apply(boundary));
            }
            case GT: 
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT_EQ, name, transform.apply(boundary));
            }
            case EQ: {
                return Expressions.predicate(Expression.Operation.EQ, name, transform.apply(boundary));
            }
            case STARTS_WITH: {
                return Expressions.predicate(Expression.Operation.STARTS_WITH, name, transform.apply(boundary));
            }
        }
        return null;
    }

    static <S, T> UnboundPredicate<T> truncateArrayStrict(String name, BoundLiteralPredicate<S> pred, Transform<S, T> transform) {
        S boundary = pred.literal().value();
        switch (pred.op()) {
            case LT: 
            case LT_EQ: {
                return Expressions.predicate(Expression.Operation.LT, name, transform.apply(boundary));
            }
            case GT: 
            case GT_EQ: {
                return Expressions.predicate(Expression.Operation.GT, name, transform.apply(boundary));
            }
            case NOT_EQ: {
                return Expressions.predicate(Expression.Operation.NOT_EQ, name, transform.apply(boundary));
            }
            case EQ: {
                return null;
            }
        }
        return null;
    }

    static <T> UnboundPredicate<T> projectTransformPredicate(Transform<?, T> transform, String partitionName, BoundPredicate<?> pred) {
        if (pred.term() instanceof BoundTransform && transform.equals(((BoundTransform)pred.term()).transform())) {
            return ProjectionUtil.removeTransform(partitionName, pred);
        }
        return null;
    }

    private static <T> UnboundPredicate<T> removeTransform(String partitionName, BoundPredicate<T> pred) {
        if (pred.isUnaryPredicate()) {
            return Expressions.predicate(pred.op(), partitionName);
        }
        if (pred.isLiteralPredicate()) {
            return Expressions.predicate(pred.op(), partitionName, pred.asLiteralPredicate().literal());
        }
        if (pred.isSetPredicate()) {
            return Expressions.predicate(pred.op(), partitionName, pred.asSetPredicate().literalSet());
        }
        throw new UnsupportedOperationException("Cannot replace transform in unknown predicate: " + pred);
    }

    static <S, T> UnboundPredicate<T> transformSet(String fieldName, BoundSetPredicate<S> predicate, Transform<S, T> transform) {
        return Expressions.predicate(predicate.op(), fieldName, Iterables.transform(predicate.asSetPredicate().literalSet(), transform::apply));
    }

    static UnboundPredicate<Integer> fixInclusiveTimeProjection(UnboundPredicate<Integer> projected) {
        if (projected == null) {
            return projected;
        }
        switch (projected.op()) {
            case LT: {
                if (projected.literal().value() < 0) {
                    return Expressions.lessThan((UnboundTerm)projected.term(), Integer.valueOf(projected.literal().value() + 1));
                }
                return projected;
            }
            case LT_EQ: {
                if (projected.literal().value() < 0) {
                    return Expressions.lessThanOrEqual((UnboundTerm)projected.term(), Integer.valueOf(projected.literal().value() + 1));
                }
                return projected;
            }
            case GT: 
            case GT_EQ: {
                return projected;
            }
            case EQ: {
                if (projected.literal().value() < 0) {
                    return Expressions.in((UnboundTerm)projected.term(), projected.literal().value(), projected.literal().value() + 1);
                }
                return projected;
            }
            case IN: {
                HashSet<Integer> fixedSet = Sets.newHashSet();
                boolean hasNegativeValue = false;
                for (Literal<Integer> lit : projected.literals()) {
                    Integer value = lit.value();
                    fixedSet.add(value);
                    if (value >= 0) continue;
                    hasNegativeValue = true;
                    fixedSet.add(value + 1);
                }
                if (hasNegativeValue) {
                    return Expressions.in((UnboundTerm)projected.term(), fixedSet);
                }
                return projected;
            }
            case NOT_EQ: 
            case NOT_IN: {
                return null;
            }
        }
        return projected;
    }

    static UnboundPredicate<Integer> fixStrictTimeProjection(UnboundPredicate<Integer> projected) {
        if (projected == null) {
            return null;
        }
        switch (projected.op()) {
            case LT: 
            case LT_EQ: {
                return projected;
            }
            case GT: {
                if (projected.literal().value() <= 0) {
                    return Expressions.greaterThan((UnboundTerm)projected.term(), Integer.valueOf(projected.literal().value() + 1));
                }
                return projected;
            }
            case GT_EQ: {
                if (projected.literal().value() <= 0) {
                    return Expressions.greaterThanOrEqual((UnboundTerm)projected.term(), Integer.valueOf(projected.literal().value() + 1));
                }
                return projected;
            }
            case EQ: 
            case IN: {
                return null;
            }
            case NOT_EQ: {
                if (projected.literal().value() < 0) {
                    return Expressions.notIn((UnboundTerm)projected.term(), projected.literal().value(), projected.literal().value() + 1);
                }
                return projected;
            }
            case NOT_IN: {
                HashSet<Integer> fixedSet = Sets.newHashSet();
                boolean hasNegativeValue = false;
                for (Literal<Integer> lit : projected.literals()) {
                    Integer value = lit.value();
                    fixedSet.add(value);
                    if (value >= 0) continue;
                    hasNegativeValue = true;
                    fixedSet.add(value + 1);
                }
                if (hasNegativeValue) {
                    return Expressions.notIn((UnboundTerm)projected.term(), fixedSet);
                }
                return projected;
            }
        }
        return null;
    }
}

