/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.iceberg.BaseCombinedScanTask;
import org.apache.iceberg.BaseScanTaskGroup;
import org.apache.iceberg.CombinedScanTask;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.MergeableScanTask;
import org.apache.iceberg.ScanTask;
import org.apache.iceberg.ScanTaskGroup;
import org.apache.iceberg.SplittableScanTask;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.FluentIterable;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.util.BinPacking;

public class TableScanUtil {
    private TableScanUtil() {
    }

    public static boolean hasDeletes(CombinedScanTask task) {
        return task.files().stream().anyMatch(TableScanUtil::hasDeletes);
    }

    public static boolean hasEqDeletes(CombinedScanTask task) {
        return task.files().stream().anyMatch(t -> t.deletes().stream().anyMatch(deleteFile -> deleteFile.content().equals((Object)FileContent.EQUALITY_DELETES)));
    }

    public static boolean hasDeletes(FileScanTask task) {
        return !task.deletes().isEmpty();
    }

    public static CloseableIterable<FileScanTask> splitFiles(CloseableIterable<FileScanTask> tasks, long splitSize) {
        Preconditions.checkArgument(splitSize > 0L, "Invalid split size (negative or 0): %s", splitSize);
        FluentIterable splitTasks = FluentIterable.from(tasks).transformAndConcat(input -> input.split(splitSize));
        return CloseableIterable.combine(splitTasks, tasks);
    }

    public static CloseableIterable<CombinedScanTask> planTasks(CloseableIterable<FileScanTask> splitFiles, long splitSize, int lookback, long openFileCost) {
        Preconditions.checkArgument(splitSize > 0L, "Invalid split size (negative or 0): %s", splitSize);
        Preconditions.checkArgument(lookback > 0, "Invalid split planning lookback (negative or 0): %s", lookback);
        Preconditions.checkArgument(openFileCost >= 0L, "Invalid file open cost (negative): %s", openFileCost);
        Function<FileScanTask, Long> weightFunc = file -> Math.max(file.length() + file.deletes().stream().mapToLong(ContentFile::fileSizeInBytes).sum(), (long)(1 + file.deletes().size()) * openFileCost);
        return CloseableIterable.transform(CloseableIterable.combine(new BinPacking.PackingIterable<FileScanTask>(splitFiles, splitSize, lookback, weightFunc, true), splitFiles), BaseCombinedScanTask::new);
    }

    public static <T extends ScanTask> CloseableIterable<ScanTaskGroup<T>> planTaskGroups(CloseableIterable<T> tasks, long splitSize, int lookback, long openFileCost) {
        Preconditions.checkArgument(splitSize > 0L, "Invalid split size (negative or 0): %s", splitSize);
        Preconditions.checkArgument(lookback > 0, "Invalid split planning lookback (negative or 0): %s", lookback);
        Preconditions.checkArgument(openFileCost >= 0L, "Invalid file open cost (negative): %s", openFileCost);
        CloseableIterable splitTasks = CloseableIterable.combine(FluentIterable.from(tasks).transformAndConcat(task -> {
            if (task instanceof SplittableScanTask) {
                return ((SplittableScanTask)task).split(splitSize);
            }
            return ImmutableList.of(task);
        }), tasks);
        Function<ScanTask, Long> weightFunc = task -> Math.max(task.sizeBytes(), (long)task.filesCount() * openFileCost);
        return CloseableIterable.transform(CloseableIterable.combine(new BinPacking.PackingIterable<ScanTask>(splitTasks, splitSize, lookback, weightFunc, true), splitTasks), combinedTasks -> new BaseScanTaskGroup(TableScanUtil.mergeTasks(combinedTasks)));
    }

    public static <T extends ScanTask> List<T> mergeTasks(List<T> tasks) {
        ArrayList<ScanTask> mergedTasks = Lists.newArrayList();
        ScanTask lastTask = null;
        for (ScanTask task : tasks) {
            if (lastTask != null) {
                if (lastTask instanceof MergeableScanTask) {
                    MergeableScanTask mergeableLastTask = (MergeableScanTask)lastTask;
                    if (mergeableLastTask.canMerge(task)) {
                        lastTask = (ScanTask)mergeableLastTask.merge(task);
                        continue;
                    }
                    mergedTasks.add(lastTask);
                    lastTask = task;
                    continue;
                }
                mergedTasks.add(lastTask);
                lastTask = task;
                continue;
            }
            lastTask = task;
        }
        if (lastTask != null) {
            mergedTasks.add(lastTask);
        }
        return mergedTasks;
    }
}

