/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.hadoop.HadoopCatalog;
import org.apache.iceberg.hadoop.SerializableConfiguration;
import org.apache.iceberg.hive.HiveCatalog;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.IcebergCatalogType;

public class IcebergCatalogFactory
implements Serializable {
    private static final long serialVersionUID = -6003040601422350869L;
    private final String catalogName;
    private final IcebergCatalogType catalogType;
    private final String warehouse;
    private final String uri;

    public IcebergCatalogFactory(@NonNull String catalogName, @NonNull IcebergCatalogType catalogType, @NonNull String warehouse, String uri) {
        if (catalogName == null) {
            throw new NullPointerException("catalogName is marked @NonNull but is null");
        }
        if (catalogType == null) {
            throw new NullPointerException("catalogType is marked @NonNull but is null");
        }
        if (warehouse == null) {
            throw new NullPointerException("warehouse is marked @NonNull but is null");
        }
        this.catalogName = catalogName;
        this.catalogType = catalogType;
        this.warehouse = warehouse;
        this.uri = uri;
    }

    public Catalog create() {
        Configuration conf = new Configuration();
        SerializableConfiguration serializableConf = new SerializableConfiguration(conf);
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("warehouse", this.warehouse);
        switch (this.catalogType) {
            case HADOOP: {
                return IcebergCatalogFactory.hadoop(this.catalogName, serializableConf, properties);
            }
            case HIVE: {
                properties.put("uri", this.uri);
                return IcebergCatalogFactory.hive(this.catalogName, serializableConf, properties);
            }
        }
        throw new UnsupportedOperationException("Unsupported catalogType: " + (Object)((Object)this.catalogType));
    }

    private static Catalog hadoop(String catalogName, SerializableConfiguration conf, Map<String, String> properties) {
        return CatalogUtil.loadCatalog(HadoopCatalog.class.getName(), catalogName, properties, conf.get());
    }

    private static Catalog hive(String catalogName, SerializableConfiguration conf, Map<String, String> properties) {
        return CatalogUtil.loadCatalog(HiveCatalog.class.getName(), catalogName, properties, conf.get());
    }
}

