/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import lombok.NonNull;
import org.apache.iceberg.CachingCatalog;
import org.apache.iceberg.Table;
import org.apache.iceberg.catalog.Catalog;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.seatunnel.connectors.seatunnel.iceberg.IcebergCatalogFactory;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.SourceConfig;

public class IcebergTableLoader
implements Closeable,
Serializable {
    private static final long serialVersionUID = 9061073826700804273L;
    private final IcebergCatalogFactory icebergCatalogFactory;
    private final String tableIdentifierStr;
    private Catalog catalog;

    public IcebergTableLoader(@NonNull IcebergCatalogFactory icebergCatalogFactory, @NonNull TableIdentifier tableIdentifier) {
        if (icebergCatalogFactory == null) {
            throw new NullPointerException("icebergCatalogFactory is marked @NonNull but is null");
        }
        if (tableIdentifier == null) {
            throw new NullPointerException("tableIdentifier is marked @NonNull but is null");
        }
        this.icebergCatalogFactory = icebergCatalogFactory;
        this.tableIdentifierStr = tableIdentifier.toString();
    }

    public void open() {
        this.catalog = CachingCatalog.wrap(this.icebergCatalogFactory.create());
    }

    public Table loadTable() {
        TableIdentifier tableIdentifier = TableIdentifier.parse(this.tableIdentifierStr);
        Preconditions.checkArgument((boolean)this.catalog.tableExists(tableIdentifier), (Object)("Illegal source table: " + tableIdentifier));
        return this.catalog.loadTable(tableIdentifier);
    }

    @Override
    public void close() throws IOException {
        if (this.catalog != null && this.catalog instanceof Closeable) {
            ((Closeable)((Object)this.catalog)).close();
        }
    }

    public static IcebergTableLoader create(SourceConfig sourceConfig) {
        IcebergCatalogFactory catalogFactory = new IcebergCatalogFactory(sourceConfig.getCatalogName(), sourceConfig.getCatalogType(), sourceConfig.getWarehouse(), sourceConfig.getUri());
        return new IcebergTableLoader(catalogFactory, TableIdentifier.of(Namespace.of(sourceConfig.getNamespace()), sourceConfig.getTable()));
    }
}

