/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.config;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.Options;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.IcebergCatalogType;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

public class CommonConfig
implements Serializable {
    private static final long serialVersionUID = 239821141534421580L;
    public static final Option<String> KEY_CATALOG_NAME = Options.key((String)"catalog_name").stringType().noDefaultValue().withDescription(" the iceberg catalog name");
    public static final Option<IcebergCatalogType> KEY_CATALOG_TYPE = Options.key((String)"catalog_type").enumType(IcebergCatalogType.class).noDefaultValue().withDescription(" the iceberg catalog type");
    public static final Option<String> KEY_NAMESPACE = Options.key((String)"namespace").stringType().noDefaultValue().withDescription(" the iceberg namespace");
    public static final Option<String> KEY_TABLE = Options.key((String)"table").stringType().noDefaultValue().withDescription(" the iceberg table");
    public static final Option<String> KEY_URI = Options.key((String)"uri").stringType().noDefaultValue().withDescription(" the iceberg server uri");
    public static final Option<String> KEY_WAREHOUSE = Options.key((String)"warehouse").stringType().noDefaultValue().withDescription(" the iceberg warehouse");
    public static final Option<Boolean> KEY_CASE_SENSITIVE = Options.key((String)"case_sensitive").booleanType().defaultValue((Object)false).withDescription(" the iceberg case_sensitive");
    public static final Option<List<String>> KEY_FIELDS = Options.key((String)"fields").listType().noDefaultValue().withDescription(" the iceberg table fields");
    private String catalogName;
    private IcebergCatalogType catalogType;
    private String uri;
    private String warehouse;
    private String namespace;
    private String table;
    private boolean caseSensitive;

    public CommonConfig(Config pluginConfig) {
        String catalogType = this.checkArgumentNotNull(pluginConfig.getString(KEY_CATALOG_TYPE.key()));
        Preconditions.checkArgument((IcebergCatalogType.HADOOP.getType().equals(catalogType) || IcebergCatalogType.HIVE.getType().equals(catalogType) ? 1 : 0) != 0, (Object)("Illegal catalogType: " + catalogType));
        this.catalogType = IcebergCatalogType.valueOf(catalogType.toUpperCase());
        this.catalogName = this.checkArgumentNotNull(pluginConfig.getString(KEY_CATALOG_NAME.key()));
        if (pluginConfig.hasPath(KEY_URI.key())) {
            this.uri = this.checkArgumentNotNull(pluginConfig.getString(KEY_URI.key()));
        }
        this.warehouse = this.checkArgumentNotNull(pluginConfig.getString(KEY_WAREHOUSE.key()));
        this.namespace = this.checkArgumentNotNull(pluginConfig.getString(KEY_NAMESPACE.key()));
        this.table = this.checkArgumentNotNull(pluginConfig.getString(KEY_TABLE.key()));
        if (pluginConfig.hasPath(KEY_CASE_SENSITIVE.key())) {
            this.caseSensitive = pluginConfig.getBoolean(KEY_CASE_SENSITIVE.key());
        }
    }

    protected <T> T checkArgumentNotNull(T argument) {
        Preconditions.checkNotNull(argument);
        return argument;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public IcebergCatalogType getCatalogType() {
        return this.catalogType;
    }

    public String getUri() {
        return this.uri;
    }

    public String getWarehouse() {
        return this.warehouse;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getTable() {
        return this.table;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public String toString() {
        return "CommonConfig(catalogName=" + this.getCatalogName() + ", catalogType=" + (Object)((Object)this.getCatalogType()) + ", uri=" + this.getUri() + ", warehouse=" + this.getWarehouse() + ", namespace=" + this.getNamespace() + ", table=" + this.getTable() + ", caseSensitive=" + this.isCaseSensitive() + ")";
    }
}

