/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.data;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.connectors.seatunnel.iceberg.data.Deserializer;

public class DefaultDeserializer
implements Deserializer {
    @NonNull
    private final SeaTunnelRowType seaTunnelRowType;
    @NonNull
    private final Schema icebergSchema;

    @Override
    public SeaTunnelRow deserialize(@NonNull Record record) {
        if (record == null) {
            throw new NullPointerException("record is marked @NonNull but is null");
        }
        SeaTunnelRow seaTunnelRow = new SeaTunnelRow(this.seaTunnelRowType.getTotalFields());
        for (int i = 0; i < this.seaTunnelRowType.getTotalFields(); ++i) {
            String seaTunnelFieldName = this.seaTunnelRowType.getFieldName(i);
            SeaTunnelDataType seaTunnelFieldType = this.seaTunnelRowType.getFieldType(i);
            Types.NestedField icebergField = this.icebergSchema.findField(seaTunnelFieldName);
            Object icebergValue = record.getField(seaTunnelFieldName);
            seaTunnelRow.setField(i, this.convert(icebergField.type(), icebergValue, seaTunnelFieldType));
        }
        return seaTunnelRow;
    }

    private Object convert(@NonNull Type icebergType, Object icebergValue, @NonNull SeaTunnelDataType<?> seaTunnelType) {
        if (icebergType == null) {
            throw new NullPointerException("icebergType is marked @NonNull but is null");
        }
        if (seaTunnelType == null) {
            throw new NullPointerException("seaTunnelType is marked @NonNull but is null");
        }
        if (icebergValue == null) {
            return null;
        }
        switch (icebergType.typeId()) {
            case BOOLEAN: {
                return Boolean.class.cast(icebergValue);
            }
            case INTEGER: {
                return Integer.class.cast(icebergValue);
            }
            case LONG: {
                return Long.class.cast(icebergValue);
            }
            case FLOAT: {
                return Float.class.cast(icebergValue);
            }
            case DOUBLE: {
                return Double.class.cast(icebergValue);
            }
            case DATE: {
                return LocalDate.class.cast(icebergValue);
            }
            case TIME: {
                return LocalTime.class.cast(icebergValue);
            }
            case TIMESTAMP: {
                Types.TimestampType timestampType = (Types.TimestampType)icebergType;
                if (timestampType.shouldAdjustToUTC()) {
                    return ((OffsetDateTime)OffsetDateTime.class.cast(icebergValue)).toLocalDateTime();
                }
                return LocalDateTime.class.cast(icebergValue);
            }
            case STRING: {
                return String.class.cast(icebergValue);
            }
            case FIXED: {
                return byte[].class.cast(icebergValue);
            }
            case BINARY: {
                return ((ByteBuffer)ByteBuffer.class.cast(icebergValue)).array();
            }
            case DECIMAL: {
                return BigDecimal.class.cast(icebergValue);
            }
            case STRUCT: {
                Record icebergStruct = (Record)Record.class.cast(icebergValue);
                Types.StructType icebergStructType = (Types.StructType)icebergType;
                SeaTunnelRowType seaTunnelRowType = (SeaTunnelRowType)seaTunnelType;
                SeaTunnelRow seatunnelRow = new SeaTunnelRow(seaTunnelRowType.getTotalFields());
                for (int i = 0; i < seaTunnelRowType.getTotalFields(); ++i) {
                    String seatunnelFieldName = seaTunnelRowType.getFieldName(i);
                    Object seatunnelFieldValue = this.convert(icebergStructType.fieldType(seatunnelFieldName), icebergStruct.getField(seatunnelFieldName), seaTunnelRowType.getFieldType(i));
                    seatunnelRow.setField(i, seatunnelFieldValue);
                }
                return seatunnelRow;
            }
            case LIST: {
                List icebergList = (List)List.class.cast(icebergValue);
                Types.ListType icebergListType = (Types.ListType)icebergType;
                ArrayList<Object> seatunnelList = new ArrayList<Object>(icebergList.size());
                ArrayType seatunnelListType = (ArrayType)seaTunnelType;
                for (int i = 0; i < icebergList.size(); ++i) {
                    seatunnelList.add(this.convert(icebergListType.elementType(), icebergList.get(i), (SeaTunnelDataType<?>)seatunnelListType.getElementType()));
                }
                return seatunnelList.toArray();
            }
            case MAP: {
                Map icebergMap = (Map)Map.class.cast(icebergValue);
                Types.MapType icebergMapType = (Types.MapType)icebergType;
                HashMap<Object, Object> seatunnelMap = new HashMap<Object, Object>();
                MapType seatunnelMapType = (MapType)seaTunnelType;
                for (Map.Entry entry : icebergMap.entrySet()) {
                    seatunnelMap.put(this.convert(icebergMapType.keyType(), entry.getKey(), seatunnelMapType.getKeyType()), this.convert(icebergMapType.valueType(), entry.getValue(), seatunnelMapType.getValueType()));
                }
                return seatunnelMap;
            }
        }
        throw new UnsupportedOperationException("Unsupported iceberg type: " + icebergType);
    }

    public DefaultDeserializer(@NonNull SeaTunnelRowType seaTunnelRowType, @NonNull Schema icebergSchema) {
        if (seaTunnelRowType == null) {
            throw new NullPointerException("seaTunnelRowType is marked @NonNull but is null");
        }
        if (icebergSchema == null) {
            throw new NullPointerException("icebergSchema is marked @NonNull but is null");
        }
        this.seaTunnelRowType = seaTunnelRowType;
        this.icebergSchema = icebergSchema;
    }
}

