/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.data;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;

public class IcebergTypeMapper {
    public static SeaTunnelDataType<?> mapping(@NonNull Type icebergType) {
        if (icebergType == null) {
            throw new NullPointerException("icebergType is marked @NonNull but is null");
        }
        switch (icebergType.typeId()) {
            case BOOLEAN: {
                return BasicType.BOOLEAN_TYPE;
            }
            case INTEGER: {
                return BasicType.INT_TYPE;
            }
            case LONG: {
                return BasicType.LONG_TYPE;
            }
            case FLOAT: {
                return BasicType.FLOAT_TYPE;
            }
            case DOUBLE: {
                return BasicType.DOUBLE_TYPE;
            }
            case DATE: {
                return LocalTimeType.LOCAL_DATE_TYPE;
            }
            case TIME: {
                return LocalTimeType.LOCAL_TIME_TYPE;
            }
            case TIMESTAMP: {
                return LocalTimeType.LOCAL_DATE_TIME_TYPE;
            }
            case STRING: {
                return BasicType.STRING_TYPE;
            }
            case FIXED: 
            case BINARY: {
                return PrimitiveByteArrayType.INSTANCE;
            }
            case DECIMAL: {
                Types.DecimalType decimalType = (Types.DecimalType)icebergType;
                return new DecimalType(decimalType.precision(), decimalType.scale());
            }
            case STRUCT: {
                return IcebergTypeMapper.mappingStructType((Types.StructType)icebergType);
            }
            case LIST: {
                return IcebergTypeMapper.mappingListType((Types.ListType)icebergType);
            }
            case MAP: {
                return IcebergTypeMapper.mappingMapType((Types.MapType)icebergType);
            }
        }
        throw new UnsupportedOperationException("Unsupported iceberg data type: " + (Object)((Object)icebergType.typeId()));
    }

    private static SeaTunnelRowType mappingStructType(Types.StructType structType) {
        List<Types.NestedField> fields = structType.fields();
        ArrayList<String> fieldNames = new ArrayList<String>(fields.size());
        ArrayList fieldTypes = new ArrayList(fields.size());
        for (Types.NestedField field : fields) {
            fieldNames.add(field.name());
            fieldTypes.add(IcebergTypeMapper.mapping(field.type()));
        }
        return new SeaTunnelRowType(fieldNames.toArray(new String[0]), fieldTypes.toArray(new SeaTunnelDataType[0]));
    }

    private static ArrayType mappingListType(Types.ListType listType) {
        switch (listType.elementType().typeId()) {
            case BOOLEAN: {
                return ArrayType.BOOLEAN_ARRAY_TYPE;
            }
            case INTEGER: {
                return ArrayType.INT_ARRAY_TYPE;
            }
            case LONG: {
                return ArrayType.LONG_ARRAY_TYPE;
            }
            case FLOAT: {
                return ArrayType.FLOAT_ARRAY_TYPE;
            }
            case DOUBLE: {
                return ArrayType.DOUBLE_ARRAY_TYPE;
            }
            case STRING: {
                return ArrayType.STRING_ARRAY_TYPE;
            }
        }
        throw new UnsupportedOperationException("Unsupported iceberg list element type: " + (Object)((Object)listType.elementType().typeId()));
    }

    private static MapType mappingMapType(Types.MapType mapType) {
        return new MapType(IcebergTypeMapper.mapping(mapType.keyType()), IcebergTypeMapper.mapping(mapType.valueType()));
    }
}

