/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.source;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Types;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.common.PrepareFailException;
import org.apache.seatunnel.api.source.Boundedness;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.api.source.SourceReader;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.connectors.seatunnel.common.schema.SeaTunnelSchema;
import org.apache.seatunnel.connectors.seatunnel.iceberg.IcebergTableLoader;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.CommonConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.SourceConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.data.IcebergTypeMapper;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.IcebergBatchSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.IcebergSplitEnumeratorState;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.IcebergStreamSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.scan.IcebergScanContext;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.reader.IcebergSourceReader;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.split.IcebergFileScanTaskSplit;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={SeaTunnelSource.class})
public class IcebergSource
implements SeaTunnelSource<SeaTunnelRow, IcebergFileScanTaskSplit, IcebergSplitEnumeratorState> {
    private static final long serialVersionUID = 4343414808223919870L;
    private SourceConfig sourceConfig;
    private Schema tableSchema;
    private Schema projectedSchema;
    private SeaTunnelRowType seaTunnelRowType;
    private JobContext jobContext;

    public String getPluginName() {
        return "Iceberg";
    }

    public void prepare(Config pluginConfig) throws PrepareFailException {
        this.sourceConfig = SourceConfig.loadConfig(pluginConfig);
        this.tableSchema = this.loadIcebergSchema(this.sourceConfig);
        this.seaTunnelRowType = this.loadSeaTunnelRowType(this.tableSchema, pluginConfig);
        this.projectedSchema = this.tableSchema.select(this.seaTunnelRowType.getFieldNames());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Schema loadIcebergSchema(SourceConfig sourceConfig) {
        try (IcebergTableLoader icebergTableLoader = IcebergTableLoader.create(sourceConfig);){
            icebergTableLoader.open();
            Schema schema = icebergTableLoader.loadTable().schema();
            return schema;
        }
    }

    private SeaTunnelRowType loadSeaTunnelRowType(Schema tableSchema, Config pluginConfig) {
        ArrayList<String> columnNames = new ArrayList<String>(tableSchema.columns().size());
        ArrayList columnDataTypes = new ArrayList(tableSchema.columns().size());
        for (Types.NestedField column : tableSchema.columns()) {
            columnNames.add(column.name());
            columnDataTypes.add(IcebergTypeMapper.mapping(column.type()));
        }
        SeaTunnelRowType originalRowType = new SeaTunnelRowType(columnNames.toArray(new String[0]), columnDataTypes.toArray(new SeaTunnelDataType[0]));
        CheckResult checkResult = CheckConfigUtil.checkAllExists((Config)pluginConfig, (String[])new String[]{CommonConfig.KEY_FIELDS.key()});
        if (checkResult.isSuccess()) {
            SeaTunnelSchema configSchema = SeaTunnelSchema.buildWithConfig(pluginConfig);
            SeaTunnelRowType projectedRowType = configSchema.getSeaTunnelRowType();
            for (int i = 0; i < projectedRowType.getFieldNames().length; ++i) {
                String fieldName = projectedRowType.getFieldName(i);
                SeaTunnelDataType projectedFieldType = projectedRowType.getFieldType(i);
                int originalFieldIndex = originalRowType.indexOf(fieldName);
                SeaTunnelDataType originalFieldType = originalRowType.getFieldType(originalFieldIndex);
                Preconditions.checkArgument((boolean)projectedFieldType.equals(originalFieldType), (Object)String.format("Illegal field: %s, original: %s <-> projected: %s", fieldName, originalFieldType, projectedFieldType));
            }
            return projectedRowType;
        }
        return originalRowType;
    }

    public Boundedness getBoundedness() {
        return JobMode.BATCH.equals((Object)this.jobContext.getJobMode()) ? Boundedness.BOUNDED : Boundedness.UNBOUNDED;
    }

    public void setJobContext(JobContext jobContext) {
        this.jobContext = jobContext;
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.seaTunnelRowType;
    }

    public SourceReader<SeaTunnelRow, IcebergFileScanTaskSplit> createReader(SourceReader.Context readerContext) {
        return new IcebergSourceReader(readerContext, this.seaTunnelRowType, this.tableSchema, this.projectedSchema, this.sourceConfig);
    }

    public SourceSplitEnumerator<IcebergFileScanTaskSplit, IcebergSplitEnumeratorState> createEnumerator(SourceSplitEnumerator.Context<IcebergFileScanTaskSplit> enumeratorContext) {
        if (Boundedness.BOUNDED.equals((Object)this.getBoundedness())) {
            return new IcebergBatchSplitEnumerator(enumeratorContext, IcebergScanContext.scanContext(this.sourceConfig, this.projectedSchema), this.sourceConfig, null);
        }
        return new IcebergStreamSplitEnumerator(enumeratorContext, IcebergScanContext.streamScanContext(this.sourceConfig, this.projectedSchema), this.sourceConfig, null);
    }

    public SourceSplitEnumerator<IcebergFileScanTaskSplit, IcebergSplitEnumeratorState> restoreEnumerator(SourceSplitEnumerator.Context<IcebergFileScanTaskSplit> enumeratorContext, IcebergSplitEnumeratorState checkpointState) {
        if (Boundedness.BOUNDED.equals((Object)this.getBoundedness())) {
            return new IcebergBatchSplitEnumerator(enumeratorContext, IcebergScanContext.scanContext(this.sourceConfig, this.projectedSchema), this.sourceConfig, checkpointState);
        }
        return new IcebergStreamSplitEnumerator(enumeratorContext, IcebergScanContext.streamScanContext(this.sourceConfig, this.projectedSchema), this.sourceConfig, checkpointState);
    }
}

