/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;
import org.apache.iceberg.Table;
import org.apache.seatunnel.api.source.SourceSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.SourceConfig;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.AbstractSplitEnumerator;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.IcebergEnumerationResult;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.IcebergEnumeratorPosition;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.IcebergSplitEnumeratorState;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.scan.IcebergScanContext;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.enumerator.scan.IcebergScanSplitPlanner;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.split.IcebergFileScanTaskSplit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IcebergStreamSplitEnumerator
extends AbstractSplitEnumerator {
    private static final Logger log = LoggerFactory.getLogger(IcebergStreamSplitEnumerator.class);
    private final IcebergScanContext icebergScanContext;
    private final AtomicReference<IcebergEnumeratorPosition> enumeratorPosition;

    public IcebergStreamSplitEnumerator(@NonNull SourceSplitEnumerator.Context<IcebergFileScanTaskSplit> context, @NonNull IcebergScanContext icebergScanContext, @NonNull SourceConfig sourceConfig, IcebergSplitEnumeratorState restoreState) {
        super(context, sourceConfig, restoreState != null ? restoreState.getPendingSplits() : Collections.emptyMap());
        if (context == null) {
            throw new NullPointerException("context is marked @NonNull but is null");
        }
        if (icebergScanContext == null) {
            throw new NullPointerException("icebergScanContext is marked @NonNull but is null");
        }
        if (sourceConfig == null) {
            throw new NullPointerException("sourceConfig is marked @NonNull but is null");
        }
        this.icebergScanContext = icebergScanContext;
        this.enumeratorPosition = new AtomicReference();
        if (restoreState != null) {
            this.enumeratorPosition.set(restoreState.getLastEnumeratedPosition());
        }
    }

    public IcebergSplitEnumeratorState snapshotState(long checkpointId) throws Exception {
        return new IcebergSplitEnumeratorState(this.enumeratorPosition.get(), this.pendingSplits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleSplitRequest(int subtaskId) {
        IcebergStreamSplitEnumerator icebergStreamSplitEnumerator = this;
        synchronized (icebergStreamSplitEnumerator) {
            if (this.pendingSplits.isEmpty() || this.pendingSplits.get(subtaskId) == null) {
                this.refreshPendingSplits();
            }
            this.assignPendingSplits(Collections.singleton(subtaskId));
        }
    }

    @Override
    protected List<IcebergFileScanTaskSplit> loadNewSplits(Table table) {
        IcebergEnumerationResult result = IcebergScanSplitPlanner.planStreamSplits(table, this.icebergScanContext, this.enumeratorPosition.get());
        if (!Objects.equals(result.getFromPosition(), this.enumeratorPosition.get())) {
            log.info("Skip {} loaded splits because the scan starting position doesn't match the current enumerator position: enumerator position = {}, scan starting position = {}", new Object[]{result.getSplits().size(), this.enumeratorPosition.get(), result.getFromPosition()});
            return Collections.emptyList();
        }
        this.enumeratorPosition.set(result.getToPosition());
        log.debug("Update enumerator position to {}", (Object)result.getToPosition());
        return result.getSplits();
    }
}

