/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.source.reader;

import java.io.Closeable;
import java.io.IOException;
import lombok.NonNull;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.connectors.seatunnel.iceberg.data.Deserializer;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.reader.IcebergFileScanTaskReader;
import org.apache.seatunnel.connectors.seatunnel.iceberg.source.split.IcebergFileScanTaskSplit;

public class IcebergFileScanTaskSplitReader
implements Closeable {
    private Deserializer deserializer;
    private IcebergFileScanTaskReader icebergFileScanTaskReader;

    public CloseableIterator<SeaTunnelRow> open(@NonNull IcebergFileScanTaskSplit split) {
        if (split == null) {
            throw new NullPointerException("split is marked @NonNull but is null");
        }
        CloseableIterator<Record> iterator = this.icebergFileScanTaskReader.open(split.getTask());
        OffsetSeekIterator<Record> seekIterator = new OffsetSeekIterator<Record>(iterator);
        seekIterator.seek(split.getRecordOffset());
        return CloseableIterator.transform(seekIterator, record -> {
            SeaTunnelRow seaTunnelRow = this.deserializer.deserialize((Record)record);
            split.setRecordOffset(split.getRecordOffset() + 1L);
            return seaTunnelRow;
        });
    }

    @Override
    public void close() {
        this.icebergFileScanTaskReader.close();
    }

    public IcebergFileScanTaskSplitReader(Deserializer deserializer, IcebergFileScanTaskReader icebergFileScanTaskReader) {
        this.deserializer = deserializer;
        this.icebergFileScanTaskReader = icebergFileScanTaskReader;
    }

    private static class OffsetSeekIterator<T>
    implements CloseableIterator<T> {
        private final CloseableIterator<T> iterator;

        public void seek(long startingRecordOffset) {
            for (long i = 0L; i < startingRecordOffset; ++i) {
                if (!this.hasNext()) {
                    throw new IllegalStateException(String.format("Invalid starting record offset %d", startingRecordOffset));
                }
                this.next();
            }
        }

        @Override
        public void close() throws IOException {
            this.iterator.close();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public T next() {
            return (T)this.iterator.next();
        }

        public OffsetSeekIterator(CloseableIterator<T> iterator) {
            this.iterator = iterator;
        }
    }
}

