/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.compress.hadoop;

import io.airlift.compress.hadoop.HadoopOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.io.compress.CompressionOutputStream;

final class CompressionOutputStreamAdapter
extends CompressionOutputStream {
    private static final OutputStream FAKE_OUTPUT_STREAM = new OutputStream(){

        @Override
        public void write(int b) {
            throw new UnsupportedOperationException();
        }
    };
    private final HadoopOutputStream output;

    public CompressionOutputStreamAdapter(HadoopOutputStream output) {
        super(FAKE_OUTPUT_STREAM);
        this.output = output;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.output.write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.output.write(b);
    }

    @Override
    public void finish() throws IOException {
        this.output.finish();
    }

    @Override
    public void resetState() {
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.output.close();
        }
    }
}

