/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.Set;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.MergingSnapshotProducer;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Evaluator;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Projections;
import org.apache.iceberg.expressions.StrictMetricsEvaluator;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;

public class BaseOverwriteFiles
extends MergingSnapshotProducer<OverwriteFiles>
implements OverwriteFiles {
    private final Set<DataFile> deletedDataFiles = Sets.newHashSet();
    private boolean validateAddedFilesMatchOverwriteFilter = false;
    private Long startingSnapshotId = null;
    private Expression conflictDetectionFilter = null;
    private boolean validateNewDataFiles = false;
    private boolean validateNewDeletes = false;

    protected BaseOverwriteFiles(String tableName, TableOperations ops) {
        super(tableName, ops);
    }

    @Override
    protected OverwriteFiles self() {
        return this;
    }

    @Override
    protected String operation() {
        return "overwrite";
    }

    @Override
    public OverwriteFiles overwriteByRowFilter(Expression expr) {
        this.deleteByRowFilter(expr);
        return this;
    }

    @Override
    public OverwriteFiles addFile(DataFile file) {
        this.add(file);
        return this;
    }

    @Override
    public OverwriteFiles deleteFile(DataFile file) {
        this.deletedDataFiles.add(file);
        this.delete(file);
        return this;
    }

    @Override
    public OverwriteFiles validateAddedFilesMatchOverwriteFilter() {
        this.validateAddedFilesMatchOverwriteFilter = true;
        return this;
    }

    @Override
    public OverwriteFiles validateFromSnapshot(long snapshotId) {
        this.startingSnapshotId = snapshotId;
        return this;
    }

    @Override
    public OverwriteFiles conflictDetectionFilter(Expression newConflictDetectionFilter) {
        Preconditions.checkArgument(newConflictDetectionFilter != null, "Conflict detection filter cannot be null");
        this.conflictDetectionFilter = newConflictDetectionFilter;
        return this;
    }

    @Override
    public OverwriteFiles validateNoConflictingData() {
        this.validateNewDataFiles = true;
        this.failMissingDeletePaths();
        return this;
    }

    @Override
    public OverwriteFiles validateNoConflictingDeletes() {
        this.validateNewDeletes = true;
        this.failMissingDeletePaths();
        return this;
    }

    @Override
    public BaseOverwriteFiles toBranch(String branch) {
        this.targetBranch(branch);
        return this;
    }

    @Override
    protected void validate(TableMetadata base, Snapshot parent) {
        if (this.validateAddedFilesMatchOverwriteFilter) {
            PartitionSpec spec = this.dataSpec();
            Expression rowFilter = this.rowFilter();
            Expression inclusiveExpr = Projections.inclusive(spec).project(rowFilter);
            Evaluator inclusive = new Evaluator(spec.partitionType(), inclusiveExpr);
            Expression strictExpr = Projections.strict(spec).project(rowFilter);
            Evaluator strict = new Evaluator(spec.partitionType(), strictExpr);
            StrictMetricsEvaluator metrics = new StrictMetricsEvaluator(base.schema(), rowFilter, this.isCaseSensitive());
            for (DataFile file : this.addedDataFiles()) {
                ValidationException.check(inclusive.eval(file.partition()) && (strict.eval(file.partition()) || metrics.eval(file)), "Cannot append file with rows that do not match filter: %s: %s", rowFilter, file.path());
            }
        }
        if (this.validateNewDataFiles) {
            this.validateAddedDataFiles(base, this.startingSnapshotId, this.dataConflictDetectionFilter(), parent);
        }
        if (this.validateNewDeletes) {
            if (this.rowFilter() != Expressions.alwaysFalse()) {
                Expression filter = this.conflictDetectionFilter != null ? this.conflictDetectionFilter : this.rowFilter();
                this.validateNoNewDeleteFiles(base, this.startingSnapshotId, filter, parent);
                this.validateDeletedDataFiles(base, this.startingSnapshotId, filter, parent);
            }
            if (this.deletedDataFiles.size() > 0) {
                this.validateNoNewDeletesForDataFiles(base, this.startingSnapshotId, this.conflictDetectionFilter, this.deletedDataFiles, parent);
            }
        }
    }

    private Expression dataConflictDetectionFilter() {
        if (this.conflictDetectionFilter != null) {
            return this.conflictDetectionFilter;
        }
        if (this.rowFilter() != Expressions.alwaysFalse() && this.deletedDataFiles.isEmpty()) {
            return this.rowFilter();
        }
        return Expressions.alwaysTrue();
    }
}

