/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.hive;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.PrincipalType;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.iceberg.BaseMetastoreCatalog;
import org.apache.iceberg.CatalogUtil;
import org.apache.iceberg.ClientPool;
import org.apache.iceberg.TableMetadata;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.SupportsNamespaces;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NamespaceNotEmptyException;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.hive.CachedClientPool;
import org.apache.iceberg.hive.HiveHadoopUtil;
import org.apache.iceberg.hive.HiveTableOperations;
import org.apache.iceberg.hive.MetastoreUtil;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.MoreObjects;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.LocationUtil;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveCatalog
extends BaseMetastoreCatalog
implements SupportsNamespaces,
Configurable {
    public static final String LIST_ALL_TABLES = "list-all-tables";
    public static final String LIST_ALL_TABLES_DEFAULT = "false";
    public static final String HMS_TABLE_OWNER = "hive.metastore.table.owner";
    public static final String HMS_DB_OWNER = "hive.metastore.database.owner";
    public static final String HMS_DB_OWNER_TYPE = "hive.metastore.database.owner-type";
    static final String HIVE_CONF_CATALOG = "metastore.catalog.default";
    private static final Logger LOG = LoggerFactory.getLogger(HiveCatalog.class);
    private String name;
    private Configuration conf;
    private FileIO fileIO;
    private ClientPool<IMetaStoreClient, TException> clients;
    private boolean listAllTables = false;
    private Map<String, String> catalogProperties;

    @Override
    public void initialize(String inputName, Map<String, String> properties) {
        this.catalogProperties = ImmutableMap.copyOf(properties);
        this.name = inputName;
        if (this.conf == null) {
            LOG.warn("No Hadoop Configuration was set, using the default environment Configuration");
            this.conf = new Configuration();
        }
        if (properties.containsKey("uri")) {
            this.conf.set(HiveConf.ConfVars.METASTOREURIS.varname, properties.get("uri"));
        }
        if (properties.containsKey("warehouse")) {
            this.conf.set(HiveConf.ConfVars.METASTOREWAREHOUSE.varname, LocationUtil.stripTrailingSlash(properties.get("warehouse")));
        }
        this.listAllTables = Boolean.parseBoolean(properties.getOrDefault(LIST_ALL_TABLES, LIST_ALL_TABLES_DEFAULT));
        String fileIOImpl = properties.get("io-impl");
        this.fileIO = fileIOImpl == null ? new HadoopFileIO(this.conf) : CatalogUtil.loadFileIO(fileIOImpl, properties, this.conf);
        this.clients = new CachedClientPool(this.conf, properties);
    }

    @Override
    public List<TableIdentifier> listTables(Namespace namespace) {
        Preconditions.checkArgument(this.isValidateNamespace(namespace), "Missing database in namespace: %s", (Object)namespace);
        String database = namespace.level(0);
        try {
            List<TableIdentifier> tableIdentifiers;
            List tableNames = this.clients.run(client -> client.getAllTables(database));
            if (this.listAllTables) {
                tableIdentifiers = tableNames.stream().map(t -> TableIdentifier.of(namespace, t)).collect(Collectors.toList());
            } else {
                List tableObjects = this.clients.run(client -> client.getTableObjectsByName(database, tableNames));
                tableIdentifiers = tableObjects.stream().filter(table -> table.getParameters() != null && "iceberg".equalsIgnoreCase((String)table.getParameters().get("table_type"))).map(table -> TableIdentifier.of(namespace, table.getTableName())).collect(Collectors.toList());
            }
            LOG.debug("Listing of namespace: {} resulted in the following tables: {}", (Object)namespace, tableIdentifiers);
            return tableIdentifiers;
        }
        catch (UnknownDBException e) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", namespace);
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all tables under namespace " + namespace, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to listTables", e);
        }
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean dropTable(TableIdentifier identifier, boolean purge) {
        if (!this.isValidIdentifier(identifier)) {
            return false;
        }
        String database = identifier.namespace().level(0);
        TableOperations ops = this.newTableOps(identifier);
        TableMetadata lastMetadata = null;
        if (purge) {
            try {
                lastMetadata = ops.current();
            }
            catch (NotFoundException e) {
                LOG.warn("Failed to load table metadata for table: {}, continuing drop without purge", (Object)identifier, (Object)e);
            }
        }
        try {
            this.clients.run(client -> {
                client.dropTable(database, identifier.name(), false, false);
                return null;
            });
            if (purge && lastMetadata != null) {
                CatalogUtil.dropTableData(ops.io(), lastMetadata);
            }
            LOG.info("Dropped table: {}", (Object)identifier);
            return true;
        }
        catch (NoSuchObjectException | NoSuchTableException e) {
            LOG.info("Skipping drop, table does not exist: {}", (Object)identifier, (Object)e);
            return false;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to drop " + identifier, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to dropTable", e);
        }
    }

    @Override
    public void renameTable(TableIdentifier from, TableIdentifier originalTo) {
        if (!this.isValidIdentifier(from)) {
            throw new NoSuchTableException("Invalid identifier: %s", from);
        }
        TableIdentifier to = this.removeCatalogName(originalTo);
        Preconditions.checkArgument(this.isValidIdentifier(to), "Invalid identifier: %s", (Object)to);
        String toDatabase = to.namespace().level(0);
        String fromDatabase = from.namespace().level(0);
        String fromName = from.name();
        try {
            Table table = this.clients.run(client -> client.getTable(fromDatabase, fromName));
            HiveTableOperations.validateTableIsIceberg(table, HiveCatalog.fullTableName(this.name, from));
            table.setDbName(toDatabase);
            table.setTableName(to.name());
            this.clients.run(client -> {
                MetastoreUtil.alterTable(client, fromDatabase, fromName, table);
                return null;
            });
            LOG.info("Renamed table from {}, to {}", (Object)from, (Object)to);
        }
        catch (NoSuchObjectException e) {
            throw new NoSuchTableException("Table does not exist: %s", from);
        }
        catch (AlreadyExistsException e) {
            throw new org.apache.iceberg.exceptions.AlreadyExistsException("Table already exists: %s", to);
        }
        catch (TException e) {
            throw new RuntimeException("Failed to rename " + from + " to " + to, e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to rename", e);
        }
    }

    @Override
    public void createNamespace(Namespace namespace, Map<String, String> meta) {
        Preconditions.checkArgument(!namespace.isEmpty(), "Cannot create namespace with invalid name: %s", (Object)namespace);
        Preconditions.checkArgument(this.isValidateNamespace(namespace), "Cannot support multi part namespace in Hive Metastore: %s", (Object)namespace);
        Preconditions.checkArgument(meta.get(HMS_DB_OWNER_TYPE) == null || meta.get(HMS_DB_OWNER) != null, "Create namespace setting %s without setting %s is not allowed", (Object)HMS_DB_OWNER_TYPE, (Object)HMS_DB_OWNER);
        try {
            this.clients.run(client -> {
                client.createDatabase(this.convertToDatabase(namespace, meta));
                return null;
            });
            LOG.info("Created namespace: {}", (Object)namespace);
        }
        catch (AlreadyExistsException e) {
            throw new org.apache.iceberg.exceptions.AlreadyExistsException(e, "Namespace '%s' already exists!", namespace);
        }
        catch (TException e) {
            throw new RuntimeException("Failed to create namespace " + namespace + " in Hive Metastore", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to createDatabase(name) " + namespace + " in Hive Metastore", e);
        }
    }

    @Override
    public List<Namespace> listNamespaces(Namespace namespace) {
        if (!this.isValidateNamespace(namespace) && !namespace.isEmpty()) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", namespace);
        }
        if (!namespace.isEmpty()) {
            return ImmutableList.of();
        }
        try {
            List<Namespace> namespaces = this.clients.run(IMetaStoreClient::getAllDatabases).stream().map(xva$0 -> Namespace.of(xva$0)).collect(Collectors.toList());
            LOG.debug("Listing namespace {} returned tables: {}", (Object)namespace, namespaces);
            return namespaces;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list all namespace: " + namespace + " in Hive Metastore", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to getAllDatabases() " + namespace + " in Hive Metastore", e);
        }
    }

    @Override
    public boolean dropNamespace(Namespace namespace) {
        if (!this.isValidateNamespace(namespace)) {
            return false;
        }
        try {
            this.clients.run(client -> {
                client.dropDatabase(namespace.level(0), false, false, false);
                return null;
            });
            LOG.info("Dropped namespace: {}", (Object)namespace);
            return true;
        }
        catch (InvalidOperationException e) {
            throw new NamespaceNotEmptyException(e, "Namespace %s is not empty. One or more tables exist.", namespace);
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        catch (TException e) {
            throw new RuntimeException("Failed to drop namespace " + namespace + " in Hive Metastore", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to drop dropDatabase(name) " + namespace + " in Hive Metastore", e);
        }
    }

    @Override
    public boolean setProperties(Namespace namespace, Map<String, String> properties) {
        Preconditions.checkArgument(properties.get(HMS_DB_OWNER_TYPE) == null == (properties.get(HMS_DB_OWNER) == null), "Setting %s and %s has to be performed together or not at all", (Object)HMS_DB_OWNER_TYPE, (Object)HMS_DB_OWNER);
        HashMap<String, String> parameter = Maps.newHashMap();
        parameter.putAll(this.loadNamespaceMetadata(namespace));
        parameter.putAll(properties);
        Database database = this.convertToDatabase(namespace, parameter);
        this.alterHiveDataBase(namespace, database);
        LOG.debug("Successfully set properties {} for {}", properties.keySet(), (Object)namespace);
        return true;
    }

    @Override
    public boolean removeProperties(Namespace namespace, Set<String> properties) {
        Preconditions.checkArgument(properties.contains(HMS_DB_OWNER_TYPE) == properties.contains(HMS_DB_OWNER), "Removing %s and %s has to be performed together or not at all", (Object)HMS_DB_OWNER_TYPE, (Object)HMS_DB_OWNER);
        HashMap<String, String> parameter = Maps.newHashMap();
        parameter.putAll(this.loadNamespaceMetadata(namespace));
        properties.forEach(key -> {
            String cfr_ignored_0 = parameter.put((String)key, (String)null);
        });
        Database database = this.convertToDatabase(namespace, parameter);
        this.alterHiveDataBase(namespace, database);
        LOG.debug("Successfully removed properties {} from {}", properties, (Object)namespace);
        return true;
    }

    private void alterHiveDataBase(Namespace namespace, Database database) {
        try {
            this.clients.run(client -> {
                client.alterDatabase(namespace.level(0), database);
                return null;
            });
        }
        catch (NoSuchObjectException | UnknownDBException e) {
            throw new NoSuchNamespaceException(e, "Namespace does not exist: %s", namespace);
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list namespace under namespace: " + namespace + " in Hive Metastore", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to getDatabase(name) " + namespace + " in Hive Metastore", e);
        }
    }

    @Override
    public Map<String, String> loadNamespaceMetadata(Namespace namespace) {
        if (!this.isValidateNamespace(namespace)) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", namespace);
        }
        try {
            Database database = this.clients.run(client -> client.getDatabase(namespace.level(0)));
            Map<String, String> metadata = this.convertToMetadata(database);
            LOG.debug("Loaded metadata for namespace {} found {}", (Object)namespace, metadata.keySet());
            return metadata;
        }
        catch (NoSuchObjectException | UnknownDBException e) {
            throw new NoSuchNamespaceException(e, "Namespace does not exist: %s", namespace);
        }
        catch (TException e) {
            throw new RuntimeException("Failed to list namespace under namespace: " + namespace + " in Hive Metastore", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted in call to getDatabase(name) " + namespace + " in Hive Metastore", e);
        }
    }

    @Override
    protected boolean isValidIdentifier(TableIdentifier tableIdentifier) {
        return tableIdentifier.namespace().levels().length == 1;
    }

    private TableIdentifier removeCatalogName(TableIdentifier to) {
        if (this.isValidIdentifier(to)) {
            return to;
        }
        if (to.namespace().levels().length == 2 && this.name().equalsIgnoreCase(to.namespace().level(0))) {
            return TableIdentifier.of(Namespace.of(to.namespace().level(1)), to.name());
        }
        return to;
    }

    private boolean isValidateNamespace(Namespace namespace) {
        return namespace.levels().length == 1;
    }

    @Override
    public TableOperations newTableOps(TableIdentifier tableIdentifier) {
        String dbName = tableIdentifier.namespace().level(0);
        String tableName = tableIdentifier.name();
        return new HiveTableOperations(this.conf, this.clients, this.fileIO, this.name, dbName, tableName);
    }

    @Override
    protected String defaultWarehouseLocation(TableIdentifier tableIdentifier) {
        try {
            Database databaseData = this.clients.run(client -> client.getDatabase(tableIdentifier.namespace().levels()[0]));
            if (databaseData.getLocationUri() != null) {
                return String.format("%s/%s", databaseData.getLocationUri(), tableIdentifier.name());
            }
        }
        catch (TException e) {
            throw new RuntimeException(String.format("Metastore operation failed for %s", tableIdentifier), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Interrupted during commit", e);
        }
        String databaseLocation = this.databaseLocation(tableIdentifier.namespace().levels()[0]);
        return String.format("%s/%s", databaseLocation, tableIdentifier.name());
    }

    private String databaseLocation(String databaseName) {
        String warehouseLocation = this.conf.get(HiveConf.ConfVars.METASTOREWAREHOUSE.varname);
        Preconditions.checkNotNull(warehouseLocation, "Warehouse location is not set: hive.metastore.warehouse.dir=null");
        warehouseLocation = LocationUtil.stripTrailingSlash(warehouseLocation);
        return String.format("%s/%s.db", warehouseLocation, databaseName);
    }

    private Map<String, String> convertToMetadata(Database database) {
        HashMap<String, String> meta = Maps.newHashMap();
        meta.putAll(database.getParameters());
        meta.put("location", database.getLocationUri());
        if (database.getDescription() != null) {
            meta.put("comment", database.getDescription());
        }
        if (database.getOwnerName() != null) {
            meta.put(HMS_DB_OWNER, database.getOwnerName());
            if (database.getOwnerType() != null) {
                meta.put(HMS_DB_OWNER_TYPE, database.getOwnerType().name());
            }
        }
        return meta;
    }

    Database convertToDatabase(Namespace namespace, Map<String, String> meta) {
        if (!this.isValidateNamespace(namespace)) {
            throw new NoSuchNamespaceException("Namespace does not exist: %s", namespace);
        }
        Database database = new Database();
        HashMap parameter = Maps.newHashMap();
        database.setName(namespace.level(0));
        database.setLocationUri(this.databaseLocation(namespace.level(0)));
        meta.forEach((key, value) -> {
            if (key.equals("comment")) {
                database.setDescription(value);
            } else if (key.equals("location")) {
                database.setLocationUri(value);
            } else if (key.equals(HMS_DB_OWNER)) {
                database.setOwnerName(value);
            } else if (key.equals(HMS_DB_OWNER_TYPE) && value != null) {
                database.setOwnerType(PrincipalType.valueOf((String)value));
            } else if (value != null) {
                parameter.put(key, value);
            }
        });
        if (database.getOwnerName() == null) {
            database.setOwnerName(HiveHadoopUtil.currentUser());
            database.setOwnerType(PrincipalType.USER);
        }
        database.setParameters(parameter);
        return database;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("name", this.name).add("uri", this.conf == null ? "" : this.conf.get(HiveConf.ConfVars.METASTOREURIS.varname)).toString();
    }

    @Override
    public void setConf(Configuration conf) {
        this.conf = new Configuration(conf);
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    protected Map<String, String> properties() {
        return this.catalogProperties == null ? ImmutableMap.of() : this.catalogProperties;
    }

    @VisibleForTesting
    void setListAllTables(boolean listAllTables) {
        this.listAllTables = listAllTables;
    }

    @VisibleForTesting
    ClientPool<IMetaStoreClient, TException> clientPool() {
        return this.clients;
    }
}

