/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.metrics;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.metrics.ScanMetricsResult;
import org.apache.iceberg.metrics.ScanReport;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ScanReport", generator="Immutables")
@Immutable
public final class ImmutableScanReport
implements ScanReport {
    private final String tableName;
    private final long snapshotId;
    private final Expression filter;
    private final int schemaId;
    private final List<Integer> projectedFieldIds;
    private final List<String> projectedFieldNames;
    private final ScanMetricsResult scanMetrics;
    private final Map<String, String> metadata;

    private ImmutableScanReport(String tableName, long snapshotId, Expression filter, int schemaId, List<Integer> projectedFieldIds, List<String> projectedFieldNames, ScanMetricsResult scanMetrics, Map<String, String> metadata) {
        this.tableName = tableName;
        this.snapshotId = snapshotId;
        this.filter = filter;
        this.schemaId = schemaId;
        this.projectedFieldIds = projectedFieldIds;
        this.projectedFieldNames = projectedFieldNames;
        this.scanMetrics = scanMetrics;
        this.metadata = metadata;
    }

    @Override
    public String tableName() {
        return this.tableName;
    }

    @Override
    public long snapshotId() {
        return this.snapshotId;
    }

    @Override
    public Expression filter() {
        return this.filter;
    }

    @Override
    public int schemaId() {
        return this.schemaId;
    }

    @Override
    public List<Integer> projectedFieldIds() {
        return this.projectedFieldIds;
    }

    @Override
    public List<String> projectedFieldNames() {
        return this.projectedFieldNames;
    }

    @Override
    public ScanMetricsResult scanMetrics() {
        return this.scanMetrics;
    }

    @Override
    public Map<String, String> metadata() {
        return this.metadata;
    }

    public final ImmutableScanReport withTableName(String value) {
        String newValue = Objects.requireNonNull(value, "tableName");
        if (this.tableName.equals(newValue)) {
            return this;
        }
        return new ImmutableScanReport(newValue, this.snapshotId, this.filter, this.schemaId, this.projectedFieldIds, this.projectedFieldNames, this.scanMetrics, this.metadata);
    }

    public final ImmutableScanReport withSnapshotId(long value) {
        if (this.snapshotId == value) {
            return this;
        }
        return new ImmutableScanReport(this.tableName, value, this.filter, this.schemaId, this.projectedFieldIds, this.projectedFieldNames, this.scanMetrics, this.metadata);
    }

    public final ImmutableScanReport withFilter(Expression value) {
        if (this.filter == value) {
            return this;
        }
        Expression newValue = Objects.requireNonNull(value, "filter");
        return new ImmutableScanReport(this.tableName, this.snapshotId, newValue, this.schemaId, this.projectedFieldIds, this.projectedFieldNames, this.scanMetrics, this.metadata);
    }

    public final ImmutableScanReport withSchemaId(int value) {
        if (this.schemaId == value) {
            return this;
        }
        return new ImmutableScanReport(this.tableName, this.snapshotId, this.filter, value, this.projectedFieldIds, this.projectedFieldNames, this.scanMetrics, this.metadata);
    }

    public final ImmutableScanReport withProjectedFieldIds(int ... elements) {
        ArrayList<Integer> wrappedList = new ArrayList<Integer>(elements.length);
        for (int element : elements) {
            wrappedList.add(element);
        }
        List<Integer> newValue = ImmutableScanReport.createUnmodifiableList(false, wrappedList);
        return new ImmutableScanReport(this.tableName, this.snapshotId, this.filter, this.schemaId, newValue, this.projectedFieldNames, this.scanMetrics, this.metadata);
    }

    public final ImmutableScanReport withProjectedFieldIds(Iterable<Integer> elements) {
        if (this.projectedFieldIds == elements) {
            return this;
        }
        List<Integer> newValue = ImmutableScanReport.createUnmodifiableList(false, ImmutableScanReport.createSafeList(elements, true, false));
        return new ImmutableScanReport(this.tableName, this.snapshotId, this.filter, this.schemaId, newValue, this.projectedFieldNames, this.scanMetrics, this.metadata);
    }

    public final ImmutableScanReport withProjectedFieldNames(String ... elements) {
        List<String> newValue = ImmutableScanReport.createUnmodifiableList(false, ImmutableScanReport.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableScanReport(this.tableName, this.snapshotId, this.filter, this.schemaId, this.projectedFieldIds, newValue, this.scanMetrics, this.metadata);
    }

    public final ImmutableScanReport withProjectedFieldNames(Iterable<String> elements) {
        if (this.projectedFieldNames == elements) {
            return this;
        }
        List<String> newValue = ImmutableScanReport.createUnmodifiableList(false, ImmutableScanReport.createSafeList(elements, true, false));
        return new ImmutableScanReport(this.tableName, this.snapshotId, this.filter, this.schemaId, this.projectedFieldIds, newValue, this.scanMetrics, this.metadata);
    }

    public final ImmutableScanReport withScanMetrics(ScanMetricsResult value) {
        if (this.scanMetrics == value) {
            return this;
        }
        ScanMetricsResult newValue = Objects.requireNonNull(value, "scanMetrics");
        return new ImmutableScanReport(this.tableName, this.snapshotId, this.filter, this.schemaId, this.projectedFieldIds, this.projectedFieldNames, newValue, this.metadata);
    }

    public final ImmutableScanReport withMetadata(Map<String, ? extends String> entries) {
        if (this.metadata == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableScanReport.createUnmodifiableMap(true, false, entries);
        return new ImmutableScanReport(this.tableName, this.snapshotId, this.filter, this.schemaId, this.projectedFieldIds, this.projectedFieldNames, this.scanMetrics, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScanReport && this.equalTo(0, (ImmutableScanReport)another);
    }

    private boolean equalTo(int synthetic, ImmutableScanReport another) {
        return this.tableName.equals(another.tableName) && this.snapshotId == another.snapshotId && this.filter.equals(another.filter) && this.schemaId == another.schemaId && this.projectedFieldIds.equals(another.projectedFieldIds) && this.projectedFieldNames.equals(another.projectedFieldNames) && this.scanMetrics.equals(another.scanMetrics) && this.metadata.equals(another.metadata);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.tableName.hashCode();
        h2 += (h2 << 5) + Long.hashCode(this.snapshotId);
        h2 += (h2 << 5) + this.filter.hashCode();
        h2 += (h2 << 5) + this.schemaId;
        h2 += (h2 << 5) + this.projectedFieldIds.hashCode();
        h2 += (h2 << 5) + this.projectedFieldNames.hashCode();
        h2 += (h2 << 5) + this.scanMetrics.hashCode();
        h2 += (h2 << 5) + this.metadata.hashCode();
        return h2;
    }

    public String toString() {
        return "ScanReport{tableName=" + this.tableName + ", snapshotId=" + this.snapshotId + ", filter=" + this.filter + ", schemaId=" + this.schemaId + ", projectedFieldIds=" + this.projectedFieldIds + ", projectedFieldNames=" + this.projectedFieldNames + ", scanMetrics=" + this.scanMetrics + ", metadata=" + this.metadata + "}";
    }

    public static ImmutableScanReport copyOf(ScanReport instance) {
        if (instance instanceof ImmutableScanReport) {
            return (ImmutableScanReport)instance;
        }
        return ImmutableScanReport.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="ScanReport", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TABLE_NAME = 1L;
        private static final long INIT_BIT_SNAPSHOT_ID = 2L;
        private static final long INIT_BIT_FILTER = 4L;
        private static final long INIT_BIT_SCHEMA_ID = 8L;
        private static final long INIT_BIT_SCAN_METRICS = 16L;
        private long initBits = 31L;
        @Nullable
        private String tableName;
        private long snapshotId;
        @Nullable
        private Expression filter;
        private int schemaId;
        private List<Integer> projectedFieldIds = new ArrayList<Integer>();
        private List<String> projectedFieldNames = new ArrayList<String>();
        @Nullable
        private ScanMetricsResult scanMetrics;
        private Map<String, String> metadata = new LinkedHashMap<String, String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ScanReport instance) {
            Objects.requireNonNull(instance, "instance");
            this.tableName(instance.tableName());
            this.snapshotId(instance.snapshotId());
            this.filter(instance.filter());
            this.schemaId(instance.schemaId());
            this.addAllProjectedFieldIds(instance.projectedFieldIds());
            this.addAllProjectedFieldNames(instance.projectedFieldNames());
            this.scanMetrics(instance.scanMetrics());
            this.putAllMetadata(instance.metadata());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tableName(String tableName) {
            this.tableName = Objects.requireNonNull(tableName, "tableName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder snapshotId(long snapshotId) {
            this.snapshotId = snapshotId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder filter(Expression filter) {
            this.filter = Objects.requireNonNull(filter, "filter");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schemaId(int schemaId) {
            this.schemaId = schemaId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProjectedFieldIds(int element) {
            this.projectedFieldIds.add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProjectedFieldIds(int ... elements) {
            for (int element : elements) {
                this.projectedFieldIds.add(element);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder projectedFieldIds(Iterable<Integer> elements) {
            this.projectedFieldIds.clear();
            return this.addAllProjectedFieldIds(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllProjectedFieldIds(Iterable<Integer> elements) {
            for (Integer element : elements) {
                this.projectedFieldIds.add(Objects.requireNonNull(element, "projectedFieldIds element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProjectedFieldNames(String element) {
            this.projectedFieldNames.add(Objects.requireNonNull(element, "projectedFieldNames element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addProjectedFieldNames(String ... elements) {
            for (String element : elements) {
                this.projectedFieldNames.add(Objects.requireNonNull(element, "projectedFieldNames element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder projectedFieldNames(Iterable<String> elements) {
            this.projectedFieldNames.clear();
            return this.addAllProjectedFieldNames(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllProjectedFieldNames(Iterable<String> elements) {
            for (String element : elements) {
                this.projectedFieldNames.add(Objects.requireNonNull(element, "projectedFieldNames element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder scanMetrics(ScanMetricsResult scanMetrics) {
            this.scanMetrics = Objects.requireNonNull(scanMetrics, "scanMetrics");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMetadata(String key, String value) {
            this.metadata.put(Objects.requireNonNull(key, "metadata key"), value == null ? Objects.requireNonNull(value, "metadata value for key: " + key) : value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putMetadata(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.metadata.put(Objects.requireNonNull(k, "metadata key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "metadata value for key: " + k) : v);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder metadata(Map<String, ? extends String> entries) {
            this.metadata.clear();
            return this.putAllMetadata(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllMetadata(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.metadata.put(Objects.requireNonNull(k, "metadata key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "metadata value for key: " + k) : v);
            }
            return this;
        }

        public ImmutableScanReport build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableScanReport(this.tableName, this.snapshotId, this.filter, this.schemaId, ImmutableScanReport.createUnmodifiableList(true, this.projectedFieldIds), ImmutableScanReport.createUnmodifiableList(true, this.projectedFieldNames), this.scanMetrics, ImmutableScanReport.createUnmodifiableMap(false, false, this.metadata));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("tableName");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("snapshotId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("filter");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("schemaId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("scanMetrics");
            }
            return "Cannot build ScanReport, some of required attributes are not set " + attributes;
        }
    }
}

