/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.parquet;

import java.util.List;
import org.apache.iceberg.parquet.ParquetSchemaUtil;
import org.apache.iceberg.parquet.ParquetTypeVisitor;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.schema.GroupType;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.schema.MessageType;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.schema.PrimitiveType;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.schema.Type;
import org.apache.seatunnel.shade.connector-iceberg.org.apache.parquet.schema.Types;

public class RemoveIds
extends ParquetTypeVisitor<Type> {
    @Override
    public Type message(MessageType message, List<Type> fields) {
        Types.MessageTypeBuilder builder = Types.buildMessage();
        for (Type field : ((Type)this.struct(message.asGroupType(), (List)fields)).asGroupType().getFields()) {
            builder.addField(field);
        }
        return builder.named(message.getName());
    }

    @Override
    public Type struct(GroupType struct, List<Type> fields) {
        Types.GroupBuilder<GroupType> builder = Types.buildGroup(struct.getRepetition());
        for (Type field : fields) {
            builder.addField(field);
        }
        return (Type)builder.named(struct.getName());
    }

    @Override
    public Type list(GroupType array, Type item) {
        Types.GroupBuilder listBuilder = (Types.GroupBuilder)Types.buildGroup(array.getRepetition()).as(LogicalTypeAnnotation.listType());
        Type listElement = ParquetSchemaUtil.determineListElementType(array);
        if (listElement.isRepetition(Type.Repetition.REPEATED)) {
            listBuilder.addFields(item);
        } else {
            ((Types.GroupBuilder)listBuilder.repeatedGroup().addFields(item)).named(array.getFieldName(0));
        }
        return (Type)listBuilder.named(array.getName());
    }

    @Override
    public Type map(GroupType map, Type key, Type value) {
        return (Type)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildGroup(map.getRepetition()).as(LogicalTypeAnnotation.mapType())).repeatedGroup().addFields(key, value)).named(map.getFieldName(0))).named(map.getName());
    }

    @Override
    public Type primitive(PrimitiveType primitive) {
        return (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.primitive(primitive.getPrimitiveTypeName(), primitive.getRepetition()).length(primitive.getTypeLength())).as(primitive.getLogicalTypeAnnotation())).named(primitive.getName());
    }

    public static MessageType removeIds(MessageType type) {
        return (MessageType)ParquetTypeVisitor.visit(type, new RemoveIds());
    }
}

