/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.net.ssl.SSLException;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.concurrent.CancellableDependency;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;

class ExponentialHttpRequestRetryStrategy
implements HttpRequestRetryStrategy {
    private final int maxRetries;
    private final Set<Class<? extends IOException>> nonRetriableExceptions;
    private final Set<Integer> retriableCodes;

    ExponentialHttpRequestRetryStrategy(int maximumRetries) {
        Preconditions.checkArgument(maximumRetries > 0, "Cannot set retries to %s, the value must be positive", maximumRetries);
        this.maxRetries = maximumRetries;
        this.retriableCodes = ImmutableSet.of(Integer.valueOf(429), Integer.valueOf(503));
        this.nonRetriableExceptions = ImmutableSet.of(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, ConnectionClosedException.class, NoRouteToHostException.class, SSLException.class, new Class[0]);
    }

    @Override
    public boolean retryRequest(HttpRequest request, IOException exception, int execCount, HttpContext context) {
        if (execCount > this.maxRetries) {
            return false;
        }
        if (this.nonRetriableExceptions.contains(exception.getClass())) {
            return false;
        }
        for (Class<? extends IOException> rejectException : this.nonRetriableExceptions) {
            if (!rejectException.isInstance(exception)) continue;
            return false;
        }
        if (request instanceof CancellableDependency && ((CancellableDependency)((Object)request)).isCancelled()) {
            return false;
        }
        return Method.isIdempotent(request.getMethod());
    }

    @Override
    public boolean retryRequest(HttpResponse response, int execCount, HttpContext context) {
        return execCount <= this.maxRetries && this.retriableCodes.contains(response.getCode());
    }

    @Override
    public TimeValue getRetryInterval(HttpResponse response, int execCount, HttpContext context) {
        Header header = response.getFirstHeader("Retry-After");
        TimeValue retryAfter = null;
        if (header != null) {
            block4: {
                String value = header.getValue();
                try {
                    retryAfter = TimeValue.ofSeconds(Long.parseLong(value));
                }
                catch (NumberFormatException ignore) {
                    Instant retryAfterDate = DateUtils.parseStandardDate(value);
                    if (retryAfterDate == null) break block4;
                    retryAfter = TimeValue.ofMilliseconds(retryAfterDate.toEpochMilli() - System.currentTimeMillis());
                }
            }
            if (TimeValue.isPositive(retryAfter)) {
                return retryAfter;
            }
        }
        int delayMillis = 1000 * (int)Math.min(Math.pow(2.0, (long)execCount - 1L), 64.0);
        int jitter = ThreadLocalRandom.current().nextInt(Math.max(1, (int)((double)delayMillis * 0.1)));
        return TimeValue.ofMilliseconds(delayMillis + jitter);
    }
}

