/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.responses;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.List;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.util.JsonUtil;

public class ErrorResponseParser {
    private static final String ERROR = "error";
    private static final String MESSAGE = "message";
    private static final String TYPE = "type";
    private static final String CODE = "code";
    private static final String STACK = "stack";

    private ErrorResponseParser() {
    }

    public static String toJson(ErrorResponse errorResponse) {
        return ErrorResponseParser.toJson(errorResponse, false);
    }

    public static String toJson(ErrorResponse errorResponse, boolean pretty) {
        return JsonUtil.generate(gen -> ErrorResponseParser.toJson(errorResponse, gen), pretty);
    }

    public static void toJson(ErrorResponse errorResponse, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        generator.writeObjectFieldStart(ERROR);
        generator.writeStringField(MESSAGE, errorResponse.message());
        generator.writeStringField(TYPE, errorResponse.type());
        generator.writeNumberField(CODE, errorResponse.code());
        if (errorResponse.stack() != null) {
            JsonUtil.writeStringArray(STACK, errorResponse.stack(), generator);
        }
        generator.writeEndObject();
        generator.writeEndObject();
    }

    public static ErrorResponse fromJson(String json) {
        return JsonUtil.parse(json, ErrorResponseParser::fromJson);
    }

    public static ErrorResponse fromJson(JsonNode jsonNode) {
        Preconditions.checkArgument(jsonNode != null && jsonNode.isObject(), "Cannot parse error response from non-object value: %s", (Object)jsonNode);
        Preconditions.checkArgument(jsonNode.has(ERROR), "Cannot parse missing field: error");
        JsonNode error = JsonUtil.get(ERROR, jsonNode);
        String message = JsonUtil.getStringOrNull(MESSAGE, error);
        String type = JsonUtil.getStringOrNull(TYPE, error);
        Integer code = JsonUtil.getIntOrNull(CODE, error);
        List<String> stack = JsonUtil.getStringListOrNull(STACK, error);
        return ErrorResponse.builder().withMessage(message).withType(type).responseCode(code).withStackTrace(stack).build();
    }
}

