/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.connectors.seatunnel.iceberg.catalog;

import com.google.auto.service.AutoService;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.table.catalog.Catalog;
import org.apache.seatunnel.api.table.factory.CatalogFactory;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.connectors.seatunnel.iceberg.catalog.IcebergCatalog;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.IcebergCommonOptions;
import org.apache.seatunnel.connectors.seatunnel.iceberg.config.IcebergSourceOptions;

@AutoService(value={Factory.class})
public class IcebergCatalogFactory
implements CatalogFactory {
    public Catalog createCatalog(String catalogName, ReadonlyConfig options) {
        return new IcebergCatalog(catalogName, options);
    }

    public String factoryIdentifier() {
        return "Iceberg";
    }

    public OptionRule optionRule() {
        return OptionRule.builder().required(new Option[]{IcebergCommonOptions.KEY_CATALOG_NAME, IcebergCommonOptions.KEY_NAMESPACE, IcebergCommonOptions.KEY_TABLE, IcebergCommonOptions.CATALOG_PROPS}).optional(new Option[]{IcebergCommonOptions.HADOOP_PROPS, IcebergCommonOptions.KERBEROS_PRINCIPAL, IcebergCommonOptions.KERBEROS_KEYTAB_PATH, IcebergCommonOptions.KRB5_PATH, IcebergSourceOptions.KEY_CASE_SENSITIVE}).build();
    }
}

